/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.jmx;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.jmx.AbstractTestContainer;
import org.exoplatform.container.jmx.support.ManagedComponentRequestLifeCycle;
import org.exoplatform.container.jmx.support.ManagedDependent;
import org.exoplatform.container.jmx.support.ManagedManagementAware;
import org.exoplatform.container.jmx.support.ManagedWithObjectNameTemplate;

public class TestRootContainerManagedIntegration
extends AbstractTestContainer {
    public void _testExplicitObjectName() throws Exception {
        RootContainer container = this.createRootContainer("configuration1.xml");
        Object expectedObject = container.getComponentInstance((Object)"ManagedWithExplicitObjectName");
        TestRootContainerManagedIntegration.assertNotNull((Object)expectedObject);
        MBeanServer server = container.getMBeanServer();
        TestRootContainerManagedIntegration.assertNotNull((Object)server);
        Object object = server.getAttribute(ObjectName.getInstance("exo:object=ManagedWithExplicitObjectName"), "Reference");
        TestRootContainerManagedIntegration.assertNotNull((Object)object);
        TestRootContainerManagedIntegration.assertEquals((Object)expectedObject, (Object)object);
    }

    public void testObjectNameTemplate() throws Exception {
        RootContainer container = this.createRootContainer("configuration2.xml");
        Object expectedFoo = container.getComponentInstance((Object)"Foo");
        Object expectedBar = container.getComponentInstance((Object)"Bar");
        TestRootContainerManagedIntegration.assertNotNull((Object)expectedFoo);
        TestRootContainerManagedIntegration.assertNotNull((Object)expectedBar);
        MBeanServer server = container.getMBeanServer();
        TestRootContainerManagedIntegration.assertNotNull((Object)server);
        Object foo = server.getAttribute(ObjectName.getInstance("exo:object=Foo"), "Reference");
        TestRootContainerManagedIntegration.assertNotNull((Object)foo);
        Object bar = server.getAttribute(ObjectName.getInstance("exo:object=Bar"), "Reference");
        TestRootContainerManagedIntegration.assertNotNull((Object)bar);
        TestRootContainerManagedIntegration.assertEquals((Object)expectedFoo, (Object)foo);
        TestRootContainerManagedIntegration.assertEquals((Object)expectedBar, (Object)bar);
    }

    public void _testObjectNameTemplateOverriddenByExplicitObjectName() throws Exception {
        RootContainer container = this.createRootContainer("configuration3.xml");
        Object expectedObject = container.getComponentInstance((Object)"ManagedWithObjectNameTemplateOverriddenByExplicitObjectName");
        TestRootContainerManagedIntegration.assertNotNull((Object)expectedObject);
        MBeanServer server = container.getMBeanServer();
        TestRootContainerManagedIntegration.assertNotNull((Object)server);
        Object object = server.getAttribute(ObjectName.getInstance("exo:object=ManagedWithObjectNameTemplateOverriddenByExplicitObjectName"), "Reference");
        TestRootContainerManagedIntegration.assertNotNull((Object)object);
        TestRootContainerManagedIntegration.assertEquals((Object)expectedObject, (Object)object);
    }

    public void testManagementAware() throws Exception {
        RootContainer container = this.createRootContainer("configuration4.xml");
        ManagedManagementAware aware = (ManagedManagementAware)container.getComponentInstance((Object)"ManagedManagementAware");
        TestRootContainerManagedIntegration.assertNotNull((Object)aware.context);
        MBeanServer server = container.getMBeanServer();
        TestRootContainerManagedIntegration.assertNotNull((Object)server);
        Object foo = server.getAttribute(ObjectName.getInstance("exo:object=Foo"), "Reference");
        TestRootContainerManagedIntegration.assertNotNull((Object)foo);
        TestRootContainerManagedIntegration.assertEquals((Object)aware.foo, (Object)foo);
        ManagedDependent expectedBar = new ManagedDependent("Bar");
        aware.context.register((Object)expectedBar);
        TestRootContainerManagedIntegration.assertEquals((int)1, (int)server.queryMBeans(ObjectName.getInstance("exo:object=Bar"), null).size());
        Object bar = server.getAttribute(ObjectName.getInstance("exo:object=Bar"), "Reference");
        TestRootContainerManagedIntegration.assertEquals((Object)expectedBar, (Object)bar);
        aware.context.unregister((Object)expectedBar);
        TestRootContainerManagedIntegration.assertEquals((int)0, (int)server.queryMBeans(ObjectName.getInstance("exo:object=Bar"), null).size());
    }

    public void testManagementAwareManagingOtherBeans() throws Exception {
        RootContainer container = this.createRootContainer("configuration4.xml");
        ManagedManagementAware aware = (ManagedManagementAware)container.getComponentInstance((Object)"ManagedManagementAware");
        aware.context.register((Object)new ManagedWithObjectNameTemplate("juu"));
        container.getMBeanServer().getObjectInstance(new ObjectName("exo:object=juu"));
    }

    public void testRootManagedRequestLifeCycle() throws Exception {
        RootContainer container = this.createRootContainer("configuration5.xml");
        ManagedComponentRequestLifeCycle component = (ManagedComponentRequestLifeCycle)container.getComponentInstanceOfType(ManagedComponentRequestLifeCycle.class);
        TestRootContainerManagedIntegration.assertNotNull((Object)component);
        MBeanServer server = container.getMBeanServer();
        server.invoke(new ObjectName("exo:object=ManagedComponentRequestLifeCycle"), "foo", new Object[0], new String[0]);
        TestRootContainerManagedIntegration.assertEquals((int)1, (int)component.startCount);
        TestRootContainerManagedIntegration.assertEquals((int)1, (int)component.fooCount);
        TestRootContainerManagedIntegration.assertEquals((int)1, (int)component.endCount);
        TestRootContainerManagedIntegration.assertSame((Object)container, (Object)component.startContainer);
        TestRootContainerManagedIntegration.assertSame((Object)container, (Object)component.endContainer);
    }
}

