/**
 * This file is part of the Meeds project (https://meeds.io/).
 *
 * Copyright (C) 2020 - 2025 Meeds Association contact@meeds.io
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package org.exoplatform.container.context;

import java.lang.annotation.Annotation;

import javax.enterprise.context.spi.Context;

/**
 * The entry point to a {@link Context}
 * 
 */
public interface ContextManager
{
   /**
    * Gives the context corresponding to the given scope
    * @param scope the annotation class corresponding to the scope
    * @return the {@link Context} corresponding to the given scope
    */
   <K> AdvancedContext<K> getContext(Class<? extends Annotation> scope);

   /**
    * Indicates whether or not a context has a been registered for the given scope 
    * @param scope the scope of the context
    * @return <code>true</code> if it exists a context for the given scope, <code>false</code> otherwise
    */
   boolean hasContext(Class<? extends Annotation> scope);

   /**
    * Registers a context
    * @param ctx the {@link Context} to register
    */
   <K> void addContext(AdvancedContext<K> ctx);
}
