/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.configuration;

import org.exoplatform.container.configuration.AbstractProfileTest;
import org.exoplatform.container.xml.Configuration;

public class TestImportWithProperties
extends AbstractProfileTest {
    private String oldValue;

    protected void setUp() throws Exception {
        super.setUp();
        this.oldValue = System.getProperty("db.configuration.path");
        System.clearProperty("db.configuration.path");
    }

    protected void tearDown() throws Exception {
        if (this.oldValue == null) {
            System.clearProperty("db.configuration.path");
        } else {
            System.setProperty("db.configuration.path", this.oldValue);
        }
        super.tearDown();
    }

    public void testWithNoPropertyDefined() throws Exception {
        TestImportWithProperties.assertNull((Object)System.getProperty("db.configuration.path"));
        Configuration config = this.getConfiguration("import-with-parameter-configuration.xml", new String[0]);
        TestImportWithProperties.assertEquals((int)3, (int)config.getImports().size());
        TestImportWithProperties.assertEquals((String)"${db.configuration.path}/db.xml", (String)((String)config.getImports().get(0)));
        TestImportWithProperties.assertEquals((String)(System.getProperty("java.io.tmpdir") + "/bindfile.xml"), (String)((String)config.getImports().get(1)));
        TestImportWithProperties.assertEquals((String)"simple.xml", (String)((String)config.getImports().get(2)));
    }

    public void testWithPropertyDefined() throws Exception {
        System.setProperty("db.configuration.path", "/home/admin/db");
        TestImportWithProperties.assertNotNull((Object)System.getProperty("db.configuration.path"));
        Configuration config = this.getConfiguration("import-with-parameter-configuration.xml", new String[0]);
        TestImportWithProperties.assertEquals((int)3, (int)config.getImports().size());
        TestImportWithProperties.assertEquals((String)"/home/admin/db/db.xml", (String)((String)config.getImports().get(0)));
        TestImportWithProperties.assertEquals((String)(System.getProperty("java.io.tmpdir") + "/bindfile.xml"), (String)((String)config.getImports().get(1)));
        TestImportWithProperties.assertEquals((String)"simple.xml", (String)((String)config.getImports().get(2)));
    }
}

