/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.spi;

import junit.framework.TestCase;
import org.exoplatform.container.AbstractInterceptor;
import org.exoplatform.container.CachingContainer;
import org.exoplatform.container.ConcurrentContainer;
import org.exoplatform.container.DefaultInterceptorChainFactory;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.management.ManageableContainer;
import org.exoplatform.container.spi.After;
import org.exoplatform.container.spi.Before;
import org.exoplatform.container.spi.Interceptor;
import org.exoplatform.container.spi.InterceptorChainFactory;

public class TestKernelExtension
extends TestCase {
    public void testFactory() {
        try {
            MockInterceptorChainFactory.mode = 1;
            ExoContainer container = new ExoContainer();
            TestKernelExtension.assertTrue((boolean)(container.getSuccessor() instanceof MockInterceptor));
        }
        finally {
            MockInterceptorChainFactory.mode = 0;
        }
    }

    public void testInterceptors() {
        ExoContainer parent = new ExoContainer();
        this.testInterceptorsInternal(parent);
        this.testInterceptorsInternal(parent);
    }

    private void testInterceptorsInternal(ExoContainer parent) {
        ExoContainer holder;
        MockInterceptor1 i1 = null;
        MockInterceptor2 i2 = null;
        MockInterceptor3 i3 = null;
        MockInterceptor4 i4 = null;
        MockInterceptor5 i5 = null;
        MockInterceptor6 i6 = null;
        MockInterceptor7 i7 = null;
        MockInterceptor8 i8 = null;
        MockInterceptor9 i9 = null;
        ExoContainer container = holder = new ExoContainer(parent);
        while ((container = container.getSuccessor()) != null) {
            if (container instanceof MockInterceptor1) {
                i1 = (MockInterceptor1)container;
                continue;
            }
            if (container instanceof MockInterceptor2) {
                i2 = (MockInterceptor2)container;
                continue;
            }
            if (container instanceof MockInterceptor3) {
                i3 = (MockInterceptor3)container;
                continue;
            }
            if (container instanceof MockInterceptor4) {
                i4 = (MockInterceptor4)container;
                continue;
            }
            if (container instanceof MockInterceptor5) {
                i5 = (MockInterceptor5)container;
                continue;
            }
            if (container instanceof MockInterceptor6) {
                i6 = (MockInterceptor6)container;
                continue;
            }
            if (container instanceof MockInterceptor7) {
                i7 = (MockInterceptor7)container;
                continue;
            }
            if (container instanceof MockInterceptor8) {
                i8 = (MockInterceptor8)container;
                continue;
            }
            if (!(container instanceof MockInterceptor9)) continue;
            i9 = (MockInterceptor9)container;
        }
        TestKernelExtension.assertNotNull(i1);
        TestKernelExtension.assertNotNull((Object)i1.getSuccessor());
        TestKernelExtension.assertSame((Object)parent, (Object)i1.getParent());
        TestKernelExtension.assertSame((Object)holder, (Object)i1.getHolder());
        TestKernelExtension.assertEquals((String)"MockInterceptor1", (String)i1.getId());
        TestKernelExtension.assertNotNull((Object)((Object)i2));
        TestKernelExtension.assertNotNull((Object)i2.getSuccessor());
        TestKernelExtension.assertSame((Object)parent, (Object)i2.getParent());
        TestKernelExtension.assertSame((Object)holder, (Object)i2.getHolder());
        TestKernelExtension.assertEquals((String)"MockInterceptor2", (String)i2.getId());
        TestKernelExtension.assertNotNull((Object)((Object)i3));
        TestKernelExtension.assertNotNull((Object)i3.getSuccessor());
        TestKernelExtension.assertSame((Object)parent, (Object)i3.getParent());
        TestKernelExtension.assertSame((Object)holder, (Object)i3.getHolder());
        TestKernelExtension.assertEquals((String)"MockInterceptor3", (String)i3.getId());
        TestKernelExtension.assertNotNull((Object)((Object)i4));
        TestKernelExtension.assertNotNull((Object)i4.getSuccessor());
        TestKernelExtension.assertSame((Object)parent, (Object)i4.getParent());
        TestKernelExtension.assertSame((Object)holder, (Object)i4.getHolder());
        TestKernelExtension.assertEquals((String)"MockInterceptor4", (String)i4.getId());
        TestKernelExtension.assertNotNull((Object)((Object)i5));
        TestKernelExtension.assertNotNull((Object)i5.getSuccessor());
        TestKernelExtension.assertSame((Object)parent, (Object)i5.getParent());
        TestKernelExtension.assertSame((Object)holder, (Object)i5.getHolder());
        TestKernelExtension.assertEquals((String)"MockInterceptor5", (String)i5.getId());
        TestKernelExtension.assertNotNull((Object)((Object)i6));
        TestKernelExtension.assertNotNull((Object)i6.getSuccessor());
        TestKernelExtension.assertSame((Object)parent, (Object)i6.getParent());
        TestKernelExtension.assertSame((Object)holder, (Object)i6.getHolder());
        TestKernelExtension.assertEquals((String)"MockInterceptor6", (String)i6.getId());
        TestKernelExtension.assertNotNull((Object)((Object)i7));
        TestKernelExtension.assertNotNull((Object)i7.getSuccessor());
        TestKernelExtension.assertSame((Object)parent, (Object)i7.getParent());
        TestKernelExtension.assertSame((Object)holder, (Object)i7.getHolder());
        TestKernelExtension.assertEquals((String)"MockInterceptor7", (String)i7.getId());
        TestKernelExtension.assertNotNull((Object)((Object)i8));
        TestKernelExtension.assertNull((Object)i8.getSuccessor());
        TestKernelExtension.assertSame((Object)parent, (Object)i8.getParent());
        TestKernelExtension.assertSame((Object)holder, (Object)i8.getHolder());
        TestKernelExtension.assertEquals((String)"MockInterceptor8", (String)i8.getId());
        TestKernelExtension.assertNotNull((Object)((Object)i9));
        TestKernelExtension.assertNotNull((Object)i9.getSuccessor());
        TestKernelExtension.assertSame((Object)((Object)i5), (Object)i9.getSuccessor());
        TestKernelExtension.assertSame((Object)parent, (Object)i9.getParent());
        TestKernelExtension.assertSame((Object)holder, (Object)i9.getHolder());
        TestKernelExtension.assertEquals((String)"MockInterceptor9", (String)i9.getId());
        TestKernelExtension.assertSame((Object)((Object)i9), (Object)holder.getSuccessor());
        Test0 t0I = new Test0();
        Test1 t1I = new Test1();
        Test2 t2I = new Test2();
        Test3 t3I = new Test3();
        holder.registerComponentInstance(Test0.class, (Object)t0I);
        holder.registerComponentInstance(Test1.class, (Object)t1I);
        holder.registerComponentInstance(Test2.class, (Object)t2I);
        holder.registerComponentInstance(Test3.class, (Object)t3I);
        holder.registerComponentImplementation(Test5.class);
        TestKernelExtension.assertSame((Object)t0I, (Object)holder.getComponentInstanceOfType(Test0.class));
        Test1 t1FC = (Test1)holder.getComponentInstanceOfType(Test1.class);
        TestKernelExtension.assertNotSame((Object)t1I, (Object)t1FC);
        TestKernelExtension.assertNotSame((Object)t1FC, (Object)holder.getComponentInstanceOfType(Test1.class));
        Test2 t2FC = (Test2)holder.getComponentInstanceOfType(Test2.class);
        TestKernelExtension.assertNotSame((Object)t2I, (Object)t2FC);
        TestKernelExtension.assertSame((Object)t2FC, (Object)holder.getComponentInstanceOfType(Test2.class));
        Test3 t3FC = (Test3)holder.getComponentInstanceOfType(Test3.class);
        TestKernelExtension.assertSame((Object)MockInterceptor1.TEST, (Object)t3FC);
        Test5 t4FC = (Test5)holder.getComponentInstanceOfType(Test5.class);
        TestKernelExtension.assertSame((Object)t0I, (Object)t4FC.t0);
        TestKernelExtension.assertNotSame((Object)t1I, (Object)t4FC.t1);
        TestKernelExtension.assertNotSame((Object)t2I, (Object)t4FC.t2);
        TestKernelExtension.assertSame((Object)t3FC, (Object)t4FC.t3);
    }

    public static class MockInterceptorChainFactory
    implements InterceptorChainFactory {
        private static int mode;
        private final InterceptorChainFactory delegate = new DefaultInterceptorChainFactory();

        public Interceptor getInterceptorChain(ExoContainer holder, ExoContainer parent) {
            if (mode == 0) {
                return this.delegate.getInterceptorChain(holder, parent);
            }
            ConcurrentContainer cc = new ConcurrentContainer(holder, parent);
            CachingContainer caching = new CachingContainer();
            caching.setSuccessor((Interceptor)cc);
            ManageableContainer mac = new ManageableContainer(holder, parent);
            mac.setSuccessor((Interceptor)caching);
            return new MockInterceptor((Interceptor)mac);
        }
    }

    private static class MockInterceptor
    extends AbstractInterceptor {
        private MockInterceptor(Interceptor delegate) {
            this.setSuccessor(delegate);
        }
    }

    @Before(value="Cache")
    public static class MockInterceptor1
    extends AbstractInterceptor {
        public static final Test3 TEST = new Test3();

        ExoContainer getParent() {
            return this.parent;
        }

        ExoContainer getHolder() {
            return this.holder;
        }

        public <T> T getComponentInstanceOfType(Class<T> componentType, boolean autoRegistration) {
            if (componentType.equals(Test1.class)) {
                return componentType.cast(new Test1());
            }
            if (componentType.equals(Test3.class)) {
                return componentType.cast(TEST);
            }
            if (componentType.equals(Test4.class)) {
                return componentType.cast(new Test4());
            }
            return (T)super.getComponentInstanceOfType(componentType, autoRegistration);
        }
    }

    @After(value="Cache")
    public static class MockInterceptor2
    extends AbstractInterceptor {
        ExoContainer getParent() {
            return this.parent;
        }

        ExoContainer getHolder() {
            return this.holder;
        }

        public <T> T getComponentInstanceOfType(Class<T> componentType, boolean autoRegistration) {
            if (componentType.equals(Test2.class)) {
                return componentType.cast(new Test2());
            }
            return (T)super.getComponentInstanceOfType(componentType, autoRegistration);
        }
    }

    public static class MockInterceptor3
    extends AbstractInterceptor {
        ExoContainer getParent() {
            return this.parent;
        }

        ExoContainer getHolder() {
            return this.holder;
        }
    }

    @After(value="Fake")
    public static class MockInterceptor4
    extends AbstractInterceptor {
        ExoContainer getParent() {
            return this.parent;
        }

        ExoContainer getHolder() {
            return this.holder;
        }
    }

    @Before(value="Fake")
    public static class MockInterceptor5
    extends AbstractInterceptor {
        ExoContainer getParent() {
            return this.parent;
        }

        ExoContainer getHolder() {
            return this.holder;
        }
    }

    @After(value="")
    public static class MockInterceptor6
    extends AbstractInterceptor {
        ExoContainer getParent() {
            return this.parent;
        }

        ExoContainer getHolder() {
            return this.holder;
        }
    }

    @Before(value="")
    public static class MockInterceptor7
    extends AbstractInterceptor {
        ExoContainer getParent() {
            return this.parent;
        }

        ExoContainer getHolder() {
            return this.holder;
        }
    }

    @After(value="ConcurrentContainer")
    public static class MockInterceptor8
    extends AbstractInterceptor {
        ExoContainer getParent() {
            return this.parent;
        }

        ExoContainer getHolder() {
            return this.holder;
        }
    }

    @Before(value="MockInterceptor5")
    public static class MockInterceptor9
    extends AbstractInterceptor {
        ExoContainer getParent() {
            return this.parent;
        }

        ExoContainer getHolder() {
            return this.holder;
        }
    }

    private static class Test0 {
        private Test0() {
        }
    }

    private static class Test1 {
        private Test1() {
        }
    }

    private static class Test2 {
        private Test2() {
        }
    }

    private static class Test3 {
        private Test3() {
        }
    }

    public static class Test5 {
        public Test0 t0;
        public Test1 t1;
        public Test2 t2;
        public Test3 t3;
        public Test4 t4;

        public Test5(Test0 t0, Test1 t1, Test2 t2, Test3 t3, Test4 t4) {
            this.t0 = t0;
            this.t1 = t1;
            this.t2 = t2;
            this.t3 = t3;
            this.t4 = t4;
        }
    }

    private static class Test4 {
        private Test4() {
        }
    }
}

