/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.test;

import java.util.List;
import junit.framework.TestCase;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.test.DefaultComponent;
import org.exoplatform.container.test.MultibleComponent;
import org.exoplatform.mocks.MockService;
import org.exoplatform.mocks.PriorityService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class TestContainer
extends TestCase {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.container.TestContainer");

    public void setUp() throws Exception {
        LOG.info((Object)"Start SetUp");
        System.setProperty("maven.exoplatform.dir", TestContainer.class.getResource("/").getFile());
        ExoContainer topContainer = ExoContainerContext.getTopContainer();
        if (topContainer != null) {
            topContainer.stop();
        }
        ExoContainerContext.setCurrentContainer(null);
        PortalContainer.setInstance(null);
        RootContainer.setInstance(null);
        LOG.info((Object)"End SetUp");
    }

    public void testComponent() throws Exception {
        LOG.info((Object)"Start testComponent");
        RootContainer rootContainer = RootContainer.getInstance();
        MockService mservice = (MockService)rootContainer.getComponentInstance((Object)"MockService");
        TestContainer.assertTrue((mservice != null ? 1 : 0) != 0);
        TestContainer.assertTrue((mservice.getPlugins().size() == 2 ? 1 : 0) != 0);
        LOG.info((Object)"End testComponent");
    }

    public void testComponent2() throws Exception {
        LOG.info((Object)"Start testComponent2");
        RootContainer rootContainer = RootContainer.getInstance();
        PortalContainer pcontainer = rootContainer.getPortalContainer("portal");
        TestContainer.assertNotNull((Object)pcontainer);
        MultibleComponent c = (MultibleComponent)pcontainer.getComponentInstanceOfType(MultibleComponent.class);
        TestContainer.assertNotNull((Object)c);
        c = (MultibleComponent)pcontainer.getComponentInstanceOfType(MultibleComponent.class);
        TestContainer.assertNotNull((Object)c);
        c = (MultibleComponent)pcontainer.getComponentInstanceOfType(MultibleComponent.class);
        TestContainer.assertNotNull((Object)c);
        LOG.info((Object)"End testComponent2");
    }

    public void testComponent3() throws Exception {
        LOG.info((Object)"Start testComponent3");
        RootContainer rootContainer = RootContainer.getInstance();
        PortalContainer pcontainer = rootContainer.getPortalContainer("portal");
        TestContainer.assertNotNull((Object)pcontainer);
        DefaultComponent c = (DefaultComponent)pcontainer.getComponentInstanceOfType(DefaultComponent.class);
        TestContainer.assertNotNull((Object)c);
        c = (DefaultComponent)pcontainer.getComponentInstanceOfType(DefaultComponent.class);
        TestContainer.assertNotNull((Object)c);
        c = (DefaultComponent)pcontainer.getComponentInstanceOfType(DefaultComponent.class);
        TestContainer.assertNotNull((Object)c);
        LOG.info((Object)"End testComponent3");
    }

    public void testPriorityPlugins() {
        LOG.info((Object)"Start testPriorityPlugins");
        RootContainer rootContainer = RootContainer.getInstance();
        PortalContainer pcontainer = rootContainer.getPortalContainer("portal");
        TestContainer.assertNotNull((Object)pcontainer);
        PriorityService ps = (PriorityService)pcontainer.getComponentInstanceOfType(PriorityService.class);
        TestContainer.assertNotNull((Object)ps);
        List<ComponentPlugin> l = ps.getPlugins();
        TestContainer.assertNotNull(l);
        TestContainer.assertEquals((int)3, (int)l.size());
        TestContainer.assertEquals((String)"PluginPriority3", (String)l.get(0).getName());
        TestContainer.assertEquals((String)"PluginPriority1", (String)l.get(1).getName());
        TestContainer.assertEquals((String)"PluginPriority2", (String)l.get(2).getName());
        LOG.info((Object)"End testPriorityPlugins");
    }

    public void testPortalContainer() throws Exception {
        LOG.info((Object)"Start testPortalContainer");
        RootContainer rootContainer = RootContainer.getInstance();
        PortalContainer pcontainer = rootContainer.getPortalContainer("portal");
        ExoContainer parent = pcontainer.getParent();
        TestContainer.assertTrue((String)"Root container should not be null", (parent != null ? 1 : 0) != 0);
        int INSERTLOOP = 0;
        for (int i = 0; i < INSERTLOOP; ++i) {
            rootContainer.getPortalContainer("name-" + Integer.toString(i));
        }
        int LOOP = 10000000;
        for (int i = 0; i < LOOP; ++i) {
            pcontainer = (PortalContainer)rootContainer.getComponentInstance((Object)"portal");
            TestContainer.assertTrue((String)"not null", (pcontainer != null ? 1 : 0) != 0);
        }
        LOG.info((Object)"End testPortalContainer");
    }
}

