/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.kudos.rest;

import io.meeds.kudos.model.Kudos;
import io.meeds.kudos.model.KudosList;
import io.meeds.kudos.model.KudosPeriod;
import io.meeds.kudos.model.KudosPeriodType;
import io.meeds.kudos.model.exception.KudosAlreadyLinkedException;
import io.meeds.kudos.service.KudosService;
import io.meeds.kudos.service.utils.Utils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.portal.application.localization.LocalizationFilter;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.utils.MentionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"kudos"})
@Tag(name="/kudos/rest/kudos", description="Manages Kudos")
public class KudosREST {
    @Autowired
    private KudosService kudosService;
    @Autowired
    private IdentityManager identityManager;

    @GetMapping
    @Secured(value={"administrators"})
    @Operation(summary="Get Kudos list created in a period contained a selected date in seconds", method="GET", description="Get Kudos list created in a period contained a selected date in seconds and returns list of Kudos")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="500", description="Internal server error")})
    public List<Kudos> getKudosByPeriodOfDate(@Parameter(description="Timestamp in seconds of date in the middle of selected period. If not defined, current time will be used.") @RequestParam(name="dateInSeconds", required=false, defaultValue="0") long dateInSeconds, @Parameter(description="Limit of results to return") @RequestParam(name="limit", required=false, defaultValue="10") int limit) {
        if (dateInSeconds <= 0L) {
            dateInSeconds = System.currentTimeMillis() / 1000L;
        }
        List<Kudos> allKudosByPeriod = this.kudosService.getKudosByPeriodOfDate(dateInSeconds, this.getLimit(limit));
        this.translateRoleMentions(allKudosByPeriod.toArray(new Kudos[0]));
        return allKudosByPeriod;
    }

    @GetMapping(value={"byEntity"})
    @Secured(value={"users"})
    @Operation(summary="Get Kudos list by entity type and id", method="GET", description="Get Kudos list by entity type and id and returns list of Kudos")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public List<Kudos> getEntityKudos(@Parameter(description="kudos entity type (for example activity, comment...)", required=true) @RequestParam(value="entityType") String entityType, @Parameter(description="kudos entity id", required=true) @RequestParam(value="entityId") String entityId, @Parameter(description="Limit of results to return") @RequestParam(name="limit", required=false, defaultValue="10") int limit) {
        List<Kudos> allKudosByEntity = this.kudosService.getKudosByEntity(entityType, entityId, this.getLimit(limit));
        this.translateRoleMentions(allKudosByEntity.toArray(new Kudos[0]));
        return allKudosByEntity;
    }

    @GetMapping(value={"byActivity/{activityId}"})
    @Secured(value={"users"})
    @Operation(summary="Get Kudos by its generated comment or activity id", method="GET", description="Get Kudos by its generated comment or activity id")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Entity Not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Kudos getKudosByActivityId(@Parameter(description="kudos activity or comment identifier", required=true) @PathVariable(value="activityId") String activityId) {
        try {
            Kudos kudos = this.kudosService.getKudosByActivityId(this.getActivityId(activityId), this.getCurrentIdentity());
            this.translateRoleMentions(kudos);
            return kudos;
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
    }

    @GetMapping(value={"byActivity/{activityId}/all"})
    @Secured(value={"users"})
    @Operation(summary="Get Kudos List attached to a parent activity, whether the activity itself or in a comment", method="GET", description="Get Kudos List attached to a parent activity, whether the activity itself or in a comment")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Entity Not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public List<Kudos> getKudosListOfActivity(@Parameter(description="kudos parent activity identifier", required=true) @PathVariable(value="activityId") String activityId) {
        Identity currentUser = this.getCurrentIdentity();
        try {
            List<Kudos> kudosList = this.kudosService.getKudosListOfActivity(activityId, currentUser);
            this.translateRoleMentions(kudosList.toArray(new Kudos[0]));
            return kudosList;
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
    }

    @GetMapping(value={"byEntity/sent/count"})
    @Secured(value={"users"})
    @Operation(summary="Get Kudos count by entity and current user as sender", method="GET", description="Get Kudos count by entity and current user as sender")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public long countKudosByEntityAndSender(@Parameter(description="kudos entity type (for example activity, comment...)", required=true) @RequestParam(value="entityType") String entityType, @Parameter(description="kudos entity id", required=true) @RequestParam(value="entityId") String entityId) {
        return this.kudosService.countKudosByEntityAndSender(entityType, entityId, this.getCurrentIdentityId());
    }

    @GetMapping(value={"byDates"})
    @Secured(value={"administrators"})
    @Operation(summary="Get Kudos list created between start and end dates in seconds", method="GET", description="Get Kudos list created between start and end dates in seconds")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public List<Kudos> getKudosByDates(@RequestParam(value="startDateInSeconds") long startDateInSeconds, @RequestParam(value="endDateInSeconds") long endDateInSeconds, @Parameter(description="Limit of results to return") @RequestParam(name="limit", required=false, defaultValue="10") int limit) {
        List<Kudos> allKudosByPeriod = this.kudosService.getKudosByPeriod(startDateInSeconds, endDateInSeconds, this.getLimit(limit));
        this.translateRoleMentions(allKudosByPeriod.toArray(new Kudos[0]));
        return allKudosByPeriod;
    }

    @GetMapping(value={"{identityId}/received"})
    @Secured(value={"users"})
    @Operation(summary="Retrieve the list of received Kudos by a user or space in a selected period", method="GET", description="Retrieve the list of received Kudos by a user or space in a selected period")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="500", description="Internal server error")})
    public KudosList getReceivedKudosByPeriod(@Parameter(description="User or space identity technical id", required=true) @PathVariable(value="identityId") long identityId, @Parameter(description="Date in the middle of a period defined using a timestamp in seconds", required=true) @RequestParam(name="dateInSeconds", required=false, defaultValue="0") long dateInSeconds, @Parameter(description="Period type, can be: WEEK, MONTH, QUARTER, SEMESTER and YEAR. Default is the same as configured period", required=false) @RequestParam(name="periodType", required=false) String periodType, @Parameter(description="Limit of kudos to retrieve, if equal to 0, no kudos will be retrieved", required=false) @RequestParam(name="limit", required=false, defaultValue="10") int limit, @Parameter(description="Whether return size of received kudos, default = false") @RequestParam(name="returnSize", required=false, defaultValue="false") boolean returnSize) {
        KudosPeriodType kudosPeriodType = this.getKudosPeriodType(periodType);
        KudosPeriod period = kudosPeriodType.getPeriodOfTime(Utils.timeFromSeconds(dateInSeconds));
        KudosList kudosList = new KudosList();
        if (returnSize) {
            long size = this.kudosService.countKudosByPeriodAndReceiver(identityId, period.getStartDateInSeconds(), period.getEndDateInSeconds());
            kudosList.setSize(size);
            if (size == 0L || limit == 0) {
                return kudosList;
            }
        }
        List<Kudos> kudos = this.kudosService.getKudosByPeriodAndReceiver(identityId, period.getStartDateInSeconds(), period.getEndDateInSeconds(), this.getLimit(limit));
        this.translateRoleMentions(kudos.toArray(new Kudos[0]));
        kudosList.setKudos(kudos);
        return kudosList;
    }

    @GetMapping(value={"{identityId}/sent"})
    @Secured(value={"users"})
    @Operation(summary="Retrieve the list of sent Kudos for a user in a selected period", method="GET", description="Retrieve the list of sent Kudos for a user in a selected period")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="500", description="Internal server error")})
    public KudosList getSentKudosByPeriod(@Parameter(description="User or space identity technical id", required=true) @PathVariable(value="identityId") long identityId, @Parameter(description="Date in the middle of a period defined using a timestamp in seconds") @RequestParam(name="dateInSeconds", required=false, defaultValue="0") long dateInSeconds, @Parameter(description="Period type, can be: WEEK, MONTH, QUARTER, SEMESTER and YEAR. Default is the same as configured period") @RequestParam(name="periodType", required=false) String periodType, @Parameter(description="Limit of kudos to retrieve, if equal to 0, no kudos will be retrieved") @RequestParam(name="limit", required=false, defaultValue="10") int limit, @Parameter(description="Whether return size of sent kudos, default = false") @RequestParam(name="returnSize", required=false, defaultValue="false") boolean returnSize) {
        KudosPeriodType kudosPeriodType = this.getKudosPeriodType(periodType);
        KudosPeriod period = kudosPeriodType.getPeriodOfTime(Utils.timeFromSeconds(dateInSeconds));
        KudosList kudosList = new KudosList();
        if (returnSize) {
            long size = this.kudosService.countKudosByPeriodAndSender(identityId, period.getStartDateInSeconds(), period.getEndDateInSeconds());
            kudosList.setSize(size);
            if (size == 0L || limit == 0) {
                return kudosList;
            }
        }
        List<Kudos> kudos = this.kudosService.getKudosByPeriodAndSender(identityId, period.getStartDateInSeconds(), period.getEndDateInSeconds(), this.getLimit(limit));
        this.translateRoleMentions(kudos.toArray(new Kudos[0]));
        kudosList.setKudos(kudos);
        return kudosList;
    }

    @PostMapping
    @Secured(value={"users"})
    @Operation(summary="Creates new Kudos", method="POST", description="Creates new Kudos and returns an empty response")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Kudos createKudos(@io.swagger.v3.oas.annotations.parameters.RequestBody(description="Kudos object to create", required=true) @RequestBody Kudos kudos) {
        if (StringUtils.isBlank((CharSequence)kudos.getReceiverId()) || StringUtils.isBlank((CharSequence)kudos.getReceiverType())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "ReceiverId  and ReceiverType are mandatory");
        }
        if (StringUtils.isBlank((CharSequence)kudos.getEntityId()) || StringUtils.isBlank((CharSequence)kudos.getEntityType())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Bad request sent to server with empty 'attached entity id or type'");
        }
        try {
            kudos.setSenderId(Utils.getCurrentUserId());
            Kudos kudosSent = this.kudosService.createKudos(kudos, Utils.getCurrentUserId());
            this.translateRoleMentions(kudosSent);
            return kudosSent;
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
    }

    @DeleteMapping(value={"{kudosId}"})
    @Secured(value={"users"})
    @Operation(summary="Cancels a sent kudos", method="DELETE", description="Cancels a sent kudos")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="404", description="Object not found"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public void deleteKudos(@Parameter(description="Kudos technical identifier", required=true) @PathVariable(value="kudosId") long kudosId) {
        String currentUser = Utils.getCurrentUserId();
        try {
            this.kudosService.deleteKudosById(kudosId, currentUser);
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        catch (KudosAlreadyLinkedException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "KudosAlreadyLinked");
        }
    }

    @GetMapping(value={"period"})
    @Secured(value={"users"})
    @Operation(summary="Get Kudos period of time by computing it using period type and a selected date", method="GET", description="Get Kudos period of time by computing it using period type and a selected date")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public KudosPeriod getPeriodDates(@Parameter(description="Period type, can be: WEEK, MONTH, QUARTER, SEMESTER and YEAR. Default is the same as configured period") @RequestParam(value="periodType") String periodType, @Parameter(description="Date in the middle of a period defined using a timestamp in seconds") @RequestParam(value="dateInSeconds") long dateInSeconds) {
        KudosPeriodType kudosPeriodType = this.getKudosPeriodType(periodType);
        return kudosPeriodType.getPeriodOfTime(Utils.timeFromSeconds(dateInSeconds));
    }

    private int getLimit(int limit) {
        if (limit <= 0) {
            limit = 10;
        }
        return limit;
    }

    private Long getActivityId(String commentId) {
        return commentId == null || commentId.trim().isEmpty() ? null : Long.valueOf(commentId.replace("comment", ""));
    }

    private void translateRoleMentions(Kudos ... kudosList) {
        if (ArrayUtils.isEmpty((Object[])kudosList)) {
            return;
        }
        Locale userLocale = LocalizationFilter.getCurrentLocale();
        for (Kudos kudos : kudosList) {
            if (kudos == null) continue;
            kudos.setMessage(MentionUtils.substituteUsernames((String)kudos.getMessage(), (Locale)userLocale));
        }
    }

    private Identity getCurrentIdentity() {
        return ConversationState.getCurrent().getIdentity();
    }

    private String getCurrentIdentityId() {
        org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getOrCreateUserIdentity(Utils.getCurrentUserId());
        return identity.getId();
    }

    private KudosPeriodType getKudosPeriodType(String periodType) {
        if (StringUtils.isBlank((CharSequence)periodType)) {
            return this.kudosService.getDefaultKudosPeriodType();
        }
        try {
            return KudosPeriodType.valueOf(periodType.toUpperCase());
        }
        catch (Exception e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "periodType  '" + periodType + "' is not valid");
        }
    }
}

