/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.kudos.service;

import io.meeds.kudos.BaseKudosTest;
import io.meeds.kudos.dao.KudosDAO;
import io.meeds.kudos.entity.KudosEntity;
import io.meeds.kudos.model.AccountSettings;
import io.meeds.kudos.model.GlobalSettings;
import io.meeds.kudos.model.Kudos;
import io.meeds.kudos.model.KudosEntityType;
import io.meeds.kudos.model.KudosPeriod;
import io.meeds.kudos.model.KudosPeriodType;
import io.meeds.kudos.service.KudosService;
import io.meeds.kudos.service.utils.Utils;
import io.meeds.kudos.storage.KudosStorage;
import io.meeds.test.kudos.mock.SpaceServiceMock;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.junit.jupiter.SpringJUnitConfig;

@SpringJUnitConfig(value={BaseKudosTest.class})
public class KudosServiceTest
extends BaseKudosTest {
    private static final String ENTITY_TYPE = KudosEntityType.USER_TIPTIP.name();
    private static final String ENTITY_ID = "1";
    private static final long RECEIVER_ID = 3L;
    private static final String RECEIVER_REMOTE_ID = "root3";
    private static final String SENDER_REMOTE_ID = "root4";
    @Autowired
    IdentityManager identityManager;
    @Autowired
    ListenerService listenerService;
    @Autowired
    KudosStorage kudosStorage;
    @Autowired
    KudosService kudosService;
    @Autowired
    SpaceService spaceService;
    @Autowired
    ActivityManager activityManager;
    @Autowired
    KudosDAO kudosDAO;

    @Override
    public KudosDAO getKudosDAO() {
        return this.kudosDAO;
    }

    @Test
    public void testGetKudosByEntity() {
        List list = this.kudosService.getKudosByEntity(ENTITY_TYPE, ENTITY_ID, 10);
        Assertions.assertNotNull((Object)list);
        Assertions.assertEquals((int)0, (int)list.size());
        KudosEntity kudosEntity = this.newKudos();
        list = this.kudosService.getKudosByEntity(ENTITY_TYPE, ENTITY_ID, 10);
        Assertions.assertNotNull((Object)list);
        Assertions.assertEquals((int)1, (int)list.size());
        Kudos kudos = (Kudos)list.get(0);
        this.compareResults(kudosEntity, kudos);
        list = this.kudosService.getKudosByEntity(KudosEntityType.SPACE_TIPTIP.name(), ENTITY_ID, 10);
        Assertions.assertNotNull((Object)list);
        Assertions.assertEquals((int)0, (int)list.size());
        list = this.kudosService.getKudosByEntity(ENTITY_TYPE, "20", 10);
        Assertions.assertNotNull((Object)list);
        Assertions.assertEquals((int)0, (int)list.size());
    }

    @Test
    public void testCountKudosByEntity() {
        long count = this.kudosService.countKudosByEntity(ENTITY_TYPE, ENTITY_ID);
        Assertions.assertEquals((long)0L, (long)count);
        this.newKudos();
        count = this.kudosService.countKudosByEntity(ENTITY_TYPE, ENTITY_ID);
        Assertions.assertEquals((long)1L, (long)count);
        count = this.kudosService.countKudosByEntity(ENTITY_TYPE, "25");
        Assertions.assertEquals((long)0L, (long)count);
    }

    @Test
    public void testCountKudosByEntityAndSender() {
        long count = this.kudosService.countKudosByEntityAndSender(ENTITY_TYPE, ENTITY_ID, String.valueOf(this.senderId));
        Assertions.assertEquals((long)0L, (long)count);
        this.newKudos();
        count = this.kudosService.countKudosByEntityAndSender(ENTITY_TYPE, ENTITY_ID, String.valueOf(this.senderId));
        Assertions.assertEquals((long)1L, (long)count);
        count = this.kudosService.countKudosByEntityAndSender(ENTITY_TYPE, "25", String.valueOf(this.senderId));
        Assertions.assertEquals((long)0L, (long)count);
    }

    @Test
    public void testGetKudosByPeriodAndReceiver() {
        long startTime = this.getTime(2019, 1, 1);
        long endTime = this.getCurrentTimeInSeconds();
        List list = this.kudosService.getKudosByPeriodAndReceiver(3L, startTime, endTime, 10);
        Assertions.assertNotNull((Object)list);
        Assertions.assertEquals((int)0, (int)list.size());
        KudosEntity kudosEntity = this.newKudos();
        list = this.kudosService.getKudosByPeriodAndReceiver(3L, startTime, endTime, 10);
        Assertions.assertNotNull((Object)list);
        Assertions.assertEquals((int)1, (int)list.size());
        Kudos kudos = (Kudos)list.get(0);
        this.compareResults(kudosEntity, kudos);
        list = this.kudosService.getKudosByPeriodAndReceiver(30L, startTime, endTime, 10);
        Assertions.assertNotNull((Object)list);
        Assertions.assertEquals((int)0, (int)list.size());
        list = this.kudosService.getKudosByPeriodAndReceiver(30000L, startTime, endTime, 10);
        Assertions.assertNotNull((Object)list);
        Assertions.assertEquals((int)0, (int)list.size());
    }

    @Test
    public void testCountKudosByPeriodAndReceiver() {
        long startTime = this.getTime(2019, 1, 1);
        long endTime = this.getCurrentTimeInSeconds();
        long count = this.kudosService.countKudosByPeriodAndReceiver(3L, startTime, endTime);
        Assertions.assertEquals((long)0L, (long)count);
        this.newKudos();
        count = this.kudosService.countKudosByPeriodAndReceiver(3L, startTime, endTime);
        Assertions.assertEquals((long)1L, (long)count);
        count = this.kudosService.countKudosByPeriodAndReceiver(30L, startTime, endTime);
        Assertions.assertEquals((long)0L, (long)count);
        count = this.kudosService.countKudosByPeriodAndReceiver(30000L, startTime, endTime);
        Assertions.assertEquals((long)0L, (long)count);
    }

    @Test
    public void testCountKudosByPeriodAndReceivers() {
        long startTime = this.getTime(2019, 1, 1);
        long endTime = this.getCurrentTimeInSeconds();
        ArrayList<Long> receivers = new ArrayList<Long>();
        receivers.add(3L);
        Map counts = this.kudosService.countKudosByPeriodAndReceivers(receivers, startTime, endTime);
        Assertions.assertEquals((Long)0L, (Long)Optional.ofNullable((Long)counts.get(3L)).orElse(0L));
        this.newKudos();
        receivers.add(30L);
        receivers.add(30000L);
        counts = this.kudosService.countKudosByPeriodAndReceivers(receivers, startTime, endTime);
        Assertions.assertEquals((Long)1L, (Long)Optional.ofNullable((Long)counts.get(3L)).orElse(0L));
        Assertions.assertEquals((Long)0L, (Long)Optional.ofNullable((Long)counts.get(30L)).orElse(0L));
        Assertions.assertEquals((Long)0L, (Long)Optional.ofNullable((Long)counts.get(30000L)).orElse(0L));
    }

    @Test
    public void testGetKudosByPeriodAndSender() {
        long startTime = this.getTime(2019, 1, 1);
        long endTime = this.getCurrentTimeInSeconds();
        List list = this.kudosService.getKudosByPeriodAndSender(this.senderId, startTime, endTime, 10);
        Assertions.assertNotNull((Object)list);
        Assertions.assertEquals((int)0, (int)list.size());
        KudosEntity kudosEntity = this.newKudos();
        list = this.kudosService.getKudosByPeriodAndSender(this.senderId, startTime, endTime, 10);
        Assertions.assertNotNull((Object)list);
        Assertions.assertEquals((int)1, (int)list.size());
        Kudos kudos = (Kudos)list.get(0);
        this.compareResults(kudosEntity, kudos);
        list = this.kudosService.getKudosByPeriodAndSender(30L, startTime, endTime, 10);
        Assertions.assertNotNull((Object)list);
        Assertions.assertEquals((int)0, (int)list.size());
        list = this.kudosService.getKudosByPeriodAndSender(30000L, startTime, endTime, 10);
        Assertions.assertNotNull((Object)list);
        Assertions.assertEquals((int)0, (int)list.size());
    }

    @Test
    public void testCountKudosByPeriodAndSender() {
        long startTime = this.getTime(2019, 1, 1);
        long endTime = this.getCurrentTimeInSeconds();
        long count = this.kudosService.countKudosByPeriodAndSender(this.senderId, startTime, endTime);
        Assertions.assertEquals((long)0L, (long)count);
        this.newKudos();
        count = this.kudosService.countKudosByPeriodAndSender(this.senderId, startTime, endTime);
        Assertions.assertEquals((long)1L, (long)count);
        count = this.kudosService.countKudosByPeriodAndSender(30L, startTime, endTime);
        Assertions.assertEquals((long)0L, (long)count);
        count = this.kudosService.countKudosByPeriodAndSender(30000L, startTime, endTime);
        Assertions.assertEquals((long)0L, (long)count);
    }

    @Test
    public void testGetKudosByPeriod() {
        long startTime = this.getTime(2019, 1, 1);
        long endTime = this.getCurrentTimeInSeconds();
        List list = this.kudosService.getKudosByPeriod(startTime, endTime, 10);
        Assertions.assertNotNull((Object)list);
        Assertions.assertEquals((int)0, (int)list.size());
        KudosEntity kudosEntity = this.newKudos();
        list = this.kudosService.getKudosByPeriod(startTime, endTime, 10);
        Assertions.assertNotNull((Object)list);
        Assertions.assertEquals((int)1, (int)list.size());
        Kudos kudos = (Kudos)list.get(0);
        this.compareResults(kudosEntity, kudos);
        list = this.kudosService.getKudosByPeriod(this.getTime(2019, 1, 1), this.getTime(2019, 7, 1), 10);
        Assertions.assertNotNull((Object)list);
        Assertions.assertEquals((int)0, (int)list.size());
    }

    @Test
    public void testGetKudosByPeriodOfDate() {
        long startTime = this.getCurrentTimeInSeconds();
        List list = this.kudosService.getKudosByPeriodOfDate(startTime, 10);
        Assertions.assertNotNull((Object)list);
        Assertions.assertEquals((int)0, (int)list.size());
        KudosEntity kudosEntity = this.newKudos();
        list = this.kudosService.getKudosByPeriodOfDate(startTime, 10);
        Assertions.assertNotNull((Object)list);
        Assertions.assertEquals((int)1, (int)list.size());
        Kudos kudos = (Kudos)list.get(0);
        this.compareResults(kudosEntity, kudos);
        list = this.kudosService.getKudosByPeriodOfDate(this.getTime(2019, 6, 1), 10);
        Assertions.assertNotNull((Object)list);
        Assertions.assertEquals((int)0, (int)list.size());
    }

    @Test
    public void testSendKudos() {
        Kudos kudos = this.newKudosDTO();
        try {
            this.kudosService.createKudos(kudos, RECEIVER_REMOTE_ID);
            Assertions.fail((String)"Sender shouldn't be able to send kudos to himself");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Kudos fakeKudos = this.newKudosDTO();
            fakeKudos.setReceiverId(SENDER_REMOTE_ID);
            this.kudosService.createKudos(fakeKudos, SENDER_REMOTE_ID);
            Assertions.fail((String)"Sender shouldn't be the same as sender in DTO");
        }
        catch (Exception fakeKudos) {
            // empty catch block
        }
        kudos = this.kudosService.createKudos(kudos, SENDER_REMOTE_ID);
        KudosPeriod currentKudosPeriod = this.kudosService.getCurrentKudosPeriod();
        org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getOrCreateIdentity("organization", RECEIVER_REMOTE_ID);
        List list = this.kudosService.getKudosByPeriodAndReceiver(Long.parseLong(identity.getId()), currentKudosPeriod.getStartDateInSeconds(), currentKudosPeriod.getEndDateInSeconds(), 10);
        Assertions.assertNotNull((Object)list);
        Assertions.assertEquals((int)1, (int)list.size());
        Kudos retrievedKudos = (Kudos)list.get(0);
        Assertions.assertEquals((Object)kudos, (Object)retrievedKudos);
        Assertions.assertEquals((Long)kudos.getTechnicalId(), (Long)retrievedKudos.getTechnicalId());
        Assertions.assertEquals((long)kudos.getTimeInSeconds(), (long)retrievedKudos.getTimeInSeconds());
        Assertions.assertEquals((int)kudos.hashCode(), (int)retrievedKudos.hashCode());
        Assertions.assertNotNull((Object)kudos.toString());
        Assertions.assertTrue((boolean)kudos.toString().contains(SENDER_REMOTE_ID));
        Assertions.assertTrue((boolean)kudos.toString().contains(RECEIVER_REMOTE_ID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSendKudosToSpace() {
        Kudos kudos;
        String spaceRemoteId = "space3";
        org.exoplatform.social.core.identity.model.Identity spaceIdentity = this.identityManager.getOrCreateSpaceIdentity(spaceRemoteId);
        KudosPeriod currentKudosPeriod = this.kudosService.getCurrentKudosPeriod();
        Kudos kudosToSend = this.newKudosDTO();
        kudosToSend.setReceiverType("space");
        kudosToSend.setReceiverId(spaceRemoteId);
        kudosToSend.setReceiverIdentityId(null);
        this.restartTransaction();
        Assertions.assertThrows(IllegalAccessException.class, () -> this.kudosService.createKudos(kudosToSend, SENDER_REMOTE_ID));
        List list = this.kudosService.getKudosByPeriodAndReceiver(Long.parseLong(spaceIdentity.getId()), currentKudosPeriod.getStartDateInSeconds(), currentKudosPeriod.getEndDateInSeconds(), 10);
        Assertions.assertNotNull((Object)list);
        Assertions.assertEquals((int)0, (int)list.size());
        SpaceServiceMock.setRedactor(SENDER_REMOTE_ID);
        Assertions.assertThrows(IllegalAccessException.class, () -> this.kudosService.createKudos(kudosToSend, SENDER_REMOTE_ID));
        kudosToSend.setSpacePrettyName(spaceRemoteId);
        kudosToSend.setReceiverId("space2");
        Assertions.assertThrows(IllegalAccessException.class, () -> this.kudosService.createKudos(kudosToSend, SENDER_REMOTE_ID));
        kudosToSend.setReceiverId("NotFoundSpace0");
        Assertions.assertThrows(IllegalAccessException.class, () -> this.kudosService.createKudos(kudosToSend, SENDER_REMOTE_ID));
        kudosToSend.setReceiverId(spaceRemoteId);
        try {
            kudos = this.kudosService.createKudos(kudosToSend, SENDER_REMOTE_ID);
            Assertions.assertNotNull((Object)kudos);
        }
        finally {
            SpaceServiceMock.setRedactor(null);
        }
        list = this.kudosService.getKudosByPeriodAndReceiver(Long.parseLong(spaceIdentity.getId()), currentKudosPeriod.getStartDateInSeconds(), currentKudosPeriod.getEndDateInSeconds(), 10);
        Assertions.assertNotNull((Object)list);
        Assertions.assertEquals((int)1, (int)list.size());
        Kudos retrievedKudos = (Kudos)list.get(0);
        Assertions.assertEquals((Object)kudos, (Object)retrievedKudos);
        Assertions.assertEquals((Long)kudos.getTechnicalId(), (Long)retrievedKudos.getTechnicalId());
        Assertions.assertEquals((long)kudos.getTimeInSeconds(), (long)retrievedKudos.getTimeInSeconds());
        Assertions.assertEquals((int)kudos.hashCode(), (int)retrievedKudos.hashCode());
        this.restartTransaction();
        Kudos kudosToSendOnActivity = this.newKudosDTO();
        kudosToSendOnActivity.setReceiverType("space");
        kudosToSendOnActivity.setReceiverId(spaceRemoteId);
        kudosToSendOnActivity.setReceiverIdentityId(null);
        kudosToSendOnActivity.setEntityType(KudosEntityType.ACTIVITY.name());
        kudosToSendOnActivity.setEntityId(String.valueOf(retrievedKudos.getActivityId()));
        SpaceServiceMock.setMember(SENDER_REMOTE_ID);
        try {
            kudos = this.kudosService.createKudos(kudosToSendOnActivity, SENDER_REMOTE_ID);
            Assertions.assertNotNull((Object)kudos);
        }
        finally {
            SpaceServiceMock.setMember(null);
        }
        list = this.kudosService.getKudosByPeriodAndReceiver(Long.parseLong(spaceIdentity.getId()), currentKudosPeriod.getStartDateInSeconds(), currentKudosPeriod.getEndDateInSeconds(), 10);
        Assertions.assertNotNull((Object)list);
        Assertions.assertEquals((int)2, (int)list.size());
        retrievedKudos = (Kudos)list.get(0);
        Assertions.assertEquals((Object)kudosToSendOnActivity.getEntityType(), (Object)retrievedKudos.getEntityType());
        Assertions.assertEquals((Object)kudosToSendOnActivity.getEntityId(), (Object)retrievedKudos.getEntityId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSendKudosUsingSpaceId() {
        String spaceRemoteId = "space4";
        org.exoplatform.social.core.identity.model.Identity spaceIdentity = this.identityManager.getOrCreateSpaceIdentity(spaceRemoteId);
        KudosPeriod currentKudosPeriod = this.kudosService.getCurrentKudosPeriod();
        Kudos kudosToSend = this.newKudosDTO();
        kudosToSend.setReceiverType("space");
        kudosToSend.setReceiverId(this.spaceService.getSpaceByPrettyName(spaceIdentity.getRemoteId()).getId());
        kudosToSend.setReceiverIdentityId(null);
        kudosToSend.setSpacePrettyName(spaceRemoteId);
        this.restartTransaction();
        List list = this.kudosService.getKudosByPeriodAndReceiver(Long.parseLong(spaceIdentity.getId()), currentKudosPeriod.getStartDateInSeconds(), currentKudosPeriod.getEndDateInSeconds(), 10);
        Assertions.assertNotNull((Object)list);
        Assertions.assertEquals((int)0, (int)list.size());
        SpaceServiceMock.setRedactor(SENDER_REMOTE_ID);
        try {
            Kudos kudos = this.kudosService.createKudos(kudosToSend, SENDER_REMOTE_ID);
            Assertions.assertNotNull((Object)kudos);
        }
        finally {
            SpaceServiceMock.setRedactor(null);
        }
        list = this.kudosService.getKudosByPeriodAndReceiver(Long.parseLong(spaceIdentity.getId()), currentKudosPeriod.getStartDateInSeconds(), currentKudosPeriod.getEndDateInSeconds(), 10);
        Assertions.assertNotNull((Object)list);
        Assertions.assertEquals((int)1, (int)list.size());
    }

    @Test
    public void testGetKudosByPeriodType() {
        long startTime = this.getCurrentTimeInSeconds();
        try {
            this.kudosService.getKudosByPeriod(startTime, null, 10);
            Assertions.fail((String)"Shouldn't be able to get kudos list by null period type");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        List list = this.kudosService.getKudosByPeriod(startTime, KudosPeriodType.WEEK, 10);
        Assertions.assertNotNull((Object)list);
        Assertions.assertEquals((int)0, (int)list.size());
        KudosEntity kudosEntity = this.newKudos();
        list = this.kudosService.getKudosByPeriod(startTime, KudosPeriodType.WEEK, 10);
        Assertions.assertNotNull((Object)list);
        Assertions.assertEquals((int)1, (int)list.size());
        Kudos kudos = (Kudos)list.get(0);
        this.compareResults(kudosEntity, kudos);
        list = this.kudosService.getKudosByPeriod(this.getTime(2019, 6, 1), KudosPeriodType.WEEK, 10);
        Assertions.assertNotNull((Object)list);
        Assertions.assertEquals((int)0, (int)list.size());
    }

    @Test
    public void testGlobalSettings() {
        GlobalSettings globalSettings = this.kudosService.getGlobalSettings();
        Assertions.assertNotNull((Object)globalSettings);
        Assertions.assertNotNull((Object)globalSettings.getKudosPeriodType());
        Assertions.assertTrue((globalSettings.getKudosPerPeriod() > 0L ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSaveSettings() {
        GlobalSettings globalSettings = this.kudosService.getGlobalSettings();
        GlobalSettings defaultSettings = globalSettings.clone();
        try {
            globalSettings.setKudosPeriodType(KudosPeriodType.WEEK);
            globalSettings.setKudosPerPeriod(1L);
            this.kudosService.saveGlobalSettings(globalSettings);
            GlobalSettings savedGlobalSettings = this.kudosService.getGlobalSettings();
            Assertions.assertEquals((Object)globalSettings, (Object)savedGlobalSettings);
            Assertions.assertEquals((int)globalSettings.hashCode(), (int)savedGlobalSettings.hashCode());
        }
        finally {
            this.kudosService.saveGlobalSettings(defaultSettings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSendKudosAfterLimitReached() {
        GlobalSettings globalSettings = this.kudosService.getGlobalSettings();
        GlobalSettings defaultSettings = globalSettings.clone();
        try {
            globalSettings.setKudosPerPeriod(1L);
            this.kudosService.saveGlobalSettings(globalSettings);
            Kudos kudos = this.newKudosDTO();
            kudos = this.kudosService.createKudos(kudos, SENDER_REMOTE_ID);
            Thread.sleep(1000L);
            try {
                kudos = this.kudosService.createKudos(kudos, SENDER_REMOTE_ID);
                Assertions.fail((String)"Shouldn't be able to send another Kudos");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            this.kudosService.saveGlobalSettings(defaultSettings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetAccountSettings() {
        GlobalSettings globalSettings = this.kudosService.getGlobalSettings();
        GlobalSettings defaultSettings = globalSettings.clone();
        try {
            AccountSettings accountSettings = this.kudosService.getAccountSettings(SENDER_REMOTE_ID);
            Assertions.assertNotNull((Object)accountSettings);
            Assertions.assertFalse((boolean)accountSettings.isDisabled());
            Assertions.assertEquals((long)globalSettings.getKudosPerPeriod(), (long)accountSettings.getRemainingKudos());
            globalSettings.setKudosPerPeriod(1L);
            this.kudosService.saveGlobalSettings(globalSettings);
            Kudos kudos = this.newKudosDTO();
            kudos = this.kudosService.createKudos(kudos, SENDER_REMOTE_ID);
            Thread.sleep(1000L);
            accountSettings = this.kudosService.getAccountSettings(SENDER_REMOTE_ID);
            Assertions.assertNotNull((Object)accountSettings);
            Assertions.assertFalse((boolean)accountSettings.isDisabled());
            Assertions.assertEquals((long)0L, (long)accountSettings.getRemainingKudos());
        }
        finally {
            this.kudosService.saveGlobalSettings(defaultSettings);
        }
    }

    @Test
    public void testSaveKudosActivity() {
        Kudos kudos = this.newKudosDTO();
        kudos = this.kudosService.createKudos(kudos, SENDER_REMOTE_ID);
        final AtomicBoolean listenerInvoked = new AtomicBoolean(false);
        this.listenerService.addListener("exo.kudos.activity", (ListenerBase)new Listener<KudosService, Kudos>(this){

            public void onEvent(Event<KudosService, Kudos> event) throws Exception {
                listenerInvoked.set(true);
            }
        });
        this.kudosService.updateKudosGeneratedActivityId(kudos.getTechnicalId().longValue(), kudos.getActivityId());
        Assertions.assertTrue((boolean)listenerInvoked.get());
    }

    @Test
    public void testActivityCreation() {
        final AtomicBoolean listenerInvoked = new AtomicBoolean(false);
        this.listenerService.addListener("exo.gamification.generic.action", (ListenerBase)new Listener<KudosService, Kudos>(this){

            public void onEvent(Event<KudosService, Kudos> event) throws Exception {
                listenerInvoked.set(true);
            }
        });
        Kudos kudos = this.newKudosDTO();
        kudos.setEntityType(KudosEntityType.USER_PROFILE.name());
        kudos = this.kudosService.createKudos(kudos, SENDER_REMOTE_ID);
        kudos = this.kudosStorage.getKudoById(kudos.getTechnicalId().longValue());
        Assertions.assertTrue((kudos.getActivityId() > 0L ? 1 : 0) != 0);
        for (int i = 0; i < 10 && !listenerInvoked.get(); ++i) {
            Thread.sleep(500L);
        }
        Assertions.assertTrue((boolean)listenerInvoked.get());
    }

    @Test
    public void testGetKudosByActivityId() {
        KudosEntity kudosEntity = this.newKudos();
        kudosEntity.setEntityType(KudosEntityType.USER_PROFILE.ordinal());
        Kudos kudos = this.kudosService.createKudos(Utils.fromEntity((KudosEntity)kudosEntity), SENDER_REMOTE_ID);
        Kudos storedKudos = this.kudosStorage.getKudoById(kudos.getTechnicalId().longValue());
        Kudos newKudos = this.kudosService.getKudosByActivityId(Long.valueOf(storedKudos.getActivityId()));
        this.compareResults(Utils.toEntity((Kudos)storedKudos), newKudos);
    }

    @Test
    public void testGetKudosListOfActivity() {
        this.resetGlobalSettings();
        KudosEntity kudosEntity = this.newKudosInstance();
        kudosEntity.setEntityType(KudosEntityType.SPACE_PROFILE.ordinal());
        Kudos parentKudos = this.kudosService.createKudos(Utils.fromEntity((KudosEntity)kudosEntity), SENDER_REMOTE_ID);
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setUserId("root");
        this.activityManager.saveActivityNoReturn((ExoSocialActivity)activity);
        parentKudos.setActivityId(Long.parseLong(activity.getId()));
        this.kudosService.updateKudosGeneratedActivityId(parentKudos.getTechnicalId().longValue(), Long.parseLong(activity.getId()));
        KudosEntity childKudosEntity = this.newKudosInstance();
        childKudosEntity.setEntityType(KudosEntityType.ACTIVITY.ordinal());
        childKudosEntity.setEntityId(250L);
        childKudosEntity.setParentEntityId(Long.valueOf(parentKudos.getActivityId()));
        Kudos childKudos = this.kudosService.createKudos(Utils.fromEntity((KudosEntity)childKudosEntity), SENDER_REMOTE_ID);
        try {
            this.kudosService.getKudosListOfActivity(activity.getId(), null);
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        List kudosList = this.kudosService.getKudosListOfActivity("2556", new Identity("root"));
        Assertions.assertNotNull((Object)kudosList);
        Assertions.assertTrue((boolean)kudosList.isEmpty());
        try {
            this.kudosService.getKudosListOfActivity(activity.getId(), new Identity(SENDER_REMOTE_ID));
            Assertions.fail();
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        kudosList = this.kudosService.getKudosListOfActivity(activity.getId(), new Identity("root"));
        Assertions.assertNotNull((Object)kudosList);
        Assertions.assertEquals((int)2, (int)kudosList.size());
        Assertions.assertTrue((boolean)kudosList.stream().anyMatch(kudos -> kudos.getTechnicalId() == parentKudos.getTechnicalId()));
        Assertions.assertTrue((boolean)kudosList.stream().anyMatch(kudos -> kudos.getTechnicalId() == childKudos.getTechnicalId()));
        ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
        comment.setUserId("root,root4");
        this.activityManager.saveActivityNoReturn((ExoSocialActivity)comment);
        childKudos.setActivityId(Long.parseLong(comment.getId()));
        this.kudosService.updateKudosGeneratedActivityId(childKudos.getTechnicalId().longValue(), Long.parseLong(comment.getId()));
        KudosEntity subCommentKudosEntity = this.newKudosInstance();
        subCommentKudosEntity.setEntityType(KudosEntityType.COMMENT.ordinal());
        subCommentKudosEntity.setEntityId(255L);
        subCommentKudosEntity.setParentEntityId(Long.valueOf(parentKudos.getActivityId()));
        Kudos subCommentKudos = this.kudosService.createKudos(Utils.fromEntity((KudosEntity)subCommentKudosEntity), SENDER_REMOTE_ID);
        kudosList = this.kudosService.getKudosListOfActivity(activity.getId(), new Identity("root"));
        Assertions.assertNotNull((Object)kudosList);
        Assertions.assertEquals((int)3, (int)kudosList.size());
        Assertions.assertTrue((boolean)kudosList.stream().anyMatch(kudos -> kudos.getTechnicalId() == parentKudos.getTechnicalId()));
        Assertions.assertTrue((boolean)kudosList.stream().anyMatch(kudos -> kudos.getTechnicalId() == childKudos.getTechnicalId()));
        Assertions.assertTrue((boolean)kudosList.stream().anyMatch(kudos -> kudos.getTechnicalId() == subCommentKudos.getTechnicalId()));
    }

    @Test
    public void testUpdateKudos() {
        Kudos kudos = this.newKudosDTO();
        kudos.setEntityType(KudosEntityType.USER_PROFILE.name());
        kudos = this.kudosService.createKudos(kudos, SENDER_REMOTE_ID);
        Kudos storedKudos = this.kudosStorage.getKudoById(kudos.getTechnicalId().longValue());
        storedKudos.setMessage("updated message");
        Kudos newKudos = this.kudosService.updateKudos(storedKudos);
        Assertions.assertEquals((Object)newKudos.getMessage(), (Object)storedKudos.getMessage());
        this.compareResults(Utils.toEntity((Kudos)newKudos), storedKudos);
    }

    @Test
    public void testDeleteKudosById() {
        Kudos kudos = this.newKudosDTO();
        kudos.setEntityType(KudosEntityType.USER_PROFILE.name());
        kudos = this.kudosService.createKudos(kudos, SENDER_REMOTE_ID);
        long kudosId = kudos.getTechnicalId();
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.kudosService.deleteKudosById(0L, SENDER_REMOTE_ID));
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.kudosService.deleteKudosById(100L, SENDER_REMOTE_ID));
        Assertions.assertThrows(IllegalAccessException.class, () -> this.kudosService.deleteKudosById(kudosId, RECEIVER_REMOTE_ID));
        this.kudosService.deleteKudosById(kudosId, SENDER_REMOTE_ID);
        Kudos kudos1 = this.kudosStorage.getKudoById(kudos.getTechnicalId().longValue());
        Assertions.assertNull((Object)kudos1);
    }

    private void resetGlobalSettings() {
        GlobalSettings globalSettings = this.kudosService.getGlobalSettings();
        globalSettings.setKudosPeriodType(KudosPeriodType.WEEK);
        globalSettings.setKudosPerPeriod(100L);
        this.kudosService.saveGlobalSettings(globalSettings);
    }
}

