/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.kudos.listener;

import io.meeds.kudos.BaseKudosTest;
import io.meeds.kudos.model.Kudos;
import io.meeds.kudos.model.KudosEntityType;
import io.meeds.kudos.service.KudosService;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.junit.jupiter.SpringJUnitConfig;

@SpringJUnitConfig(value={BaseKudosTest.class})
public class GamificationIntegrationListenerTest
extends BaseKudosTest {
    private static final String SENDER_REMOTE_ID = "root4";
    private static final AtomicLong GAMIFICATION_SEND_KUDOS_EVENT_COUNT = new AtomicLong();
    private static final AtomicLong GAMIFICATION_RECEIVE_KUDOS_EVENT_COUNT = new AtomicLong();
    private static final AtomicLong GAMIFICATION_SAVE_KUDOS_EVENT_COUNT = new AtomicLong();
    private static final AtomicLong GAMIFICATION_CANCEL_KUDOS_EVENT_COUNT = new AtomicLong();
    private static final AtomicLong GAMIFICATION_LISTENER_COUNT = new AtomicLong();
    private static boolean listenerInstalled;
    @Autowired
    private KudosService kudosService;
    @Autowired
    private ListenerService listenerService;

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        this.resetCounters();
        if (!listenerInstalled) {
            Listener<Map<String, String>, String> listener = this.newListener();
            this.listenerService.addListener("exo.gamification.generic.action", listener);
            this.listenerService.addListener("gamification.cancel.event.action", listener);
            listenerInstalled = true;
        }
    }

    @Test
    public void testCreateKudos() throws Exception {
        this.createKudos();
        this.waitForListenerToBeCalled();
        Assertions.assertEquals((long)1L, (long)GAMIFICATION_SEND_KUDOS_EVENT_COUNT.get());
        Assertions.assertEquals((long)1L, (long)GAMIFICATION_RECEIVE_KUDOS_EVENT_COUNT.get());
        Assertions.assertEquals((long)2L, (long)GAMIFICATION_SAVE_KUDOS_EVENT_COUNT.get());
        Assertions.assertEquals((long)0L, (long)GAMIFICATION_CANCEL_KUDOS_EVENT_COUNT.get());
    }

    @Test
    public void testCancelKudosById() throws Exception {
        Kudos kudos = this.createKudos();
        this.waitForListenerToBeCalled();
        this.resetCounters();
        this.kudosService.deleteKudosById(kudos.getTechnicalId().longValue(), SENDER_REMOTE_ID);
        this.waitForListenerToBeCalled();
        Assertions.assertEquals((long)1L, (long)GAMIFICATION_SEND_KUDOS_EVENT_COUNT.get());
        Assertions.assertEquals((long)1L, (long)GAMIFICATION_RECEIVE_KUDOS_EVENT_COUNT.get());
        Assertions.assertEquals((long)0L, (long)GAMIFICATION_SAVE_KUDOS_EVENT_COUNT.get());
        Assertions.assertEquals((long)2L, (long)GAMIFICATION_CANCEL_KUDOS_EVENT_COUNT.get());
    }

    private Kudos createKudos() throws Exception {
        Kudos kudos = this.newKudosDTO();
        kudos.setEntityType(KudosEntityType.USER_PROFILE.name());
        return this.kudosService.createKudos(kudos, SENDER_REMOTE_ID);
    }

    private Listener<Map<String, String>, String> newListener() {
        return new GamificationTestListener();
    }

    private void resetCounters() {
        GAMIFICATION_LISTENER_COUNT.set(0L);
        GAMIFICATION_SEND_KUDOS_EVENT_COUNT.set(0L);
        GAMIFICATION_RECEIVE_KUDOS_EVENT_COUNT.set(0L);
        GAMIFICATION_SAVE_KUDOS_EVENT_COUNT.set(0L);
        GAMIFICATION_CANCEL_KUDOS_EVENT_COUNT.set(0L);
    }

    private void waitForListenerToBeCalled() {
        int tentatives = 3;
        while (tentatives-- > 0 && GAMIFICATION_LISTENER_COUNT.get() != 2L) {
            if (GAMIFICATION_LISTENER_COUNT.get() > 2L) {
                throw new IllegalStateException("Listener shouldn't be invoked more than twice, but was: " + GAMIFICATION_LISTENER_COUNT.get());
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        Assertions.assertTrue((tentatives >= 0 ? 1 : 0) != 0);
    }

    @Asynchronous
    public static class GamificationTestListener
    extends Listener<Map<String, String>, String> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onEvent(Event<Map<String, String>, String> event) throws Exception {
            try {
                String eventName = event.getEventName();
                if (StringUtils.equals((CharSequence)eventName, (CharSequence)"exo.gamification.generic.action")) {
                    GAMIFICATION_SAVE_KUDOS_EVENT_COUNT.incrementAndGet();
                } else if (StringUtils.equals((CharSequence)eventName, (CharSequence)"gamification.cancel.event.action")) {
                    GAMIFICATION_CANCEL_KUDOS_EVENT_COUNT.incrementAndGet();
                }
                Map gamificationMap = (Map)event.getSource();
                Assertions.assertNotNull((Object)gamificationMap);
                String ruleTitle = (String)gamificationMap.get("ruleTitle");
                if (StringUtils.equals((CharSequence)ruleTitle, (CharSequence)"sendKudos")) {
                    GAMIFICATION_SEND_KUDOS_EVENT_COUNT.incrementAndGet();
                } else if (StringUtils.equals((CharSequence)ruleTitle, (CharSequence)"receiveKudos")) {
                    GAMIFICATION_RECEIVE_KUDOS_EVENT_COUNT.incrementAndGet();
                }
            }
            finally {
                GAMIFICATION_LISTENER_COUNT.incrementAndGet();
            }
        }
    }
}

