/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.rest;

import io.meeds.layout.model.PortletInstanceCategory;
import io.meeds.layout.service.PortletInstanceService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/portlet/instance/categories"})
@Tag(name="/layout/rest/portlet/instance/categories", description="Managing portlet instance categorys")
public class PortletInstanceCategoryRest {
    @Autowired
    private PortletInstanceService portletInstanceService;

    @GetMapping
    @Secured(value={"users"})
    @Operation(summary="Retrieve portlet instance categorys", method="GET", description="This retrieves portlet instance categorys")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled")})
    public List<PortletInstanceCategory> getPortletInstanceCategorys(HttpServletRequest request) {
        return this.portletInstanceService.getPortletInstanceCategories(request.getRemoteUser(), request.getLocale(), true);
    }

    @GetMapping(value={"{id}"})
    @Secured(value={"users"})
    @Operation(summary="Retrieve a portlet instance category designated by its id", method="GET", description="This will retrieve a portlet instance category designated by its id")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not found")})
    public PortletInstanceCategory getPortletInstanceCategory(HttpServletRequest request, @Parameter(description="Portlet instance category identifier") @PathVariable(value="id") long id) {
        try {
            return this.portletInstanceService.getPortletInstanceCategory(id, request.getRemoteUser(), request.getLocale(), true);
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
    }

    @PostMapping
    @Secured(value={"users"})
    @Operation(summary="Create a portlet instance category", method="POST", description="This creates a new portlet instance category")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="403", description="Forbidden")})
    public PortletInstanceCategory createPortletInstanceCategory(HttpServletRequest request, @RequestBody PortletInstanceCategory portletInstanceCategory) {
        try {
            return this.portletInstanceService.createPortletInstanceCategory(portletInstanceCategory, request.getRemoteUser());
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN, e.getMessage());
        }
    }

    @PutMapping(value={"{id}"})
    @Secured(value={"users"})
    @Operation(summary="Update a portlet instance category", method="PUT", description="This updates an existing portlet instance category")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not found")})
    public void updatePortletInstanceCategory(HttpServletRequest request, @Parameter(description="Portlet instance category identifier") @PathVariable(value="id") long id, @RequestBody PortletInstanceCategory portletInstanceCategory) {
        try {
            portletInstanceCategory.setId(id);
            this.portletInstanceService.updatePortletInstanceCategory(portletInstanceCategory, request.getRemoteUser());
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN, e.getMessage());
        }
    }

    @DeleteMapping(value={"{id}"})
    @Secured(value={"users"})
    @Operation(summary="Deletes a portlet instance category", method="DELETE", description="This deletes an existing portlet instance category")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not found")})
    public void deletePortletInstanceCategory(HttpServletRequest request, @Parameter(description="Portlet instance category identifier") @PathVariable(value="id") long id) {
        try {
            this.portletInstanceService.deletePortletInstanceCategory(id, request.getRemoteUser());
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN, e.getMessage());
        }
    }
}

