/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.util;

import io.meeds.layout.entity.PortletInstanceCategoryEntity;
import io.meeds.layout.entity.PortletInstanceEntity;
import io.meeds.layout.model.PortletDescriptor;
import io.meeds.layout.model.PortletInstance;
import io.meeds.layout.model.PortletInstanceCategory;
import io.meeds.layout.model.PortletInstancePreference;
import io.meeds.layout.util.JsonUtils;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class EntityMapper {
    private EntityMapper() {
    }

    public static PortletInstanceCategory fromEntity(PortletInstanceCategoryEntity entity) {
        return new PortletInstanceCategory(entity.getId(), null, entity.getIcon(), entity.isSystem(), entity.getPermissions() == null ? Collections.emptyList() : entity.getPermissions().stream().filter(StringUtils::isNotBlank).toList());
    }

    public static PortletInstance fromEntity(PortletInstanceEntity entity, PortletDescriptor portlet) {
        return new PortletInstance(entity.getId(), null, null, entity.getCategoryId(), entity.getContentId(), 0L, EntityMapper.getPreferences(entity), 0L, entity.getPermissions() == null ? Collections.emptyList() : entity.getPermissions().stream().filter(StringUtils::isNotBlank).toList(), portlet == null ? null : portlet.getSupportedModes(), entity.isSystem(), entity.isDisabled());
    }

    public static PortletInstanceCategoryEntity toEntity(PortletInstanceCategory instance) {
        return new PortletInstanceCategoryEntity(instance.getId() == 0L ? null : Long.valueOf(instance.getId()), instance.getPermissions(), instance.getIcon(), instance.isSystem());
    }

    public static PortletInstanceEntity toEntity(PortletInstance instance) {
        return new PortletInstanceEntity(instance.getId() == 0L ? null : Long.valueOf(instance.getId()), instance.getCategoryId(), instance.getContentId(), instance.getPermissions(), EntityMapper.getPreferencesString(instance), instance.isSystem(), instance.isDisabled(), Objects.hash(instance.getCategoryId(), EntityMapper.getPreferencesString(instance), instance.getContentId()));
    }

    private static String getPreferencesString(PortletInstance instance) {
        if (CollectionUtils.isNotEmpty(instance.getPreferences())) {
            return JsonUtils.toJsonString(new PortletInstancePreferences(instance.getPreferences()));
        }
        return null;
    }

    private static List<PortletInstancePreference> getPreferences(PortletInstanceEntity entity) {
        if (StringUtils.isNotBlank((CharSequence)entity.getPreferences())) {
            return JsonUtils.fromJsonString(entity.getPreferences(), PortletInstancePreferences.class).getPreferences();
        }
        return Collections.emptyList();
    }

    public static class PortletInstancePreferences {
        private List<PortletInstancePreference> preferences;

        public List<PortletInstancePreference> getPreferences() {
            return this.preferences;
        }

        public void setPreferences(List<PortletInstancePreference> preferences) {
            this.preferences = preferences;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PortletInstancePreferences)) {
                return false;
            }
            PortletInstancePreferences other = (PortletInstancePreferences)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<PortletInstancePreference> this$preferences = this.getPreferences();
            List<PortletInstancePreference> other$preferences = other.getPreferences();
            return !(this$preferences == null ? other$preferences != null : !((Object)this$preferences).equals(other$preferences));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PortletInstancePreferences;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<PortletInstancePreference> $preferences = this.getPreferences();
            result = result * 59 + ($preferences == null ? 43 : ((Object)$preferences).hashCode());
            return result;
        }

        public String toString() {
            return "EntityMapper.PortletInstancePreferences(preferences=" + String.valueOf(this.getPreferences()) + ")";
        }

        public PortletInstancePreferences() {
        }

        public PortletInstancePreferences(List<PortletInstancePreference> preferences) {
            this.preferences = preferences;
        }
    }
}

