/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.plugin.attachment;

import io.meeds.layout.service.LayoutAclService;
import jakarta.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.attachment.AttachmentPlugin;
import org.exoplatform.social.attachment.AttachmentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=-2147483648)
public class LayoutBackgroundAttachmentPlugin
extends AttachmentPlugin {
    public static final String OBJECT_TYPE = "containerBackground";
    private static final String PAGE_PREFIX = "page_";
    private static final String SITE_PREFIX = "site_";
    @Autowired
    private LayoutAclService layoutAclService;
    @Autowired
    private LayoutService layoutService;
    @Autowired
    private AttachmentService attachmentService;

    @PostConstruct
    public void init() {
        this.attachmentService.addPlugin((AttachmentPlugin)this);
    }

    public String getObjectType() {
        return OBJECT_TYPE;
    }

    public boolean hasEditPermission(Identity userIdentity, String entityId) throws ObjectNotFoundException {
        if (StringUtils.contains((CharSequence)entityId, (CharSequence)SITE_PREFIX)) {
            SiteKey siteKey = this.getSiteKey(entityId);
            return this.layoutAclService.canEditSite(siteKey, this.getUsername(userIdentity));
        }
        PageKey pageKey = this.getPageKey(entityId);
        return pageKey != null && this.layoutAclService.canEditPage(pageKey, this.getUsername(userIdentity));
    }

    public boolean hasAccessPermission(Identity userIdentity, String entityId) throws ObjectNotFoundException {
        if (StringUtils.contains((CharSequence)entityId, (CharSequence)SITE_PREFIX)) {
            SiteKey siteKey = this.getSiteKey(entityId);
            return siteKey.getType() == SiteType.GROUP_TEMPLATE || siteKey.getType() == SiteType.PORTAL_TEMPLATE || this.layoutAclService.canViewSite(siteKey, this.getUsername(userIdentity));
        }
        PageKey pageKey = this.getPageKey(entityId);
        if (pageKey == null) {
            return false;
        }
        SiteKey siteKey = pageKey.getSite();
        return siteKey.getType() == SiteType.GROUP_TEMPLATE || siteKey.getType() == SiteType.PORTAL_TEMPLATE || this.layoutAclService.canViewPage(pageKey, this.getUsername(userIdentity));
    }

    public long getAudienceId(String objectId) throws ObjectNotFoundException {
        return 0L;
    }

    public long getSpaceId(String objectId) throws ObjectNotFoundException {
        return 0L;
    }

    private PageKey getPageKey(String entityId) {
        long pageId;
        String pageUuid = entityId.split("_")[0].replace(PAGE_PREFIX, "");
        long l = pageId = StringUtils.isNumeric((CharSequence)pageUuid) ? Long.parseLong(pageUuid) : 0L;
        if (pageId == 0L) {
            pageUuid = entityId.replace(PAGE_PREFIX, "").split("_")[0];
            long l2 = pageId = StringUtils.isNumeric((CharSequence)pageUuid) ? Long.parseLong(pageUuid) : 0L;
        }
        if (pageId == 0L) {
            return null;
        }
        Page page = this.layoutService.getPage(pageId);
        return page.getPageKey();
    }

    private SiteKey getSiteKey(String entityId) {
        String siteUuid = entityId.replace(SITE_PREFIX, "").split("_")[0];
        long siteId = StringUtils.isNumeric((CharSequence)siteUuid) ? Long.parseLong(siteUuid) : 0L;
        PortalConfig site = this.layoutService.getPortalConfig(siteId);
        return new SiteKey(site.getType(), site.getName());
    }

    private String getUsername(Identity userIdentity) {
        return userIdentity == null ? null : userIdentity.getUserId();
    }
}

