/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.service;

import io.meeds.layout.model.SectionTemplate;
import io.meeds.layout.model.SectionTemplateDetail;
import io.meeds.layout.service.ContainerLayoutService;
import io.meeds.layout.service.LayoutAclService;
import io.meeds.layout.storage.SectionTemplateLayoutStorage;
import io.meeds.layout.storage.SectionTemplateStorage;
import io.meeds.social.translation.model.TranslationField;
import io.meeds.social.translation.service.TranslationService;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.mop.navigation.NodeData;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.social.attachment.AttachmentService;
import org.springframework.stereotype.Service;

@Service
public class SectionTemplateService {
    private static final String SECTION_TEMPLATE_DOESN_T_EXIST_MESSAGE = "Section Template doesn't exist";
    public static final String TEMPLATE_CREATED_EVENT = "layout.sectionTemplate.created";
    public static final String TEMPLATE_UPDATED_EVENT = "layout.sectionTemplate.updated";
    public static final String TEMPLATE_DELETED_EVENT = "layout.sectionTemplate.deleted";
    private static final Log LOG = ExoLogger.getLogger(SectionTemplateService.class);
    private LayoutAclService layoutAclService;
    private TranslationService translationService;
    private AttachmentService attachmentService;
    private LocaleConfigService localeConfigService;
    private SectionTemplateStorage sectionTemplateStorage;
    private SectionTemplateLayoutStorage sectionTemplateLayoutStorage;
    private ContainerLayoutService containerLayoutService;
    private ListenerService listenerService;

    public SectionTemplateService(LayoutAclService layoutAclService, TranslationService translationService, AttachmentService attachmentService, LocaleConfigService localeConfigService, SectionTemplateStorage sectionTemplateStorage, SectionTemplateLayoutStorage sectionTemplateLayoutStorage, ContainerLayoutService containerLayoutService, ListenerService listenerService) {
        this.layoutAclService = layoutAclService;
        this.translationService = translationService;
        this.attachmentService = attachmentService;
        this.localeConfigService = localeConfigService;
        this.sectionTemplateStorage = sectionTemplateStorage;
        this.sectionTemplateLayoutStorage = sectionTemplateLayoutStorage;
        this.containerLayoutService = containerLayoutService;
        this.listenerService = listenerService;
    }

    public List<SectionTemplate> getSectionTemplates() {
        return this.sectionTemplateStorage.getSectionTemplates();
    }

    public List<SectionTemplateDetail> getSectionTemplates(Locale locale) {
        List<SectionTemplate> sectionTemplates = this.sectionTemplateStorage.getSectionTemplates();
        return sectionTemplates.stream().map(t -> this.computeSectionTemplateAttributes((SectionTemplate)t, locale)).toList();
    }

    public SectionTemplate getSectionTemplate(long id) {
        return this.sectionTemplateStorage.getSectionTemplate(id);
    }

    public SectionTemplateDetail getSectionTemplate(long id, Locale locale) throws ObjectNotFoundException {
        SectionTemplate sectionTemplate = this.getSectionTemplate(id);
        if (sectionTemplate == null) {
            throw new ObjectNotFoundException("Section Template not found");
        }
        return this.computeSectionTemplateAttributes(sectionTemplate, locale);
    }

    public SectionTemplate createSectionTemplate(SectionTemplate sectionTemplate, String username) throws IllegalAccessException {
        if (!this.layoutAclService.isAdministrator(username)) {
            throw new IllegalAccessException("User isn't authorized to create a Section Template");
        }
        return this.createSectionTemplateWithUser(sectionTemplate, username);
    }

    public SectionTemplate createSectionTemplate(SectionTemplate sectionTemplate) {
        return this.createSectionTemplateWithUser(sectionTemplate, null);
    }

    public void deleteSectionTemplate(long id, String username) throws IllegalAccessException, ObjectNotFoundException {
        if (!this.layoutAclService.isAdministrator(username)) {
            throw new IllegalAccessException("User isn't authorized to delete a Section Template");
        }
        SectionTemplate sectionTemplate = this.getSectionTemplate(id);
        if (sectionTemplate == null) {
            throw new ObjectNotFoundException(SECTION_TEMPLATE_DOESN_T_EXIST_MESSAGE);
        }
        if (sectionTemplate.isSystem()) {
            throw new IllegalAccessException("Can't delete a system Section Template");
        }
        this.deleteSectionTemplateFromStore(id);
        this.listenerService.broadcast(TEMPLATE_DELETED_EVENT, (Object)username, (Object)sectionTemplate);
    }

    public void deleteSectionTemplate(long id) throws ObjectNotFoundException {
        SectionTemplate sectionTemplate = this.getSectionTemplate(id);
        if (sectionTemplate == null) {
            throw new ObjectNotFoundException(SECTION_TEMPLATE_DOESN_T_EXIST_MESSAGE);
        }
        this.deleteSectionTemplateFromStore(id);
        this.listenerService.broadcast(TEMPLATE_DELETED_EVENT, null, (Object)sectionTemplate);
    }

    public SectionTemplate updateSectionTemplate(SectionTemplate sectionTemplate, String username) throws ObjectNotFoundException, IllegalAccessException {
        if (!this.layoutAclService.isAdministrator(username)) {
            throw new IllegalAccessException("User isn't authorized to update a Section Template");
        }
        return this.updateSectionTemplateWithUser(sectionTemplate, username);
    }

    public SectionTemplate updateSectionTemplate(SectionTemplate sectionTemplate) throws ObjectNotFoundException {
        return this.updateSectionTemplateWithUser(sectionTemplate, null);
    }

    public SectionTemplate saveAsSectionTemplate(PageKey pageKey, long containerId, String username) throws ObjectNotFoundException, IllegalAccessException {
        if (!this.layoutAclService.isAdministrator(username)) {
            throw new IllegalAccessException("User isn't authorized to edit the Section Template layout");
        }
        Container container = this.containerLayoutService.findContainer(pageKey, containerId);
        if (container == null) {
            throw new ObjectNotFoundException(String.format("Container %s from Page %s doesn't exist", containerId, pageKey));
        }
        SectionTemplate sectionTemplate = new SectionTemplate();
        sectionTemplate.setCategory("custom");
        sectionTemplate.setContent("");
        sectionTemplate.setDisabled(false);
        sectionTemplate.setSystem(false);
        sectionTemplate = this.createSectionTemplate(sectionTemplate);
        String content = this.sectionTemplateLayoutStorage.generateSectionTemplateContent(sectionTemplate, container, username);
        sectionTemplate.setContent(content);
        return this.updateSectionTemplate(sectionTemplate);
    }

    public long generateSectionTemplateNodeId(long id, String username) throws ObjectNotFoundException, IllegalAccessException {
        if (!this.layoutAclService.isAdministrator(username)) {
            throw new IllegalAccessException("User isn't authorized to edit the Section Template layout");
        }
        SectionTemplate sectionTemplate = this.getSectionTemplate(id);
        if (sectionTemplate == null) {
            throw new ObjectNotFoundException(SECTION_TEMPLATE_DOESN_T_EXIST_MESSAGE);
        }
        NodeData clonedPageNode = this.sectionTemplateLayoutStorage.generateSectionTemplateNodeId(sectionTemplate, username);
        return Long.parseLong(clonedPageNode.getId());
    }

    public String generateSectionTemplateContent(long id, String username) throws IllegalAccessException, ObjectNotFoundException {
        if (!this.layoutAclService.isAdministrator(username)) {
            throw new IllegalAccessException("User isn't authorized to update a Section Template");
        }
        SectionTemplate sectionTemplate = this.getSectionTemplate(id);
        if (sectionTemplate == null) {
            throw new ObjectNotFoundException(SECTION_TEMPLATE_DOESN_T_EXIST_MESSAGE);
        }
        return this.sectionTemplateLayoutStorage.generateSectionTemplateContent(sectionTemplate, username);
    }

    private void deleteSectionTemplateFromStore(long id) throws ObjectNotFoundException {
        try {
            this.attachmentService.deleteAttachments("sectionTemplate", String.valueOf(id));
        }
        catch (Exception e) {
            LOG.debug((Object)"Error while deleting attachments of deleted Section Template", (Throwable)e);
        }
        try {
            this.translationService.deleteTranslationLabels("sectionTemplate", id);
        }
        catch (Exception e) {
            LOG.debug((Object)"Error while deleting translation labels of deleted Section Template", (Throwable)e);
        }
        this.sectionTemplateStorage.deleteSectionTemplate(id);
    }

    private SectionTemplateDetail computeSectionTemplateAttributes(SectionTemplate sectionTemplate, Locale locale) {
        if (locale == null) {
            return new SectionTemplateDetail(sectionTemplate);
        }
        SectionTemplateDetail sectionTemplateDetail = new SectionTemplateDetail(sectionTemplate);
        sectionTemplateDetail.setName(this.getLabel("sectionTemplate", sectionTemplateDetail.getId(), "title", locale));
        sectionTemplateDetail.setDescription(this.getLabel("sectionTemplate", sectionTemplateDetail.getId(), "description", locale));
        List attachmentFileIds = this.attachmentService.getAttachmentFileIds("sectionTemplate", String.valueOf(sectionTemplateDetail.getId()));
        if (CollectionUtils.isNotEmpty((Collection)attachmentFileIds)) {
            sectionTemplateDetail.setIllustrationId(Long.parseLong((String)attachmentFileIds.get(0)));
        }
        return sectionTemplateDetail;
    }

    private String getLabel(String objectType, long objectId, String fieldName, Locale locale) {
        if (locale == null) {
            locale = this.localeConfigService.getDefaultLocaleConfig().getLocale();
        }
        try {
            TranslationField translationField = this.translationService.getTranslationField(objectType, objectId, fieldName);
            if (translationField != null && MapUtils.isNotEmpty((Map)translationField.getLabels())) {
                String label = (String)translationField.getLabels().get(locale);
                if (label == null) {
                    Locale defaultLocale = this.localeConfigService.getDefaultLocaleConfig().getLocale();
                    label = (String)translationField.getLabels().get(defaultLocale);
                }
                if (label == null) {
                    label = (String)translationField.getLabels().values().iterator().next();
                }
                return label;
            }
            return null;
        }
        catch (ObjectNotFoundException e) {
            return null;
        }
    }

    private SectionTemplate createSectionTemplateWithUser(SectionTemplate sectionTemplate, String username) {
        SectionTemplate createdSectionTemplate = this.sectionTemplateStorage.createSectionTemplate(sectionTemplate);
        this.listenerService.broadcast(TEMPLATE_CREATED_EVENT, (Object)username, (Object)createdSectionTemplate);
        return createdSectionTemplate;
    }

    private SectionTemplate updateSectionTemplateWithUser(SectionTemplate sectionTemplate, String username) throws ObjectNotFoundException {
        SectionTemplate updatedSectionTemplate = this.sectionTemplateStorage.updateSectionTemplate(sectionTemplate);
        this.listenerService.broadcast(TEMPLATE_UPDATED_EVENT, (Object)username, (Object)updatedSectionTemplate);
        return updatedSectionTemplate;
    }
}

