/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.service;

import jakarta.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.security.IdentityRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LayoutAclService {
    @Autowired
    private UserACL userAcl;
    @Autowired
    private LayoutService layoutService;
    @Autowired
    private Authenticator authenticator;
    private IdentityRegistry identityRegistry;

    @PostConstruct
    public void init() {
        this.setIdentityRegistry((IdentityRegistry)ExoContainerContext.getService(IdentityRegistry.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canAddSite(String username) {
        ConversationState currentConversationState = ConversationState.getCurrent();
        ConversationState.setCurrent((ConversationState)this.getConversationState(username));
        try {
            boolean bl = this.userAcl.hasCreatePortalPermission();
            return bl;
        }
        finally {
            ConversationState.setCurrent((ConversationState)currentConversationState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canEditSite(SiteKey siteKey, String username) {
        PortalConfig portalConfig = this.layoutService.getPortalConfig(siteKey);
        if (portalConfig == null) {
            return false;
        }
        ConversationState currentConversationState = ConversationState.getCurrent();
        ConversationState.setCurrent((ConversationState)this.getConversationState(username));
        try {
            boolean bl = this.userAcl.hasEditPermission(portalConfig);
            return bl;
        }
        finally {
            ConversationState.setCurrent((ConversationState)currentConversationState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canViewSite(SiteKey siteKey, String username) {
        PortalConfig portalConfig = this.layoutService.getPortalConfig(siteKey);
        if (portalConfig == null) {
            return false;
        }
        ConversationState currentConversationState = ConversationState.getCurrent();
        ConversationState.setCurrent((ConversationState)this.getConversationState(username));
        try {
            boolean bl = this.userAcl.hasPermission(portalConfig);
            return bl;
        }
        finally {
            ConversationState.setCurrent((ConversationState)currentConversationState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canEditNavigation(SiteKey siteKey, String username) {
        PortalConfig portalConfig = this.layoutService.getPortalConfig(siteKey);
        if (portalConfig == null) {
            return false;
        }
        ConversationState currentConversationState = ConversationState.getCurrent();
        ConversationState.setCurrent((ConversationState)this.getConversationState(username));
        try {
            boolean bl = this.userAcl.hasEditPermission(portalConfig) || this.userAcl.hasEditPermissionOnNavigation(siteKey);
            return bl;
        }
        finally {
            ConversationState.setCurrent((ConversationState)currentConversationState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canViewNavigation(SiteKey siteKey, PageKey pageKey, String username) {
        PortalConfig portalConfig = this.layoutService.getPortalConfig(siteKey);
        if (portalConfig == null) {
            return false;
        }
        Page page = pageKey == null ? null : this.layoutService.getPage(pageKey);
        ConversationState currentConversationState = ConversationState.getCurrent();
        ConversationState.setCurrent((ConversationState)this.getConversationState(username));
        try {
            boolean bl = this.userAcl.hasAccessPermission(portalConfig) && (page == null || this.userAcl.hasPermission(page));
            return bl;
        }
        finally {
            ConversationState.setCurrent((ConversationState)currentConversationState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canViewPage(PageKey pageKey, String username) {
        Page page = this.layoutService.getPage(pageKey);
        if (page == null) {
            return false;
        }
        ConversationState currentConversationState = ConversationState.getCurrent();
        ConversationState.setCurrent((ConversationState)this.getConversationState(username));
        try {
            boolean bl = this.userAcl.hasPermission(page);
            return bl;
        }
        finally {
            ConversationState.setCurrent((ConversationState)currentConversationState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canEditPage(PageKey pageKey, String username) {
        Page page = this.layoutService.getPage(pageKey);
        if (page == null) {
            return false;
        }
        ConversationState currentConversationState = ConversationState.getCurrent();
        ConversationState.setCurrent((ConversationState)this.getConversationState(username));
        try {
            boolean bl = this.userAcl.hasEditPermission(page);
            return bl;
        }
        finally {
            ConversationState.setCurrent((ConversationState)currentConversationState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAdministrator(String username) {
        ConversationState currentConversationState = ConversationState.getCurrent();
        ConversationState.setCurrent((ConversationState)this.getConversationState(username));
        try {
            boolean bl = this.userAcl.isSuperUser() || this.userAcl.isUserInGroup(this.getAdministratorsGroup());
            return bl;
        }
        finally {
            ConversationState.setCurrent((ConversationState)currentConversationState);
        }
    }

    public String getAdministratorsGroup() {
        return this.userAcl.getAdminGroups();
    }

    public ConversationState getSuperUserConversationState() {
        return new ConversationState(this.getUserIdentity(this.userAcl.getSuperUser()));
    }

    private ConversationState getConversationState(String username) {
        return new ConversationState(this.getUserIdentity(username));
    }

    private Identity getUserIdentity(String username) {
        if (StringUtils.isBlank((CharSequence)username) || IdentityConstants.ANONIM.equals(username)) {
            return null;
        }
        Identity identity = this.identityRegistry.getIdentity(username);
        if (identity != null) {
            return identity;
        }
        return this.authenticator.createIdentity(username);
    }

    public void setIdentityRegistry(IdentityRegistry identityRegistry) {
        this.identityRegistry = identityRegistry;
    }
}

