/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.service;

import com.google.javascript.jscomp.jarjar.com.google.re2j.Pattern;
import io.meeds.layout.model.PageCreateModel;
import io.meeds.layout.model.PageTemplate;
import io.meeds.layout.model.PermissionUpdateModel;
import io.meeds.layout.rest.model.LayoutModel;
import io.meeds.layout.service.LayoutAclService;
import io.meeds.layout.service.PageTemplateService;
import io.meeds.layout.util.JsonUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.PageType;
import org.exoplatform.portal.mop.QueryResult;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.Utils;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.page.PageState;
import org.exoplatform.portal.mop.service.LayoutService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PageLayoutService {
    public static final String EMPTY_PAGE_TEMPLATE = "empty";
    private static final Pattern COLOR_MATCHER_VALIDATOR = Pattern.compile((String)"[#0-9a-zA-Z]+");
    private static final Pattern SIZE_MATCHER_VALIDATOR = Pattern.compile((String)"[0-9a-zA-Z%]+");
    private static final String PAGE_NOT_EXISTS_MESSAGE = "Page with key %s doesn't exist";
    private static final String PAGE_NOT_ACCESSIBLE_MESSAGE = "Page with ref %s isn't accessible for user %s";
    private static final String PAGE_NOT_EDITABLE_MESSAGE = "Page with ref %s isn't editable for user %s";
    @Autowired
    private LayoutService layoutService;
    @Autowired
    private LayoutAclService aclService;
    @Autowired
    private PageTemplateService pageTemplateService;
    @Autowired
    private UserPortalConfigService userPortalConfigService;

    public List<PageContext> getPages(String siteTypeName, String siteName, String pageDisplayName, int offset, int limit, String username) {
        SiteType siteType = null;
        if (StringUtils.isNotBlank((CharSequence)siteTypeName)) {
            siteType = SiteType.valueOf((String)siteTypeName.toUpperCase());
        }
        QueryResult queryResult = this.layoutService.findPages(offset, limit, siteType, siteName, null, pageDisplayName);
        ArrayList pages = new ArrayList();
        queryResult.iterator().forEachRemaining(pages::add);
        return pages.stream().filter(p -> this.aclService.canViewPage(p.getKey(), username)).toList();
    }

    public PageContext getPage(PageKey pageKey, String username) throws ObjectNotFoundException, IllegalAccessException {
        PageContext page = this.layoutService.getPageContext(pageKey);
        if (page == null) {
            throw new ObjectNotFoundException(String.format(PAGE_NOT_ACCESSIBLE_MESSAGE, pageKey, username));
        }
        if (!this.aclService.canViewPage(pageKey, username)) {
            throw new IllegalAccessException(String.format(PAGE_NOT_ACCESSIBLE_MESSAGE, pageKey, username));
        }
        return page;
    }

    public Page getPageLayout(PageKey pageKey, String username) throws ObjectNotFoundException, IllegalAccessException {
        Page page = this.getPageLayout(pageKey);
        if (page == null) {
            throw new ObjectNotFoundException(String.format(PAGE_NOT_ACCESSIBLE_MESSAGE, pageKey, username));
        }
        if (!this.aclService.canViewPage(pageKey, username)) {
            throw new IllegalAccessException(String.format(PAGE_NOT_ACCESSIBLE_MESSAGE, pageKey, username));
        }
        return page;
    }

    public Page getPageLayout(PageKey pageKey) {
        return this.layoutService.getPage(pageKey);
    }

    public PageContext createPage(PageCreateModel pageModel, String username) throws ObjectNotFoundException, IllegalAccessException, IllegalArgumentException {
        SiteKey siteKey = new SiteKey(pageModel.getPageSiteType(), pageModel.getPageSiteName());
        PortalConfig portalConfig = this.layoutService.getPortalConfig(siteKey);
        if (portalConfig == null) {
            throw new ObjectNotFoundException(String.format("Site with key %s doesn't exist", siteKey));
        }
        if (!this.aclService.canEditNavigation(siteKey, username)) {
            throw new IllegalAccessException();
        }
        String pageName = pageModel.getPageName() == null ? UUID.randomUUID().toString() : pageModel.getPageName() + "_" + UUID.randomUUID();
        Page page = this.createPageInstance(pageModel.getPageSiteType(), pageModel.getPageSiteName(), pageName, this.getPageType(pageModel.getPageType()), pageModel.getPageTemplateId(), pageModel.getLink());
        page.setName(pageName);
        page.setTitle(pageModel.getPageTitle());
        String[] accessPermissions = pageModel.getAccessPermissions() == null ? portalConfig.getAccessPermissions() : pageModel.getAccessPermissions();
        page.setAccessPermissions(accessPermissions);
        String editPermission = pageModel.getEditPermission() == null ? portalConfig.getEditPermission() : pageModel.getEditPermission();
        page.setEditPermission(editPermission);
        this.layoutService.save(new PageContext(page.getPageKey(), Utils.toPageState((Page)page)), page);
        return this.layoutService.getPageContext(page.getPageKey());
    }

    public PageKey clonePage(PageKey pageKey, String username) throws IllegalAccessException, ObjectNotFoundException {
        Page page = this.layoutService.getPage(pageKey);
        if (page == null) {
            throw new ObjectNotFoundException(String.format(PAGE_NOT_EXISTS_MESSAGE, pageKey.format()));
        }
        if (!this.aclService.canEditPage(pageKey, username)) {
            throw new IllegalAccessException(String.format(PAGE_NOT_EDITABLE_MESSAGE, pageKey.format(), username));
        }
        page.resetStorage();
        page.setName(page.getName() + "_draft_" + username);
        page.setTitle(page.getTitle() + " Draft " + username);
        this.layoutService.save(new PageContext(page.getPageKey(), Utils.toPageState((Page)page)), page);
        return page.getPageKey();
    }

    public PageContext updatePageLayout(String pageRef, Page page, boolean publish, String username) throws IllegalAccessException, ObjectNotFoundException {
        PageKey pageKey = PageKey.parse((String)pageRef);
        Page existingPage = this.layoutService.getPage(pageKey);
        if (existingPage == null) {
            throw new ObjectNotFoundException(String.format(PAGE_NOT_EXISTS_MESSAGE, pageKey.format()));
        }
        if (!this.aclService.canEditPage(pageKey, username)) {
            throw new IllegalAccessException(String.format(PAGE_NOT_EDITABLE_MESSAGE, pageKey.format(), username));
        }
        if (publish) {
            page.resetStorage();
        }
        this.validateCSSInputs((ModelObject)page);
        existingPage.setChildren(page.getChildren());
        this.layoutService.save(existingPage);
        return this.layoutService.getPageContext(existingPage.getPageKey());
    }

    public void updatePageLink(PageKey pageKey, String link, String username) throws ObjectNotFoundException, IllegalAccessException, IllegalStateException {
        PageContext pageContext = this.layoutService.getPageContext(pageKey);
        if (pageContext == null) {
            throw new ObjectNotFoundException(String.format(PAGE_NOT_EXISTS_MESSAGE, pageKey));
        }
        if (!this.aclService.canEditPage(pageKey, username)) {
            throw new IllegalAccessException();
        }
        PageState pageState = pageContext.getState();
        PageType pageType = this.getPageType(pageState.getType());
        if (pageType != PageType.LINK) {
            throw new IllegalStateException(String.format("Page %s isn't of type 'LINK'", pageKey));
        }
        pageContext.setState(new PageState(pageState.getDisplayName(), pageState.getDescription(), pageState.getShowMaxWindow(), pageState.getFactoryId(), pageState.getAccessPermissions(), pageState.getEditPermission(), pageState.getMoveAppsPermissions(), pageState.getMoveContainersPermissions(), pageState.getType(), link));
        this.layoutService.save(pageContext);
    }

    public void updatePagePermissions(PageKey pageKey, PermissionUpdateModel permissionUpdateModel, String username) throws ObjectNotFoundException, IllegalAccessException {
        PageContext pageContext = this.layoutService.getPageContext(pageKey);
        if (pageContext == null) {
            throw new ObjectNotFoundException(String.format(PAGE_NOT_EXISTS_MESSAGE, pageKey));
        }
        if (!this.aclService.canEditPage(pageKey, username)) {
            throw new IllegalAccessException();
        }
        PageState pageState = pageContext.getState();
        List<String> accessPermissionsList = permissionUpdateModel.getAccessPermissions();
        String editPermission = permissionUpdateModel.getEditPermission();
        pageContext.setState(new PageState(pageState.getDisplayName(), pageState.getDescription(), pageState.getShowMaxWindow(), pageState.getFactoryId(), accessPermissionsList, editPermission, pageState.getMoveAppsPermissions(), pageState.getMoveContainersPermissions(), pageState.getType(), pageState.getLink()));
        this.layoutService.save(pageContext);
    }

    private Page createPageInstance(String siteType, String siteName, String pageName, PageType pageType, Long pageTemplateId, String pageLink) throws IllegalArgumentException {
        Page page;
        if (pageType == PageType.PAGE) {
            if (pageTemplateId == null) {
                throw new IllegalArgumentException("pageTemplateId is mandatory");
            }
            PageTemplate pageTemplate = this.pageTemplateService.getPageTemplate(pageTemplateId);
            if (pageTemplate == null) {
                throw new ObjectNotFoundException("pageTemplate not found");
            }
            page = this.userPortalConfigService.createPageTemplate(EMPTY_PAGE_TEMPLATE, siteType, siteName);
            Page pageLayout = JsonUtils.fromJsonString(pageTemplate.getContent(), LayoutModel.class).toPage();
            page.setChildren(pageLayout.getChildren());
            page.resetStorage();
            page.setName(pageName);
        } else if (pageType == PageType.LINK) {
            page = new Page(siteType, siteName, pageName);
            page.setLink(pageLink);
        } else {
            throw new IllegalArgumentException("pageType is mandatory");
        }
        page.setType(pageType.name());
        return page;
    }

    private PageType getPageType(String pageType) {
        return StringUtils.isBlank((CharSequence)pageType) ? PageType.PAGE : PageType.valueOf((String)pageType.toUpperCase());
    }

    private void validateCSSInputs(ModelObject modelObject) {
        String borderColor;
        String height;
        String width;
        if (modelObject instanceof Container) {
            Container container = (Container)modelObject;
            width = container.getWidth();
            height = container.getHeight();
            borderColor = container.getBorderColor();
            if (!CollectionUtils.isEmpty((Collection)container.getChildren())) {
                container.getChildren().forEach(this::validateCSSInputs);
            }
        } else if (modelObject instanceof Application) {
            Application application = (Application)modelObject;
            width = application.getWidth();
            height = application.getHeight();
            borderColor = application.getBorderColor();
        } else {
            return;
        }
        if (width != null && !SIZE_MATCHER_VALIDATOR.matches(width)) {
            throw new IllegalArgumentException(String.format("Container with id %s has an invalid width input %s", modelObject.getStorageId(), width));
        }
        if (height != null && !SIZE_MATCHER_VALIDATOR.matches(height)) {
            throw new IllegalArgumentException(String.format("Container with id %s has an invalid height input %s", modelObject.getStorageId(), height));
        }
        if (borderColor != null && !COLOR_MATCHER_VALIDATOR.matches(borderColor)) {
            throw new IllegalArgumentException(String.format("Container with id %s has an invalid border color input %s", modelObject.getStorageId(), borderColor));
        }
    }
}

