/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.service;

import io.meeds.layout.service.LayoutAclService;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.IdentityRegistry;
import org.junit.Assert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={LayoutAclService.class})
@ExtendWith(value={MockitoExtension.class})
public class LayoutAclServiceTest {
    private static final String TEST_USER = "testuser";
    private static final SiteKey SITE_KEY = SiteKey.portal((String)"test");
    private static final PageKey PAGE_KEY = PageKey.parse((String)"portal::test::test");
    @MockBean
    private UserACL userAcl;
    @MockBean
    private LayoutService layoutService;
    @MockBean
    private Authenticator authenticator;
    @Mock
    private IdentityRegistry identityRegistry;
    @Autowired
    private LayoutAclService layoutAclService;
    @Mock
    private PortalConfig portalConfig;
    @Mock
    private Page page;

    @BeforeEach
    public void setup() {
        this.layoutAclService.setIdentityRegistry(this.identityRegistry);
    }

    @Test
    public void canAddSite() {
        Assert.assertFalse((boolean)this.layoutAclService.canAddSite(TEST_USER));
        Mockito.when((Object)this.userAcl.hasCreatePortalPermission()).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.layoutAclService.canAddSite(TEST_USER));
    }

    @Test
    public void canEditSite() {
        Assert.assertFalse((boolean)this.layoutAclService.canEditSite(SITE_KEY, TEST_USER));
        Mockito.when((Object)this.layoutService.getPortalConfig(SITE_KEY)).thenReturn((Object)this.portalConfig);
        Assert.assertFalse((boolean)this.layoutAclService.canEditSite(SITE_KEY, TEST_USER));
        Mockito.when((Object)this.userAcl.hasEditPermission(this.portalConfig)).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.layoutAclService.canEditSite(SITE_KEY, TEST_USER));
    }

    @Test
    public void canViewSite() {
        Assert.assertFalse((boolean)this.layoutAclService.canViewSite(SITE_KEY, TEST_USER));
        Mockito.when((Object)this.layoutService.getPortalConfig(SITE_KEY)).thenReturn((Object)this.portalConfig);
        Assert.assertFalse((boolean)this.layoutAclService.canViewSite(SITE_KEY, TEST_USER));
        Mockito.when((Object)this.userAcl.hasPermission(this.portalConfig)).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.layoutAclService.canViewSite(SITE_KEY, TEST_USER));
    }

    @Test
    public void canEditNavigation() {
        Assert.assertFalse((boolean)this.layoutAclService.canEditNavigation(SITE_KEY, TEST_USER));
        Mockito.when((Object)this.layoutService.getPortalConfig(SITE_KEY)).thenReturn((Object)this.portalConfig);
        Assert.assertFalse((boolean)this.layoutAclService.canEditNavigation(SITE_KEY, TEST_USER));
        Mockito.when((Object)this.userAcl.hasEditPermission(this.portalConfig)).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.layoutAclService.canEditNavigation(SITE_KEY, TEST_USER));
    }

    @Test
    public void canViewNavigation() {
        Assert.assertFalse((boolean)this.layoutAclService.canViewNavigation(SITE_KEY, null, TEST_USER));
        Mockito.when((Object)this.layoutService.getPortalConfig(SITE_KEY)).thenReturn((Object)this.portalConfig);
        Assert.assertFalse((boolean)this.layoutAclService.canViewNavigation(SITE_KEY, null, TEST_USER));
        Mockito.when((Object)this.userAcl.hasAccessPermission(this.portalConfig)).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.layoutAclService.canViewNavigation(SITE_KEY, null, TEST_USER));
    }

    @Test
    public void canViewNavigationWithPage() {
        Mockito.when((Object)this.layoutService.getPortalConfig(SITE_KEY)).thenReturn((Object)this.portalConfig);
        Mockito.when((Object)this.layoutService.getPage(PAGE_KEY)).thenReturn((Object)this.page);
        Assert.assertFalse((boolean)this.layoutAclService.canViewNavigation(SITE_KEY, PAGE_KEY, TEST_USER));
        Mockito.when((Object)this.userAcl.hasPermission(this.page)).thenReturn((Object)true);
        Assert.assertFalse((boolean)this.layoutAclService.canViewNavigation(SITE_KEY, PAGE_KEY, TEST_USER));
        Mockito.when((Object)this.userAcl.hasAccessPermission(this.portalConfig)).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.layoutAclService.canViewNavigation(SITE_KEY, PAGE_KEY, TEST_USER));
    }

    @Test
    public void canViewPage() {
        Assert.assertFalse((boolean)this.layoutAclService.canViewPage(PAGE_KEY, TEST_USER));
        Mockito.when((Object)this.layoutService.getPage(PAGE_KEY)).thenReturn((Object)this.page);
        Assert.assertFalse((boolean)this.layoutAclService.canViewPage(PAGE_KEY, TEST_USER));
        Mockito.when((Object)this.userAcl.hasPermission(this.page)).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.layoutAclService.canViewPage(PAGE_KEY, TEST_USER));
    }

    @Test
    public void canEditPage() {
        Assert.assertFalse((boolean)this.layoutAclService.canEditPage(PAGE_KEY, TEST_USER));
        Mockito.when((Object)this.layoutService.getPage(PAGE_KEY)).thenReturn((Object)this.page);
        Assert.assertFalse((boolean)this.layoutAclService.canEditPage(PAGE_KEY, TEST_USER));
        Mockito.when((Object)this.userAcl.hasEditPermission(this.page)).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.layoutAclService.canEditPage(PAGE_KEY, TEST_USER));
    }

    @Test
    public void isSuperUser() {
        Assert.assertFalse((boolean)this.layoutAclService.isAdministrator(TEST_USER));
        Mockito.when((Object)this.userAcl.isSuperUser()).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.layoutAclService.isAdministrator(TEST_USER));
    }

    @Test
    public void isAdministrator() {
        Assert.assertFalse((boolean)this.layoutAclService.isAdministrator(TEST_USER));
        Mockito.when((Object)this.userAcl.getAdminGroups()).thenReturn((Object)"superGroup");
        Mockito.when((Object)this.userAcl.isUserInGroup(this.userAcl.getAdminGroups())).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.layoutAclService.isAdministrator(TEST_USER));
    }
}

