/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.service.injection;

import io.meeds.common.ContainerTransactional;
import io.meeds.common.ContainerTransactionalAspect;
import io.meeds.layout.model.PortletDescriptor;
import io.meeds.layout.model.PortletInstance;
import io.meeds.layout.model.PortletInstanceCategory;
import io.meeds.layout.model.PortletInstanceCategoryDescriptor;
import io.meeds.layout.model.PortletInstanceCategoryDescriptorList;
import io.meeds.layout.model.PortletInstanceDescriptor;
import io.meeds.layout.model.PortletInstanceDescriptorList;
import io.meeds.layout.service.LayoutAclService;
import io.meeds.layout.service.PortletInstanceService;
import io.meeds.layout.service.PortletService;
import io.meeds.layout.service.injection.LayoutTranslationImportService;
import io.meeds.layout.service.injection.PortletInstanceImportService$AjcClosure1;
import io.meeds.layout.util.JsonUtils;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.attachment.AttachmentService;
import org.exoplatform.social.attachment.model.UploadedAttachmentDetail;
import org.exoplatform.upload.UploadResource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=0x7FFFFFFF)
public class PortletInstanceImportService {
    private static final String PORTLET_INSTANCE_IMPORT = "PORTLET_INSTANCE_IMPORT";
    private static final Scope PORTLET_INSTANCE_IMPORT_SCOPE;
    private static final Scope PORTLET_INSTANCE_CATEGORY_IMPORT_SCOPE;
    private static final Context PORTLET_INSTANCE_CONTEXT;
    private static final String PORTLET_INSTANCE_VERSION = "version";
    private static final Log LOG;
    private static final Random RANDOM;
    @Autowired
    private LayoutAclService layoutAclService;
    @Autowired
    private LayoutTranslationImportService layoutTranslationService;
    @Autowired
    private AttachmentService attachmentService;
    @Autowired
    private PortletInstanceService portletInstanceService;
    @Autowired
    private PortletService portletService;
    @Autowired
    private SettingService settingService;
    @Autowired
    private ConfigurationManager configurationManager;
    @Value(value="${meeds.portlets.import.override:false}")
    private boolean forceReimport;
    @Value(value="${meeds.portlets.import.version:2}")
    private long portletInstanceImportVersion;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @PostConstruct
    public void init() {
        CompletableFuture.runAsync(this::importPortletInstances);
    }

    @ContainerTransactional
    public void importPortletInstances() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        PortletInstanceImportService$AjcClosure1 portletInstanceImportService$AjcClosure1 = new PortletInstanceImportService$AjcClosure1(objectArray);
        ContainerTransactionalAspect.aspectOf().around(portletInstanceImportService$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    protected List<PortletInstanceDescriptor> parseDescriptors(URL url) {
        List<PortletInstanceDescriptor> list;
        block8: {
            InputStream inputStream = url.openStream();
            try {
                String content = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                PortletInstanceDescriptorList list2 = JsonUtils.fromJsonString(content, PortletInstanceDescriptorList.class);
                list = list2.getDescriptors();
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.warn("An unkown error happened while parsing portlet instances from url {}", new Object[]{url, e});
                    return Collections.emptyList();
                }
            }
            inputStream.close();
        }
        return list;
    }

    protected List<PortletInstanceCategoryDescriptor> parseCategoryDescriptors(URL url) {
        List<PortletInstanceCategoryDescriptor> list;
        block8: {
            InputStream inputStream = url.openStream();
            try {
                String content = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                PortletInstanceCategoryDescriptorList list2 = JsonUtils.fromJsonString(content, PortletInstanceCategoryDescriptorList.class);
                list = list2.getDescriptors();
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.warn("An unkown error happened while parsing portlet instances from url {}", new Object[]{url, e});
                    return Collections.emptyList();
                }
            }
            inputStream.close();
        }
        return list;
    }

    protected void importCategoryDescriptor(PortletInstanceCategoryDescriptor descriptor) {
        String descriptorId = descriptor.getNameId();
        long existingId = this.getCategorySettingValue(descriptorId);
        if (this.forceReimport || existingId == 0L) {
            this.importPortletInstanceCategory(descriptor, existingId);
        } else {
            LOG.debug("Ignore re-importing Portlet instance category {}", new Object[]{descriptorId});
        }
    }

    protected void importDescriptor(PortletInstanceDescriptor descriptor) {
        String descriptorId = descriptor.getNameId();
        long existingId = this.getSettingValue(descriptorId);
        if (this.forceReimport || existingId == 0L) {
            this.importPortletInstance(descriptor, existingId);
        } else {
            LOG.debug("Ignore re-importing Portlet instance {}", new Object[]{descriptorId});
        }
    }

    protected void importPortletInstanceCategory(PortletInstanceCategoryDescriptor d, long oldId) {
        String descriptorId = d.getNameId();
        LOG.debug("Importing Portlet category instance {}", new Object[]{descriptorId});
        try {
            PortletInstanceCategory category = this.savePortletInstanceCategory(d, oldId);
            if (category != null && (this.forceReimport || oldId == 0L || category.getId() != oldId)) {
                LOG.debug("Importing Portlet instance category {} title translations", new Object[]{descriptorId});
                this.saveCategoryNames(d, category);
                this.setCategorySettingValue(descriptorId, category.getId());
            }
            LOG.debug("Importing Portlet instance category {} finished successfully", new Object[]{descriptorId});
        }
        catch (Exception e) {
            LOG.warn("An error occurred while importing portlet instance category {}", new Object[]{descriptorId, e});
        }
    }

    protected void importPortletInstance(PortletInstanceDescriptor d, long oldId) {
        String descriptorId = d.getNameId();
        LOG.debug("Importing Portlet instance {}", new Object[]{descriptorId});
        try {
            PortletInstance portletInstance = this.savePortletInstance(d, oldId);
            if (portletInstance == null) {
                return;
            }
            if (this.forceReimport || oldId == 0L || portletInstance.getId() != oldId) {
                LOG.debug("Importing Portlet instance {} title translations", new Object[]{descriptorId});
                this.saveNames(d, portletInstance);
                LOG.debug("Importing Portlet instance {} description translations", new Object[]{descriptorId});
                this.saveDescriptions(d, portletInstance);
                if (StringUtils.isNotBlank((CharSequence)d.getIllustrationPath())) {
                    LOG.debug("Importing Portlet instance {} illustration", new Object[]{descriptorId});
                    this.saveIllustration(portletInstance.getId(), d.getIllustrationPath());
                }
                this.setSettingValue(descriptorId, portletInstance.getId());
            }
            LOG.debug("Importing Portlet instance {} finished successfully", new Object[]{descriptorId});
        }
        catch (Exception e) {
            LOG.warn("An error occurred while importing portlet instance {}", new Object[]{descriptorId, e});
        }
    }

    protected void saveNames(PortletInstanceDescriptor d, PortletInstance portletInstance) {
        this.layoutTranslationService.saveTranslationLabels("portletInstance", portletInstance.getId(), "title", d.getNames());
    }

    protected void saveDescriptions(PortletInstanceDescriptor d, PortletInstance portletInstance) {
        this.layoutTranslationService.saveTranslationLabels("portletInstance", portletInstance.getId(), "description", d.getDescriptions());
    }

    protected void saveCategoryNames(PortletInstanceCategoryDescriptor d, PortletInstanceCategory category) {
        this.layoutTranslationService.saveTranslationLabels("portletInstanceCategory", category.getId(), "title", d.getNames());
    }

    protected PortletInstanceCategory savePortletInstanceCategory(PortletInstanceCategoryDescriptor d, long oldId) {
        boolean isNew;
        PortletInstanceCategory category = null;
        if (oldId > 0L) {
            category = this.portletInstanceService.getPortletInstanceCategory(oldId);
        }
        boolean bl = isNew = category == null;
        if (isNew) {
            category = new PortletInstanceCategory();
        }
        category.setIcon(d.getIcon());
        category.setPermissions(d.getPermissions());
        category.setSystem(d.isSystem());
        if (isNew) {
            return this.portletInstanceService.createPortletInstanceCategory(category);
        }
        return this.portletInstanceService.updatePortletInstanceCategory(category);
    }

    protected PortletInstance savePortletInstance(PortletInstanceDescriptor d, long oldId) {
        boolean isNew;
        PortletDescriptor portlet = this.portletService.getPortlet(d.getPortletName());
        if (portlet == null) {
            LOG.debug("Saving Portlet instance descriptor {} aborted since portlet {} doesn't exist.", new Object[]{d.getNameId(), d.getPortletName()});
            return null;
        }
        PortletInstance portletInstance = null;
        if (oldId > 0L) {
            portletInstance = this.portletInstanceService.getPortletInstance(oldId);
        }
        boolean bl = isNew = portletInstance == null;
        if (isNew) {
            portletInstance = new PortletInstance();
        }
        portletInstance.setContentId(portlet.getContentId());
        portletInstance.setCategoryId(this.getCategorySettingValue(d.getCategoryNameId()));
        portletInstance.setPermissions(d.getPermissions());
        portletInstance.setPreferences(d.getPreferences());
        portletInstance.setSystem(d.isSystem());
        if (isNew) {
            return this.portletInstanceService.createPortletInstance(portletInstance);
        }
        return this.portletInstanceService.updatePortletInstance(portletInstance);
    }

    protected void saveIllustration(long portletInstanceId, String imagePath) {
        File tempFile = null;
        try {
            tempFile = this.getIllustrationFile(imagePath);
            String uploadId = "PortletInstanceIllustration" + RANDOM.nextLong();
            UploadResource uploadResource = new UploadResource(uploadId);
            uploadResource.setFileName(tempFile.getName());
            uploadResource.setMimeType("image/png");
            uploadResource.setStatus(1);
            uploadResource.setStoreLocation(tempFile.getPath());
            UploadedAttachmentDetail uploadedAttachmentDetail = new UploadedAttachmentDetail(uploadResource);
            this.attachmentService.deleteAttachments("portletInstance", String.valueOf(portletInstanceId));
            this.attachmentService.saveAttachment(uploadedAttachmentDetail, "portletInstance", String.valueOf(portletInstanceId), null, this.layoutAclService.getSuperUserIdentityId());
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Error while saving Image '%s' as attachment for portlet instance '%s'", imagePath, portletInstanceId), e);
        }
        finally {
            if (tempFile != null) {
                try {
                    Files.delete(tempFile.toPath());
                }
                catch (IOException e) {
                    tempFile.deleteOnExit();
                }
            }
        }
    }

    protected void setCategorySettingValue(String name, long value) {
        this.settingService.set(PORTLET_INSTANCE_CONTEXT, PORTLET_INSTANCE_CATEGORY_IMPORT_SCOPE, name, SettingValue.create((String)String.valueOf(value)));
    }

    protected long getCategorySettingValue(String name) {
        try {
            SettingValue settingValue = this.settingService.get(PORTLET_INSTANCE_CONTEXT, PORTLET_INSTANCE_CATEGORY_IMPORT_SCOPE, name);
            return settingValue == null || settingValue.getValue() == null ? 0L : Long.parseLong(settingValue.getValue().toString());
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    protected void setSettingValue(String name, long value) {
        this.settingService.set(PORTLET_INSTANCE_CONTEXT, PORTLET_INSTANCE_IMPORT_SCOPE, name, SettingValue.create((String)String.valueOf(value)));
    }

    protected long getSettingValue(String name) {
        try {
            SettingValue settingValue = this.settingService.get(PORTLET_INSTANCE_CONTEXT, PORTLET_INSTANCE_IMPORT_SCOPE, name);
            return settingValue == null || settingValue.getValue() == null ? 0L : Long.parseLong(settingValue.getValue().toString());
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    private File getIllustrationFile(String imagePath) throws Exception {
        try (InputStream inputStream = this.configurationManager.getInputStream(imagePath);){
            File tempFile = File.createTempFile("temp", ".png");
            FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)tempFile);
            File file = tempFile;
            return file;
        }
    }

    private ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    static {
        PortletInstanceImportService.ajc$preClinit();
        PORTLET_INSTANCE_IMPORT_SCOPE = Scope.APPLICATION.id(PORTLET_INSTANCE_IMPORT);
        PORTLET_INSTANCE_CATEGORY_IMPORT_SCOPE = Scope.APPLICATION.id("PORTLET_INSTANCE_CATEGORY_IMPORT");
        PORTLET_INSTANCE_CONTEXT = Context.GLOBAL.id("PORTLET_INSTANCE");
        LOG = ExoLogger.getLogger(PortletInstanceImportService.class);
        RANDOM = new Random();
    }

    static final /* synthetic */ void importPortletInstances_aroundBody0(PortletInstanceImportService ajc$this, JoinPoint joinPoint) {
        LOG.info((Object)"Importing Portlet instances");
        if (!ajc$this.forceReimport && ajc$this.getSettingValue(PORTLET_INSTANCE_VERSION) != ajc$this.portletInstanceImportVersion) {
            ajc$this.forceReimport = true;
        }
        ConversationState.setCurrent((ConversationState)ajc$this.layoutAclService.getSuperUserConversationState());
        try {
            Collections.list(ajc$this.getClassLoader().getResources("portlet-instance-categories.json")).stream().map(ajc$this::parseCategoryDescriptors).flatMap(Collection::stream).forEach(ajc$this::importCategoryDescriptor);
            Collections.list(ajc$this.getClass().getClassLoader().getResources("portlet-instances.json")).stream().map(ajc$this::parseDescriptors).flatMap(Collection::stream).forEach(ajc$this::importDescriptor);
            LOG.info((Object)"Importing Portlet instances finished successfully.");
            LOG.info((Object)"Processing Post Portlet instances import");
            ajc$this.layoutTranslationService.postImport("portletInstanceCategory");
            ajc$this.layoutTranslationService.postImport("portletInstance");
            LOG.info((Object)"Processing Post Portlet instances import finished");
            ajc$this.setSettingValue(PORTLET_INSTANCE_VERSION, ajc$this.portletInstanceImportVersion);
        }
        catch (Exception e) {
            LOG.warn((Object)"An error occurred while importing portlet instances", (Throwable)e);
        }
        finally {
            ConversationState.setCurrent(null);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("PortletInstanceImportService.java", PortletInstanceImportService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "importPortletInstances", "io.meeds.layout.service.injection.PortletInstanceImportService", "", "", "", "void"), 127);
    }
}

