/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.storage;

import io.meeds.layout.model.PortletInstance;
import io.meeds.layout.model.PortletInstancePreference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.ApplicationState;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.TransientApplicationState;
import org.exoplatform.portal.config.serialize.PortletApplication;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.page.PageState;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.pom.spi.portlet.Portlet;
import org.exoplatform.portal.pom.spi.portlet.PortletBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PortletInstanceLayoutStorage {
    private static final Context CONTEXT = Context.GLOBAL.id("PORTLET_INSTANCE");
    private static final Scope PORTLET_INSTANCE_SCOPE = Scope.APPLICATION.id("PORTLET_INSTANCE_APPLICATION");
    private static final Scope PAGE_APPLICATION_SCOPE = Scope.APPLICATION.id("APPLICATION_PORTLET_INSTANCE");
    private static final PageKey PORTLET_EDITOR_SYSTEM_PAGE_KEY = new PageKey(SiteKey.portal((String)"global"), "_portletEditor");
    @Autowired
    private SettingService settingService;
    @Autowired
    private LayoutService layoutService;

    public Application<Portlet> getPortletInstanceApplication(PortletInstance portletInstance, long applicationStorageId) {
        if (portletInstance != null) {
            return this.getOrCreatePortletInstanceApplication(portletInstance);
        }
        if (applicationStorageId > 0L) {
            return this.getApplication(applicationStorageId);
        }
        return null;
    }

    public Application<Portlet> getOrCreatePortletInstanceApplication(PortletInstance portletInstance) {
        long applicationId = this.getPortletInstanceApplicationId(portletInstance.getId());
        if (applicationId == 0L) {
            return this.createPortletInstanceApplication(portletInstance);
        }
        try {
            return this.getApplication(applicationId);
        }
        catch (Exception e) {
            return this.createPortletInstanceApplication(portletInstance);
        }
    }

    public Application<Portlet> getApplication(long applicationId) {
        return this.layoutService.getApplicationModel(String.valueOf(applicationId));
    }

    public Portlet getApplicationPreferences(long applicationId) {
        Application<Portlet> application = this.getApplication(applicationId);
        return (Portlet)this.layoutService.load(application.getState(), application.getType());
    }

    public String getApplicationPortletName(Application<Portlet> application) {
        String contentId = this.layoutService.getId(application.getState());
        return StringUtils.isBlank((CharSequence)contentId) ? null : contentId.split("/")[1];
    }

    public long getApplicationPortletInstanceId(long applicationId) {
        return this.getSettingValue(PAGE_APPLICATION_SCOPE, applicationId);
    }

    public long getPortletInstanceApplicationId(long portletInstanceId) {
        return this.getSettingValue(PORTLET_INSTANCE_SCOPE, portletInstanceId);
    }

    private synchronized Application<Portlet> createPortletInstanceApplication(PortletInstance portletInstance) {
        int index;
        String[] stringArray;
        TransientApplicationState state = new TransientApplicationState(portletInstance.getContentId());
        List<String> permissions = portletInstance.getPermissions();
        List<PortletInstancePreference> preferences = portletInstance.getPreferences();
        if (CollectionUtils.isNotEmpty(preferences)) {
            PortletBuilder builder = new PortletBuilder();
            preferences.stream().forEach(pref -> builder.add(pref.getName(), pref.getValue()));
            state.setContentState((Object)builder.build());
        }
        PortletApplication portletApplication = new PortletApplication();
        portletApplication.setState((ApplicationState)state);
        if (CollectionUtils.isEmpty(permissions)) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "Everyone";
        } else {
            stringArray = permissions.toArray(new String[0]);
        }
        portletApplication.setAccessPermissions(stringArray);
        Page page = this.getPortletInstanceSystemPage();
        Container container = (Container)page.getChildren().get(0);
        ArrayList<PortletApplication> children = container.getChildren();
        if (CollectionUtils.isEmpty((Collection)children)) {
            index = 0;
            children = new ArrayList<PortletApplication>();
        } else {
            index = children.size();
            children = new ArrayList(children);
        }
        children.add(portletApplication);
        container.setChildren(children);
        page.setChildren(new ArrayList<Container>(Collections.singletonList(container)));
        this.layoutService.save(page);
        container = this.getPortletInstanceSystemContainer();
        Application application = (Application)container.getChildren().get(index);
        this.savePortletInstanceApplicationId(Long.parseLong(application.getStorageId()), portletInstance.getId());
        return application;
    }

    private long getSettingValue(Scope scope, long id) {
        SettingValue settingValue = this.settingService.get(CONTEXT, scope, String.valueOf(id));
        if (settingValue != null && settingValue.getValue() != null && StringUtils.isNotBlank((CharSequence)settingValue.getValue().toString())) {
            return Long.parseLong(settingValue.getValue().toString());
        }
        return 0L;
    }

    private void savePortletInstanceApplicationId(long applicationStorageId, long portletInstanceId) {
        this.settingService.set(CONTEXT, PORTLET_INSTANCE_SCOPE, String.valueOf(portletInstanceId), SettingValue.create((Long)applicationStorageId));
        this.settingService.set(CONTEXT, PAGE_APPLICATION_SCOPE, String.valueOf(applicationStorageId), SettingValue.create((Long)portletInstanceId));
    }

    private Container getPortletInstanceSystemContainer() {
        return (Container)this.getPortletInstanceSystemPage().getChildren().get(0);
    }

    private Page getPortletInstanceSystemPage() {
        Page page = this.layoutService.getPage(PORTLET_EDITOR_SYSTEM_PAGE_KEY);
        if (page == null) {
            page = new Page();
            page.setTitle("Portlet Editor Working Page");
            page.setEditPermission("manager:/platform/administrators");
            page.setPageId(PORTLET_EDITOR_SYSTEM_PAGE_KEY.format());
            Container container = new Container();
            container.setTemplate("nop");
            page.setChildren(new ArrayList<Container>(Collections.singletonList(container)));
            PageState pageState = new PageState(page.getTitle(), page.getDescription(), false, null, Arrays.asList("Everyone"), page.getEditPermission());
            this.layoutService.save(new PageContext(PORTLET_EDITOR_SYSTEM_PAGE_KEY, pageState), page);
            page = this.layoutService.getPage(PORTLET_EDITOR_SYSTEM_PAGE_KEY);
        }
        return page;
    }
}

