/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.service;

import io.meeds.layout.service.ContainerLayoutService;
import io.meeds.layout.service.PortletInstanceService;
import java.io.ByteArrayInputStream;
import java.util.Collections;
import org.exoplatform.commons.file.model.FileInfo;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.ApplicationBackgroundStyle;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelStyle;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.social.attachment.AttachmentService;
import org.exoplatform.social.attachment.model.ObjectAttachmentDetail;
import org.exoplatform.social.attachment.model.ObjectAttachmentList;
import org.exoplatform.social.attachment.model.UploadedAttachmentDetail;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.upload.UploadService;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={ContainerLayoutService.class})
@ExtendWith(value={MockitoExtension.class})
class ContainerLayoutServiceTest {
    private static final String MIME_TYPE = "image/png";
    private static final String FILE_NAME = "file.png";
    private static final long FILE_ID = 98L;
    private static final long CONTAINER_ID = 35L;
    private static final long PAGE_ID = 58L;
    @MockBean
    private AttachmentService attachmentService;
    @MockBean
    private UploadService uploadService;
    @MockBean
    private FileService fileService;
    @MockBean
    private UserACL userAcl;
    @MockBean
    private IdentityManager identityManager;
    @MockBean
    private LayoutService layoutService;
    @MockBean
    private PortletInstanceService portletInstanceService;
    @Mock
    private FileItem fileItem;
    @Mock
    private FileInfo fileInfo;
    @Mock
    private Container container;
    @Mock
    private Page page;
    @Mock
    private ModelStyle modelStyle;
    @Mock
    private ApplicationBackgroundStyle appBackgroundStyle;
    @Mock
    private ObjectAttachmentList attachmentList;
    @Mock
    private Identity identity;
    @Autowired
    private ContainerLayoutService containerLayoutSrvice;

    ContainerLayoutServiceTest() {
    }

    @Test
    void testImpersonateContainerWithNullPage() throws Exception {
        this.containerLayoutSrvice.impersonateContainer(this.container, null);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.container});
    }

    @Test
    void testImpersonateContainerWithNullContainer() throws Exception {
        this.containerLayoutSrvice.impersonateContainer(null, this.page);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.page});
    }

    @Test
    void testImpersonateContainerWithCssStyleNoAttachment() throws Exception {
        Mockito.when((Object)this.container.getCssStyle()).thenReturn((Object)this.modelStyle);
        Mockito.when((Object)this.modelStyle.getBackgroundImage()).thenReturn((Object)"fake/url");
        this.containerLayoutSrvice.impersonateContainer(this.container, this.page);
        ((ModelStyle)Mockito.verify((Object)this.modelStyle)).setBackgroundImage(null);
    }

    @Test
    void testImpersonateContainerWithAppBackgroundStyleNoAttachment() throws Exception {
        Mockito.when((Object)this.container.getAppBackgroundStyle()).thenReturn((Object)this.appBackgroundStyle);
        Mockito.when((Object)this.appBackgroundStyle.getBackgroundImage()).thenReturn((Object)"fake/url");
        this.containerLayoutSrvice.impersonateContainer(this.container, this.page);
        ((ApplicationBackgroundStyle)Mockito.verify((Object)this.appBackgroundStyle)).setBackgroundImage(null);
    }

    @Test
    void testImpersonateContainerWithCssStyleValidAttachment() throws Exception {
        String backgroundImageUrl = String.format("/%s/%s_%s/%s", "containerBackground", 58L, 35L, 98L);
        Mockito.when((Object)this.container.getCssStyle()).thenReturn((Object)this.modelStyle);
        Mockito.when((Object)this.page.getStorageId()).thenReturn((Object)String.format("page_%s", 58L));
        Mockito.when((Object)this.container.getStorageId()).thenReturn((Object)String.valueOf(35L));
        Mockito.when((Object)this.modelStyle.getBackgroundImage()).thenReturn((Object)backgroundImageUrl);
        Mockito.when((Object)this.fileService.getFile(98L)).thenReturn((Object)this.fileItem);
        Mockito.when((Object)this.fileItem.getFileInfo()).thenReturn((Object)this.fileInfo);
        Mockito.when((Object)this.fileInfo.getName()).thenReturn((Object)FILE_NAME);
        Mockito.when((Object)this.fileInfo.getMimetype()).thenReturn((Object)MIME_TYPE);
        Mockito.when((Object)this.fileInfo.getSize()).thenReturn((Object)3L);
        Mockito.when((Object)this.fileItem.getAsStream()).thenReturn((Object)new ByteArrayInputStream(new byte[]{1, 2, 3}));
        Mockito.when((Object)this.userAcl.getSuperUser()).thenReturn((Object)"root");
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(this.userAcl.getSuperUser())).thenReturn((Object)this.identity);
        Mockito.lenient().when((Object)this.identity.getId()).thenReturn((Object)"29");
        long newFileId = 1222L;
        ((AttachmentService)Mockito.doAnswer(invocation -> {
            Mockito.when((Object)this.attachmentList.getAttachments()).thenReturn(Collections.singletonList(new ObjectAttachmentDetail(String.valueOf(newFileId), FILE_NAME, MIME_TYPE, 3L, 0L, null)));
            Mockito.when((Object)this.attachmentService.getAttachments("containerBackground", (String)invocation.getArgument(2))).thenReturn((Object)this.attachmentList);
            return null;
        }).when((Object)this.attachmentService)).saveAttachment((UploadedAttachmentDetail)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"containerBackground"), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), ArgumentMatchers.anyLong());
        this.containerLayoutSrvice.impersonateContainer(this.container, this.page);
        ((ModelStyle)Mockito.verify((Object)this.modelStyle)).setBackgroundImage(String.format("/portal/rest/v1/social/attachments/%s/%s_%s/%s", "containerBackground", 58L, 35L, newFileId));
    }

    @Test
    void testImpersonateContainerWithAppBackgroundStyleValidAttachment() throws Exception {
        String backgroundImageUrl = String.format("/%s/%s_%s/%s", "containerBackground", 58L, 35L, 98L);
        Mockito.when((Object)this.container.getAppBackgroundStyle()).thenReturn((Object)this.appBackgroundStyle);
        Mockito.when((Object)this.page.getStorageId()).thenReturn((Object)String.format("page_%s", 58L));
        Mockito.when((Object)this.container.getStorageId()).thenReturn((Object)String.valueOf(35L));
        Mockito.when((Object)this.appBackgroundStyle.getBackgroundImage()).thenReturn((Object)backgroundImageUrl);
        Mockito.when((Object)this.fileService.getFile(98L)).thenReturn((Object)this.fileItem);
        Mockito.when((Object)this.fileItem.getFileInfo()).thenReturn((Object)this.fileInfo);
        Mockito.when((Object)this.fileInfo.getName()).thenReturn((Object)FILE_NAME);
        Mockito.when((Object)this.fileInfo.getMimetype()).thenReturn((Object)MIME_TYPE);
        Mockito.when((Object)this.fileInfo.getSize()).thenReturn((Object)3L);
        Mockito.when((Object)this.fileItem.getAsStream()).thenReturn((Object)new ByteArrayInputStream(new byte[]{1, 2, 3}));
        Mockito.when((Object)this.userAcl.getSuperUser()).thenReturn((Object)"root");
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(this.userAcl.getSuperUser())).thenReturn((Object)this.identity);
        Mockito.lenient().when((Object)this.identity.getId()).thenReturn((Object)"29");
        long newFileId = 1222L;
        ((AttachmentService)Mockito.doAnswer(invocation -> {
            Mockito.when((Object)this.attachmentList.getAttachments()).thenReturn(Collections.singletonList(new ObjectAttachmentDetail(String.valueOf(newFileId), FILE_NAME, MIME_TYPE, 3L, 0L, null)));
            Mockito.when((Object)this.attachmentService.getAttachments("containerBackground", (String)invocation.getArgument(2))).thenReturn((Object)this.attachmentList);
            return null;
        }).when((Object)this.attachmentService)).saveAttachment((UploadedAttachmentDetail)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"containerBackground"), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), ArgumentMatchers.anyLong());
        this.containerLayoutSrvice.impersonateContainer(this.container, this.page);
        ((ApplicationBackgroundStyle)Mockito.verify((Object)this.appBackgroundStyle)).setBackgroundImage(String.format("/portal/rest/v1/social/attachments/%s/%s_%s/%s", "containerBackground", 58L, 35L, newFileId));
    }
}

