/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.storage;

import io.meeds.layout.dao.PageTemplateDAO;
import io.meeds.layout.entity.PageTemplateEntity;
import io.meeds.layout.model.PageTemplate;
import io.meeds.layout.storage.PageTemplateStorage;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={PageTemplateStorage.class})
@ExtendWith(value={MockitoExtension.class})
public class PageTemplateStorageTest {
    private static final String LAYOUT_CONTENT = "...layout...";
    @MockBean
    private PageTemplateDAO pageTemplateDAO;
    @Mock
    private PageTemplateEntity pageTemplateEntity;
    @Mock
    private PageTemplate pageTemplate;
    @Autowired
    private PageTemplateStorage pageTemplateStorage;
    String username = "test";

    @Test
    public void getPageTemplates() {
        Mockito.when((Object)this.pageTemplateDAO.findAll()).thenReturn(Collections.singletonList(this.pageTemplateEntity));
        Mockito.when((Object)this.pageTemplateEntity.getId()).thenReturn((Object)2L);
        Mockito.when((Object)this.pageTemplateEntity.getContent()).thenReturn((Object)LAYOUT_CONTENT);
        List pageTemplates = this.pageTemplateStorage.getPageTemplates();
        Assert.assertNotNull((Object)pageTemplates);
        Assertions.assertEquals((int)1, (int)pageTemplates.size());
        Assertions.assertEquals((Long)this.pageTemplateEntity.getId(), (long)((PageTemplate)pageTemplates.get(0)).getId());
        Assertions.assertEquals((Object)this.pageTemplateEntity.getContent(), (Object)((PageTemplate)pageTemplates.get(0)).getContent());
    }

    @Test
    public void getPageTemplate() {
        Mockito.when((Object)this.pageTemplateDAO.findById((Object)2L)).thenReturn(Optional.of(this.pageTemplateEntity));
        Mockito.when((Object)this.pageTemplateEntity.getId()).thenReturn((Object)2L);
        Mockito.when((Object)this.pageTemplateEntity.getContent()).thenReturn((Object)LAYOUT_CONTENT);
        PageTemplate retrievedPageTemplate = this.pageTemplateStorage.getPageTemplate(2L);
        Assertions.assertEquals((Long)this.pageTemplateEntity.getId(), (long)retrievedPageTemplate.getId());
        Assertions.assertEquals((Object)this.pageTemplateEntity.getContent(), (Object)retrievedPageTemplate.getContent());
    }

    @Test
    public void createPageTemplate() {
        Mockito.when((Object)this.pageTemplate.getContent()).thenReturn((Object)LAYOUT_CONTENT);
        Mockito.when((Object)((PageTemplateEntity)this.pageTemplateDAO.save((Object)((PageTemplateEntity)ArgumentMatchers.any(PageTemplateEntity.class))))).thenAnswer(invocation -> {
            PageTemplateEntity entity = (PageTemplateEntity)invocation.getArgument(0);
            entity.setId(Long.valueOf(2L));
            return entity;
        });
        PageTemplate createdPageTemplate = this.pageTemplateStorage.createPageTemplate(this.pageTemplate);
        Assert.assertNotNull((Object)createdPageTemplate);
        Assertions.assertEquals((long)2L, (long)createdPageTemplate.getId());
        Assertions.assertEquals((Object)this.pageTemplate.getContent(), (Object)createdPageTemplate.getContent());
    }

    @Test
    public void updatePageTemplate() throws ObjectNotFoundException {
        Mockito.when((Object)this.pageTemplate.getContent()).thenReturn((Object)LAYOUT_CONTENT);
        Mockito.when((Object)((PageTemplateEntity)this.pageTemplateDAO.save((Object)((PageTemplateEntity)ArgumentMatchers.any(PageTemplateEntity.class))))).thenAnswer(invocation -> invocation.getArgument(0));
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.pageTemplateStorage.updatePageTemplate(this.pageTemplate));
        Mockito.when((Object)this.pageTemplate.getId()).thenReturn((Object)2L);
        Mockito.when((Object)this.pageTemplate.getContent()).thenReturn((Object)LAYOUT_CONTENT);
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.pageTemplateStorage.updatePageTemplate(this.pageTemplate));
        Mockito.when((Object)this.pageTemplateDAO.existsById((Object)this.pageTemplate.getId())).thenReturn((Object)true);
        PageTemplate updatedPageTemplate = this.pageTemplateStorage.updatePageTemplate(this.pageTemplate);
        Assert.assertNotNull((Object)updatedPageTemplate);
        Assertions.assertEquals((long)this.pageTemplate.getId(), (long)updatedPageTemplate.getId());
        Assertions.assertEquals((Object)this.pageTemplate.getContent(), (Object)updatedPageTemplate.getContent());
    }

    @Test
    public void deletePageTemplate() throws ObjectNotFoundException {
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.pageTemplateStorage.deletePageTemplate(2L));
        Mockito.when((Object)this.pageTemplateDAO.existsById((Object)2L)).thenReturn((Object)true);
        this.pageTemplateStorage.deletePageTemplate(2L);
        ((PageTemplateDAO)Mockito.verify((Object)this.pageTemplateDAO, (VerificationMode)Mockito.times((int)1))).deleteById((Object)2L);
    }
}

