/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.plugin;

import io.meeds.layout.plugin.PageTemplateTranslationPlugin;
import io.meeds.layout.service.LayoutAclService;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={PageTemplateTranslationPlugin.class})
@ExtendWith(value={MockitoExtension.class})
public class PageTemplateTranslationPluginTest {
    @MockBean
    private LayoutAclService layoutAclService;
    @Autowired
    private PageTemplateTranslationPlugin translationPlugin;
    String username = "test";

    @Test
    public void getObjectType() {
        Assertions.assertEquals((Object)"pageTemplate", (Object)this.translationPlugin.getObjectType());
        Assertions.assertEquals((Object)"pageTemplate", (Object)this.translationPlugin.getObjectType());
    }

    @Test
    public void hasEditPermission() {
        Assert.assertFalse((boolean)this.translationPlugin.hasEditPermission(0L, null));
        Assert.assertFalse((boolean)this.translationPlugin.hasEditPermission(0L, this.username));
        Mockito.when((Object)this.layoutAclService.isAdministrator(this.username)).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.translationPlugin.hasEditPermission(0L, this.username));
    }

    @Test
    public void hasAccessPermission() {
        Assert.assertTrue((boolean)this.translationPlugin.hasAccessPermission(0L, null));
    }

    @Test
    public void getAudienceId() {
        Assertions.assertEquals((long)0L, (long)this.translationPlugin.getAudienceId(0L));
    }

    @Test
    public void getSpaceId() {
        Assertions.assertEquals((long)0L, (long)this.translationPlugin.getSpaceId(0L));
    }
}

