/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.rest;

import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.meeds.layout.model.PortletInstance;
import io.meeds.layout.rest.PortletInstanceRest;
import io.meeds.layout.service.PortletInstanceService;
import io.meeds.spring.web.security.PortalAuthenticationManager;
import io.meeds.spring.web.security.WebSecurityConfiguration;
import jakarta.servlet.Filter;
import java.util.Locale;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureWebMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.http.MediaType;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.test.web.servlet.request.SecurityMockMvcRequestPostProcessors;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

@SpringBootTest(classes={PortletInstanceRest.class, PortalAuthenticationManager.class})
@ContextConfiguration(classes={WebSecurityConfiguration.class})
@AutoConfigureWebMvc
@AutoConfigureMockMvc(addFilters=false)
@ExtendWith(value={MockitoExtension.class})
public class PortletInstanceRestTest {
    private static final String REST_PATH = "/portlet/instances";
    private static final String SIMPLE_USER = "simple";
    private static final String TEST_PASSWORD = "testPassword";
    static final ObjectMapper OBJECT_MAPPER = ((JsonMapper.Builder)JsonMapper.builder().configure(JsonReadFeature.ALLOW_MISSING_VALUES, true).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false)).build();
    @MockBean
    private PortletInstanceService portletInstanceService;
    @Autowired
    private SecurityFilterChain filterChain;
    @Autowired
    private WebApplicationContext context;
    private MockMvc mockMvc;

    @BeforeEach
    void setup() {
        this.mockMvc = ((DefaultMockMvcBuilder)MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.context).addFilters(this.filterChain.getFilters().toArray(new Filter[0]))).build();
    }

    @Test
    void getPortletInstancesAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)REST_PATH, (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.portletInstanceService});
    }

    @Test
    void getPortletInstancesWithUser() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)REST_PATH, (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        ((PortletInstanceService)Mockito.verify((Object)this.portletInstanceService)).getPortletInstances(ArgumentMatchers.anyLong(), (String)ArgumentMatchers.any(), (Locale)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean());
    }

    @Test
    void getPortletInstanceAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/portlet/instances/1", (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.portletInstanceService});
    }

    @Test
    void getPortletInstanceWithUser() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/portlet/instances/1", (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        ((PortletInstanceService)Mockito.verify((Object)this.portletInstanceService)).getPortletInstance(ArgumentMatchers.eq((long)1L), (String)ArgumentMatchers.any(), (Locale)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)true));
    }

    @Test
    void createPortletInstanceAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)REST_PATH, (Object[])new Object[0]).content(PortletInstanceRestTest.asJsonString(new PortletInstance())).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.portletInstanceService});
    }

    @Test
    void createPortletInstanceWithUser() throws Exception {
        PortletInstance portletInstance = new PortletInstance();
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)REST_PATH, (Object[])new Object[0]).with(this.testSimpleUser()).content(PortletInstanceRestTest.asJsonString(portletInstance)).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        ((PortletInstanceService)Mockito.verify((Object)this.portletInstanceService)).createPortletInstance(portletInstance, SIMPLE_USER);
    }

    @Test
    void createPortletInstanceWithUserForbidden() throws Exception {
        PortletInstance portletInstance = new PortletInstance();
        Mockito.when((Object)this.portletInstanceService.createPortletInstance(portletInstance, SIMPLE_USER)).thenThrow(IllegalAccessException.class);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)REST_PATH, (Object[])new Object[0]).with(this.testSimpleUser()).content(PortletInstanceRestTest.asJsonString(portletInstance)).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void updatePortletInstanceAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/portlet/instances/1", (Object[])new Object[0]).content(PortletInstanceRestTest.asJsonString(new PortletInstance())).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.portletInstanceService});
    }

    @Test
    void updatePortletInstanceWithUser() throws Exception {
        PortletInstance portletInstance = new PortletInstance();
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/portlet/instances/1", (Object[])new Object[0]).with(this.testSimpleUser()).content(PortletInstanceRestTest.asJsonString(portletInstance)).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        portletInstance.setId(1L);
        ((PortletInstanceService)Mockito.verify((Object)this.portletInstanceService)).updatePortletInstance(portletInstance, SIMPLE_USER);
    }

    @Test
    void updatePortletInstanceWithUserForbidden() throws Exception {
        PortletInstance portletInstance = new PortletInstance();
        portletInstance.setId(1L);
        Mockito.when((Object)this.portletInstanceService.updatePortletInstance(portletInstance, SIMPLE_USER)).thenThrow(IllegalAccessException.class);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/portlet/instances/1", (Object[])new Object[0]).with(this.testSimpleUser()).content(PortletInstanceRestTest.asJsonString(portletInstance)).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void updatePortletInstanceWithUserNotFound() throws Exception {
        PortletInstance portletInstance = new PortletInstance();
        portletInstance.setId(1L);
        Mockito.when((Object)this.portletInstanceService.updatePortletInstance(portletInstance, SIMPLE_USER)).thenThrow(ObjectNotFoundException.class);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/portlet/instances/1", (Object[])new Object[0]).with(this.testSimpleUser()).content(PortletInstanceRestTest.asJsonString(portletInstance)).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    void deletePortletInstanceAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/portlet/instances/1", (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.portletInstanceService});
    }

    @Test
    void deletePortletInstanceWithUser() throws Exception {
        PortletInstance portletInstance = new PortletInstance();
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/portlet/instances/1", (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        portletInstance.setId(1L);
        ((PortletInstanceService)Mockito.verify((Object)this.portletInstanceService)).deletePortletInstance(1L, SIMPLE_USER);
    }

    @Test
    void deletePortletInstanceWithUserForbidden() throws Exception {
        PortletInstance portletInstance = new PortletInstance();
        portletInstance.setId(1L);
        ((PortletInstanceService)Mockito.doThrow(IllegalAccessException.class).when((Object)this.portletInstanceService)).deletePortletInstance(1L, SIMPLE_USER);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/portlet/instances/1", (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void deletePortletInstanceWithUserNotFound() throws Exception {
        PortletInstance portletInstance = new PortletInstance();
        portletInstance.setId(1L);
        ((PortletInstanceService)Mockito.doThrow(ObjectNotFoundException.class).when((Object)this.portletInstanceService)).deletePortletInstance(1L, SIMPLE_USER);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/portlet/instances/1", (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    private RequestPostProcessor testSimpleUser() {
        return SecurityMockMvcRequestPostProcessors.user((String)SIMPLE_USER).password(TEST_PASSWORD).authorities(new GrantedAuthority[]{new SimpleGrantedAuthority("users")});
    }

    public static String asJsonString(Object obj) {
        return OBJECT_MAPPER.writeValueAsString(obj);
    }

    static {
        OBJECT_MAPPER.registerModule((Module)new JavaTimeModule());
    }
}

