/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.plugin.container;

import io.meeds.layout.plugin.container.PortletInstanceApplicationAdapter;
import io.meeds.layout.service.PortletInstanceService;
import jakarta.servlet.http.HttpServletRequest;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.ApplicationState;
import org.exoplatform.portal.config.model.ModelStyle;
import org.exoplatform.portal.config.model.Properties;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={PortletInstanceApplicationAdapter.class})
@ExtendWith(value={MockitoExtension.class})
public class PortletInstanceApplicationAdapterTest {
    private static final String USERNAME = "username";
    @MockBean
    private PortletInstanceService portletInstanceService;
    @Mock
    private Application application;
    @Autowired
    private PortletInstanceApplicationAdapter portletInstanceApplicationAdapter;

    @Test
    public void testNullApplication() {
        Assertions.assertNull((Object)this.portletInstanceApplicationAdapter.getCssStyle());
        Assertions.assertNull((Object)this.portletInstanceApplicationAdapter.getWidth());
        Assertions.assertNull((Object)this.portletInstanceApplicationAdapter.getHeight());
        Assertions.assertNotNull((Object)this.portletInstanceApplicationAdapter.getId());
        Assertions.assertNotNull((Object)this.portletInstanceApplicationAdapter.getState());
        Assertions.assertFalse((boolean)this.portletInstanceApplicationAdapter.getShowInfoBar());
        Assertions.assertFalse((boolean)this.portletInstanceApplicationAdapter.getShowApplicationState());
        Assertions.assertFalse((boolean)this.portletInstanceApplicationAdapter.getShowApplicationMode());
        Assertions.assertNull((Object)this.portletInstanceApplicationAdapter.getIcon());
        Assertions.assertNull((Object)this.portletInstanceApplicationAdapter.getDescription());
        Assertions.assertNull((Object)this.portletInstanceApplicationAdapter.getTitle());
        Assertions.assertNull((Object)this.portletInstanceApplicationAdapter.getProperties());
        Assertions.assertNull((Object)this.portletInstanceApplicationAdapter.getTheme());
        Assertions.assertNull((Object)this.portletInstanceApplicationAdapter.getCssClass());
        Assertions.assertNull((Object)this.portletInstanceApplicationAdapter.build());
        Assertions.assertNull((Object)this.portletInstanceApplicationAdapter.getStorageName());
        Assertions.assertNull((Object)this.portletInstanceApplicationAdapter.getApplication());
    }

    @Test
    public void testNoThrowWhenNoApplication() {
        Assertions.assertDoesNotThrow(() -> this.portletInstanceApplicationAdapter.setCssStyle(null));
        Assertions.assertDoesNotThrow(() -> this.portletInstanceApplicationAdapter.setWidth(null));
        Assertions.assertDoesNotThrow(() -> this.portletInstanceApplicationAdapter.setHeight(null));
        Assertions.assertDoesNotThrow(() -> this.portletInstanceApplicationAdapter.setId(null));
        Assertions.assertDoesNotThrow(() -> this.portletInstanceApplicationAdapter.setState(null));
        Assertions.assertDoesNotThrow(() -> this.portletInstanceApplicationAdapter.setShowInfoBar(false));
        Assertions.assertDoesNotThrow(() -> this.portletInstanceApplicationAdapter.setShowApplicationState(false));
        Assertions.assertDoesNotThrow(() -> this.portletInstanceApplicationAdapter.setShowApplicationMode(false));
        Assertions.assertDoesNotThrow(() -> this.portletInstanceApplicationAdapter.setIcon(null));
        Assertions.assertDoesNotThrow(() -> this.portletInstanceApplicationAdapter.setDescription(null));
        Assertions.assertDoesNotThrow(() -> this.portletInstanceApplicationAdapter.setTitle(null));
        Assertions.assertDoesNotThrow(() -> this.portletInstanceApplicationAdapter.setProperties(null));
        Assertions.assertDoesNotThrow(() -> this.portletInstanceApplicationAdapter.setTheme(null));
        Assertions.assertDoesNotThrow(() -> this.portletInstanceApplicationAdapter.setCssClass(null));
        Assertions.assertDoesNotThrow(() -> this.portletInstanceApplicationAdapter.setStorageName(null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testApplicationDelegation() throws IllegalAccessException, ObjectNotFoundException {
        int portletInstanceId = 2;
        Mockito.when((Object)this.portletInstanceService.getPortletInstanceApplication((long)portletInstanceId, 0L, USERNAME)).thenReturn((Object)this.application);
        try (MockedStatic portalRequestContextStaticMock = Mockito.mockStatic(PortalRequestContext.class);){
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            PortalRequestContext portalRequestContext = (PortalRequestContext)Mockito.mock(PortalRequestContext.class);
            portalRequestContextStaticMock.when(PortalRequestContext::getCurrentInstance).thenReturn((Object)portalRequestContext);
            Mockito.when((Object)portalRequestContext.getRequest()).thenReturn((Object)request);
            Mockito.when((Object)request.getParameter("portletInstanceId")).thenReturn((Object)String.valueOf(portletInstanceId));
            Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)USERNAME);
            Application portletApplication = this.portletInstanceApplicationAdapter.getApplication();
            Assertions.assertNotNull((Object)portletApplication);
            int i = 0;
            ModelStyle cssStyle = (ModelStyle)Mockito.mock(ModelStyle.class);
            ApplicationState state = (ApplicationState)Mockito.mock(ApplicationState.class);
            Properties properties = (Properties)Mockito.mock(Properties.class);
            Mockito.when((Object)portletApplication.getCssStyle()).thenReturn((Object)cssStyle);
            Mockito.when((Object)portletApplication.getWidth()).thenReturn((Object)String.valueOf(++i));
            Mockito.when((Object)portletApplication.getHeight()).thenReturn((Object)String.valueOf(++i));
            Mockito.when((Object)portletApplication.getId()).thenReturn((Object)String.valueOf(++i));
            Mockito.when((Object)portletApplication.getState()).thenReturn((Object)state);
            Mockito.when((Object)portletApplication.getShowInfoBar()).thenReturn((Object)true);
            Mockito.when((Object)portletApplication.getShowApplicationState()).thenReturn((Object)true);
            Mockito.when((Object)portletApplication.getShowApplicationMode()).thenReturn((Object)true);
            Mockito.when((Object)portletApplication.getIcon()).thenReturn((Object)String.valueOf(++i));
            Mockito.when((Object)portletApplication.getDescription()).thenReturn((Object)String.valueOf(++i));
            Mockito.when((Object)portletApplication.getTitle()).thenReturn((Object)String.valueOf(++i));
            Mockito.when((Object)portletApplication.getProperties()).thenReturn((Object)properties);
            Mockito.when((Object)portletApplication.getTheme()).thenReturn((Object)String.valueOf(++i));
            Mockito.when((Object)portletApplication.getCssClass()).thenReturn((Object)String.valueOf(++i));
            Mockito.when((Object)portletApplication.getStorageName()).thenReturn((Object)String.valueOf(++i));
            i = 0;
            Assertions.assertEquals((Object)cssStyle, (Object)this.portletInstanceApplicationAdapter.getCssStyle());
            Assertions.assertEquals((Object)String.valueOf(++i), (Object)this.portletInstanceApplicationAdapter.getWidth());
            Assertions.assertEquals((Object)String.valueOf(++i), (Object)this.portletInstanceApplicationAdapter.getHeight());
            Assertions.assertEquals((Object)String.valueOf(++i), (Object)this.portletInstanceApplicationAdapter.getId());
            Assertions.assertEquals((Object)state, (Object)this.portletInstanceApplicationAdapter.getState());
            Assertions.assertTrue((boolean)this.portletInstanceApplicationAdapter.getShowInfoBar());
            Assertions.assertTrue((boolean)this.portletInstanceApplicationAdapter.getShowApplicationState());
            Assertions.assertTrue((boolean)this.portletInstanceApplicationAdapter.getShowApplicationMode());
            Assertions.assertEquals((Object)String.valueOf(++i), (Object)this.portletInstanceApplicationAdapter.getIcon());
            Assertions.assertEquals((Object)String.valueOf(++i), (Object)this.portletInstanceApplicationAdapter.getDescription());
            Assertions.assertEquals((Object)String.valueOf(++i), (Object)this.portletInstanceApplicationAdapter.getTitle());
            Assertions.assertEquals((Object)properties, (Object)this.portletInstanceApplicationAdapter.getProperties());
            Assertions.assertEquals((Object)String.valueOf(++i), (Object)this.portletInstanceApplicationAdapter.getTheme());
            Assertions.assertEquals((Object)String.valueOf(++i), (Object)this.portletInstanceApplicationAdapter.getCssClass());
            Assertions.assertEquals((Object)String.valueOf(++i), (Object)this.portletInstanceApplicationAdapter.getStorageName());
        }
        finally {
            this.portletInstanceApplicationAdapter.cleanApplication();
        }
    }
}

