/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.plugin.upgrade;

import io.meeds.layout.plugin.upgrade.LayoutApplicationReferenceUpgradePlugin;
import io.meeds.layout.service.PortletInstanceService;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.jdbc.entity.PageEntity;
import org.exoplatform.portal.jdbc.entity.WindowEntity;
import org.exoplatform.portal.mop.dao.PageDAO;
import org.exoplatform.portal.mop.dao.WindowDAO;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.json.JSONArray;
import org.json.JSONObject;

public class SpaceBannerHomePageUpgradePlugin
extends LayoutApplicationReferenceUpgradePlugin {
    private static final Log log = ExoLogger.getLogger(SpaceBannerHomePageUpgradePlugin.class);
    private final EntityManagerService entityManagerService;
    private final PageDAO pageDAO;
    private final WindowDAO windowDAO;

    public SpaceBannerHomePageUpgradePlugin(SettingService settingService, InitParams initParams, EntityManagerService entityManagerService, PageDAO pageDAO, WindowDAO windowDAO, CacheService cacheService, PortletInstanceService portletInstanceService) {
        super(cacheService, settingService, portletInstanceService, windowDAO, initParams);
        this.entityManagerService = entityManagerService;
        this.pageDAO = pageDAO;
        this.windowDAO = windowDAO;
    }

    @Override
    public void processUpgrade(String oldVersion, String newVersion) {
        long start = System.currentTimeMillis();
        log.info((Object)"Start:: Update Space Home Page banner content id");
        List<Long> spaceHomePagesId = this.getSpaceHomePages();
        spaceHomePagesId.forEach(pageId -> {
            PageEntity page = (PageEntity)this.pageDAO.find((Serializable)pageId);
            JSONArray jsonArray = new JSONArray(page.getPageBody());
            for (int i = 0; i < jsonArray.length(); ++i) {
                this.checkChildren(jsonArray.getJSONObject(i));
            }
        });
        super.processUpgrade(oldVersion, newVersion);
        log.info("End:: Update Space Home Page banner content id in {} ms", new Object[]{System.currentTimeMillis() - start});
    }

    private void checkChildren(JSONObject element) {
        long id = element.getLong("id");
        String type = element.getString("type");
        if (type.equals("WINDOW")) {
            WindowEntity windowEntity = (WindowEntity)this.windowDAO.find((Serializable)Long.valueOf(id));
            if (windowEntity != null && windowEntity.getContentId().equals("social-portlet/SpaceMenuPortlet")) {
                this.updateWindow(id);
            }
        } else if (element.has("children")) {
            JSONArray children = element.getJSONArray("children");
            for (int i = 0; i < children.length(); ++i) {
                this.checkChildren(children.getJSONObject(i));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Long> getSpaceHomePages() {
        RequestLifeCycle.begin((ComponentRequestLifecycle)this.entityManagerService);
        EntityManager entityManager = this.entityManagerService.getEntityManager();
        ArrayList<Long> results = new ArrayList();
        try {
            String sqlString = "SELECT pnn.PAGE_ID FROM PORTAL_NAVIGATION_NODES pnn WHERE pnn.PARENT_ID in (SELECT pn.NODE_ID FROM PORTAL_NAVIGATIONS pn WHERE pn.SITE_ID in (SELECT ps.ID FROM PORTAL_SITES ps WHERE ps.TYPE=1))";
            Query query = entityManager.createNativeQuery(sqlString, Long.class);
            results = query.getResultList();
        }
        catch (Exception e) {
            log.error((Object)"Error when getting Space Home Pages", (Throwable)e);
        }
        finally {
            RequestLifeCycle.end();
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateWindow(long id) {
        RequestLifeCycle.begin((ComponentRequestLifecycle)this.entityManagerService);
        EntityManager entityManager = this.entityManagerService.getEntityManager();
        if (!entityManager.getTransaction().isActive()) {
            entityManager.getTransaction().begin();
        }
        String sqlString = "UPDATE PORTAL_WINDOWS SET CONTENT_ID='social/SpaceBannerPortlet' WHERE ID=" + id;
        try {
            Query nativeQuery = entityManager.createNativeQuery(sqlString);
            nativeQuery.executeUpdate();
        }
        finally {
            RequestLifeCycle.end();
        }
    }
}

