/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.plugin;

import io.meeds.layout.model.LayoutModel;
import io.meeds.layout.model.SectionTemplate;
import io.meeds.layout.model.SectionTemplateDatabind;
import io.meeds.layout.model.SectionTemplateDetail;
import io.meeds.layout.plugin.SectionTemplateDatabindPlugin;
import io.meeds.layout.service.PortletInstanceService;
import io.meeds.layout.service.SectionTemplateService;
import io.meeds.layout.util.JsonUtils;
import io.meeds.social.databind.model.DatabindReport;
import io.meeds.social.databind.service.DatabindService;
import io.meeds.social.translation.service.TranslationService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.tuple.Pair;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.attachment.AttachmentService;
import org.exoplatform.social.core.manager.IdentityManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={SectionTemplateDatabindPlugin.class})
@ExtendWith(value={MockitoExtension.class})
class SectionTemplateDatabindPluginTest {
    @Mock
    private Identity userIdentity;
    @MockBean
    private SectionTemplateService sectionTemplateService;
    @MockBean
    private DatabindService databindService;
    @MockBean
    private FileService fileService;
    @MockBean
    private TranslationService translationService;
    @MockBean
    private AttachmentService attachmentService;
    @MockBean
    private PortletInstanceService portletInstanceService;
    @MockBean
    private UserACL userAcl;
    @MockBean
    private IdentityManager identityManager;
    @Autowired
    private SectionTemplateDatabindPlugin sectionTemplateDatabindPlugin;

    SectionTemplateDatabindPluginTest() {
    }

    @Test
    void getObjectType() {
        Assertions.assertEquals((Object)"SectionTemplate", (Object)this.sectionTemplateDatabindPlugin.getObjectType());
    }

    @Test
    void canHandleDatabind() {
        Assertions.assertTrue((boolean)this.sectionTemplateDatabindPlugin.canHandleDatabind("SectionTemplate", "1"));
        Assertions.assertFalse((boolean)this.sectionTemplateDatabindPlugin.canHandleDatabind("ObjectInstance", "1"));
    }

    @Test
    void serialize() throws ObjectNotFoundException {
        ZipOutputStream zipOutputStream = (ZipOutputStream)Mockito.mock(ZipOutputStream.class);
        SectionTemplateDetail sectionTemplateDetail = (SectionTemplateDetail)Mockito.mock(SectionTemplateDetail.class);
        Mockito.when((Object)this.sectionTemplateService.getSectionTemplate(ArgumentMatchers.anyLong(), (Locale)Mockito.any(Locale.class))).thenReturn((Object)sectionTemplateDetail);
        Mockito.when((Object)sectionTemplateDetail.getContent()).thenReturn((Object)JsonUtils.toJsonString((Object)new LayoutModel()));
        this.sectionTemplateDatabindPlugin.serialize("1", zipOutputStream, "root");
        ((SectionTemplateService)Mockito.verify((Object)this.sectionTemplateService, (VerificationMode)Mockito.times((int)1))).getSectionTemplate(1L, Locale.getDefault());
    }

    @Test
    void deserialize() throws Exception {
        File zipFile = this.createZipFileWithTwoJsonFiles();
        Mockito.when((Object)this.sectionTemplateService.createSectionTemplate((SectionTemplate)Mockito.any())).thenReturn((Object)new SectionTemplate());
        CompletableFuture futureReport = this.sectionTemplateDatabindPlugin.deserialize(zipFile, null, "admin");
        DatabindReport report = (DatabindReport)((CompletableFuture)futureReport.thenApply(Pair::getLeft)).join();
        Assertions.assertNotNull((Object)report);
        Assertions.assertTrue((boolean)report.isSuccess());
        Assertions.assertEquals((int)2, (int)report.getProcessedItems().size());
        ((SectionTemplateService)Mockito.verify((Object)this.sectionTemplateService, (VerificationMode)Mockito.times((int)2))).createSectionTemplate((SectionTemplate)Mockito.any());
    }

    private File createZipFileWithTwoJsonFiles() throws IOException {
        File tempFile = File.createTempFile("test", ".zip");
        try (FileOutputStream fos = new FileOutputStream(tempFile);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            SectionTemplateDatabind config1 = new SectionTemplateDatabind();
            config1.setContent(JsonUtils.toJsonString((Object)new LayoutModel()));
            config1.setNames(Map.of("en", "Test Page 1"));
            config1.setDescriptions(Map.of("en", "Desc 1"));
            SectionTemplateDatabind config2 = new SectionTemplateDatabind();
            config2.setContent(JsonUtils.toJsonString((Object)new LayoutModel()));
            config2.setNames(Map.of("en", "Test Page 2"));
            config2.setDescriptions(Map.of("en", "Desc 2"));
            this.addJsonToZip(zos, "SectionTemplate_1/config.json", JsonUtils.toJsonString((Object)config1));
            this.addJsonToZip(zos, "SectionTemplate_1/layout.json", JsonUtils.toJsonString((Object)new LayoutModel()));
            this.addJsonToZip(zos, "SectionTemplate_2/config.json", JsonUtils.toJsonString((Object)config2));
            this.addJsonToZip(zos, "SectionTemplate_2/layout.json", JsonUtils.toJsonString((Object)new LayoutModel()));
        }
        return tempFile;
    }

    private void addJsonToZip(ZipOutputStream zos, String fileName, String jsonContent) throws IOException {
        ZipEntry entry = new ZipEntry(fileName);
        zos.putNextEntry(entry);
        zos.write(jsonContent.getBytes());
        zos.closeEntry();
    }
}

