/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.plugin;

import io.meeds.layout.model.LayoutModel;
import io.meeds.layout.model.SiteTemplate;
import io.meeds.layout.plugin.SiteTemplateDatabindPlugin;
import io.meeds.layout.service.NavigationLayoutService;
import io.meeds.layout.service.PageLayoutService;
import io.meeds.layout.service.PortletInstanceService;
import io.meeds.layout.service.SiteTemplateService;
import io.meeds.layout.util.JsonUtils;
import io.meeds.social.databind.model.DatabindReport;
import io.meeds.social.databind.service.DatabindService;
import io.meeds.social.translation.service.TranslationService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.tuple.Pair;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.config.serialize.model.SiteLayout;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.service.DescriptionService;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.service.NavigationService;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.attachment.AttachmentService;
import org.exoplatform.social.core.manager.IdentityManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={SiteTemplateDatabindPlugin.class})
@ExtendWith(value={MockitoExtension.class})
class SiteTemplateDatabindPluginTest {
    @Mock
    private Identity userIdentity;
    @MockBean
    private SiteTemplateService siteTemplateService;
    @MockBean
    LayoutService layoutService;
    @MockBean
    private DatabindService databindService;
    @MockBean
    private FileService fileService;
    @MockBean
    private TranslationService translationService;
    @MockBean
    private AttachmentService attachmentService;
    @MockBean
    private NavigationService navigationService;
    @MockBean
    private PortletInstanceService portletInstanceService;
    @MockBean
    private NavigationLayoutService navigationLayoutService;
    @MockBean
    DescriptionService descriptionService;
    @MockBean
    PageLayoutService pageLayoutService;
    @MockBean
    private UserACL userAcl;
    @MockBean
    private IdentityManager identityManager;
    @Autowired
    private SiteTemplateDatabindPlugin siteTemplateDatabindPlugin;

    SiteTemplateDatabindPluginTest() {
    }

    @Test
    void getObjectType() {
        Assertions.assertEquals((Object)"SiteTemplate", (Object)this.siteTemplateDatabindPlugin.getObjectType());
    }

    @Test
    void canHandleDatabind() {
        Assertions.assertTrue((boolean)this.siteTemplateDatabindPlugin.canHandleDatabind("SiteTemplate", "1"));
        Assertions.assertFalse((boolean)this.siteTemplateDatabindPlugin.canHandleDatabind("ObjectInstance", "1"));
    }

    @Test
    void serialize() throws ObjectNotFoundException {
        ZipOutputStream zipOutputStream = (ZipOutputStream)Mockito.mock(ZipOutputStream.class);
        SiteTemplate siteTemplate = (SiteTemplate)Mockito.mock(SiteTemplate.class);
        PortalConfig portalConfig = (PortalConfig)Mockito.mock(PortalConfig.class);
        SiteLayout siteLayout = (SiteLayout)Mockito.mock(SiteLayout.class);
        Mockito.when((Object)siteTemplate.getLayout()).thenReturn((Object)"layout");
        Mockito.when((Object)portalConfig.getPortalLayout()).thenReturn((Object)siteLayout);
        Mockito.when((Object)this.siteTemplateService.getSiteTemplate(ArgumentMatchers.anyLong(), (Locale)Mockito.any(Locale.class))).thenReturn((Object)siteTemplate);
        Mockito.when((Object)this.layoutService.getPortalConfig((SiteKey)Mockito.any(SiteKey.class))).thenReturn((Object)portalConfig);
        this.siteTemplateDatabindPlugin.serialize("1", zipOutputStream, "root");
        ((SiteTemplateService)Mockito.verify((Object)this.siteTemplateService, (VerificationMode)Mockito.times((int)1))).getSiteTemplate(1L, Locale.getDefault());
    }

    @Test
    void deserialize() throws Exception {
        File zipFile = this.createZipFileWithTwoJsonFiles();
        SiteTemplate siteTemplate = (SiteTemplate)Mockito.mock(SiteTemplate.class);
        PortalConfig portalConfig = (PortalConfig)Mockito.mock(PortalConfig.class);
        Mockito.when((Object)this.siteTemplateService.getSiteTemplate(ArgumentMatchers.anyLong(), (Locale)Mockito.any(Locale.class))).thenReturn((Object)siteTemplate);
        Mockito.when((Object)this.layoutService.getPortalConfig((SiteKey)Mockito.any(SiteKey.class))).thenReturn((Object)portalConfig);
        Mockito.when((Object)this.siteTemplateService.createSiteTemplate((SiteTemplate)Mockito.any(SiteTemplate.class), (SiteKey)Mockito.any(SiteKey.class), Mockito.anyString(), Mockito.anyBoolean())).thenReturn((Object)new SiteTemplate());
        NodeContext parentNode = (NodeContext)Mockito.mock(NodeContext.class);
        Mockito.when((Object)parentNode.getId()).thenReturn((Object)"85");
        Mockito.when((Object)this.navigationService.loadNode((SiteKey)Mockito.any(SiteKey.class))).thenReturn((Object)parentNode);
        CompletableFuture futureReport = this.siteTemplateDatabindPlugin.deserialize(zipFile, null, "admin");
        DatabindReport report = (DatabindReport)((CompletableFuture)futureReport.thenApply(Pair::getLeft)).join();
        Assertions.assertNotNull((Object)report);
        Assertions.assertTrue((boolean)report.isSuccess());
        Assertions.assertEquals((int)2, (int)report.getProcessedItems().size());
        Assertions.assertTrue((boolean)report.getProcessedItems().contains("name1"));
        Assertions.assertTrue((boolean)report.getProcessedItems().contains("name2"));
        ((SiteTemplateService)Mockito.verify((Object)this.siteTemplateService, (VerificationMode)Mockito.times((int)2))).createSiteTemplate((SiteTemplate)Mockito.any(SiteTemplate.class), (SiteKey)Mockito.any(SiteKey.class), Mockito.anyString(), Mockito.anyBoolean());
    }

    private File createZipFileWithTwoJsonFiles() throws IOException {
        File tempFile = File.createTempFile("test", ".zip");
        try (FileOutputStream fos = new FileOutputStream(tempFile);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            this.addJsonToZip(zos, "site1/config.json", "{\"names\":{\"en\":\"Test Page 2\"},\"descriptions\":{\"en\":\"Desc 2\"},\"siteDefinition\":{\"name\":\"name1\",\"type\":\"PORTAL\",\"layout\":" + JsonUtils.toJsonString((Object)new LayoutModel()) + "}}");
            this.addJsonToZip(zos, "site1/navigation.json", "[{\"name\":\"overview\",\"icon\":null,\"visibility\":\"DISPLAYED\",\"pageReference\":\"portal_template::public::overview\",\"labels\":{},\"children\":[{\"name\":\"actions\",\"icon\":null,\"visibility\":\"DISPLAYED\",\"pageReference\":\"portal_template::public::actions\",\"labels\":{},\"children\":[]}]}]");
            this.addJsonToZip(zos, "site2/config.json", "{\"names\":{\"en\":\"Test Page 2\"},\"descriptions\":{\"en\":\"Desc 2\"},\"siteDefinition\":{\"name\":\"name2\",\"type\":\"PORTAL\",\"layout\":" + JsonUtils.toJsonString((Object)new LayoutModel()) + "}}");
        }
        return tempFile;
    }

    private void addJsonToZip(ZipOutputStream zos, String fileName, String jsonContent) throws IOException {
        ZipEntry entry = new ZipEntry(fileName);
        zos.putNextEntry(entry);
        zos.write(jsonContent.getBytes());
        zos.closeEntry();
    }
}

