/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.rest;

import io.meeds.layout.model.SiteTemplate;
import io.meeds.layout.rest.SiteTemplateRest;
import io.meeds.layout.service.SiteTemplateService;
import io.meeds.layout.util.JsonUtils;
import io.meeds.spring.web.security.PortalAuthenticationManager;
import io.meeds.spring.web.security.WebSecurityConfiguration;
import jakarta.servlet.Filter;
import java.util.Locale;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureWebMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.http.MediaType;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.test.web.servlet.request.SecurityMockMvcRequestPostProcessors;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

@SpringBootTest(classes={SiteTemplateRest.class, PortalAuthenticationManager.class})
@ContextConfiguration(classes={WebSecurityConfiguration.class})
@AutoConfigureWebMvc
@AutoConfigureMockMvc(addFilters=false)
@ExtendWith(value={MockitoExtension.class})
public class SiteTemplateRestTest {
    private static final String REST_PATH = "/site/templates";
    private static final String SIMPLE_USER = "simple";
    private static final String TEST_PASSWORD = "testPassword";
    @MockBean
    private SiteTemplateService siteTemplateService;
    @Autowired
    private SecurityFilterChain filterChain;
    @Autowired
    private WebApplicationContext context;
    private MockMvc mockMvc;

    @BeforeEach
    void setup() {
        this.mockMvc = ((DefaultMockMvcBuilder)MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.context).addFilters(this.filterChain.getFilters().toArray(new Filter[0]))).build();
    }

    @Test
    void getSiteTemplatesAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)REST_PATH, (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.siteTemplateService});
    }

    @Test
    void getSiteTemplatesWithUser() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)REST_PATH, (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        ((SiteTemplateService)Mockito.verify((Object)this.siteTemplateService)).getSiteTemplates((Locale)ArgumentMatchers.any());
    }

    @Test
    void getSiteTemplateAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/site/templates/1", (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.siteTemplateService});
    }

    @Test
    void getSiteTemplateWithUser() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/site/templates/1", (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        ((SiteTemplateService)Mockito.verify((Object)this.siteTemplateService)).getSiteTemplate(ArgumentMatchers.eq((long)1L), (Locale)ArgumentMatchers.any());
    }

    @Test
    void createSiteTemplateAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)REST_PATH, (Object[])new Object[0]).content(JsonUtils.toJsonString((Object)new SiteTemplate())).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.siteTemplateService});
    }

    @Test
    void createSiteTemplateWithUser() throws Exception {
        SiteTemplate siteTemplate = new SiteTemplate();
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)REST_PATH, (Object[])new Object[0]).with(this.testSimpleUser()).content(JsonUtils.toJsonString((Object)siteTemplate)).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        ((SiteTemplateService)Mockito.verify((Object)this.siteTemplateService)).createSiteTemplate(siteTemplate, SIMPLE_USER);
    }

    @Test
    void createSiteTemplateWithUserForbidden() throws Exception {
        SiteTemplate siteTemplate = new SiteTemplate();
        Mockito.when((Object)this.siteTemplateService.createSiteTemplate(siteTemplate, SIMPLE_USER)).thenThrow(IllegalAccessException.class);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)REST_PATH, (Object[])new Object[0]).with(this.testSimpleUser()).content(JsonUtils.toJsonString((Object)siteTemplate)).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void updateSiteTemplateAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/site/templates/1", (Object[])new Object[0]).content(JsonUtils.toJsonString((Object)new SiteTemplate())).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.siteTemplateService});
    }

    @Test
    void updateSiteTemplateWithUser() throws Exception {
        SiteTemplate siteTemplate = new SiteTemplate();
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/site/templates/1", (Object[])new Object[0]).with(this.testSimpleUser()).content(JsonUtils.toJsonString((Object)siteTemplate)).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        siteTemplate.setId(1L);
        ((SiteTemplateService)Mockito.verify((Object)this.siteTemplateService)).updateSiteTemplate(siteTemplate, SIMPLE_USER);
    }

    @Test
    void updateSiteTemplateWithUserForbidden() throws Exception {
        SiteTemplate siteTemplate = new SiteTemplate();
        siteTemplate.setId(1L);
        Mockito.when((Object)this.siteTemplateService.updateSiteTemplate(siteTemplate, SIMPLE_USER)).thenThrow(IllegalAccessException.class);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/site/templates/1", (Object[])new Object[0]).with(this.testSimpleUser()).content(JsonUtils.toJsonString((Object)siteTemplate)).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void updateSiteTemplateWithUserNotFound() throws Exception {
        SiteTemplate siteTemplate = new SiteTemplate();
        siteTemplate.setId(1L);
        Mockito.when((Object)this.siteTemplateService.updateSiteTemplate(siteTemplate, SIMPLE_USER)).thenThrow(ObjectNotFoundException.class);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/site/templates/1", (Object[])new Object[0]).with(this.testSimpleUser()).content(JsonUtils.toJsonString((Object)siteTemplate)).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    void deleteSiteTemplateAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/site/templates/1", (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.siteTemplateService});
    }

    @Test
    void deleteSiteTemplateWithUser() throws Exception {
        SiteTemplate siteTemplate = new SiteTemplate();
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/site/templates/1", (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        siteTemplate.setId(1L);
        ((SiteTemplateService)Mockito.verify((Object)this.siteTemplateService)).deleteSiteTemplate(1L, SIMPLE_USER);
    }

    @Test
    void deleteSiteTemplateWithUserForbidden() throws Exception {
        SiteTemplate siteTemplate = new SiteTemplate();
        siteTemplate.setId(1L);
        ((SiteTemplateService)Mockito.doThrow(IllegalAccessException.class).when((Object)this.siteTemplateService)).deleteSiteTemplate(1L, SIMPLE_USER);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/site/templates/1", (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void deleteSiteTemplateWithUserNotFound() throws Exception {
        SiteTemplate siteTemplate = new SiteTemplate();
        siteTemplate.setId(1L);
        ((SiteTemplateService)Mockito.doThrow(ObjectNotFoundException.class).when((Object)this.siteTemplateService)).deleteSiteTemplate(1L, SIMPLE_USER);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/site/templates/1", (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    private RequestPostProcessor testSimpleUser() {
        return SecurityMockMvcRequestPostProcessors.user((String)SIMPLE_USER).password(TEST_PASSWORD).authorities(new GrantedAuthority[]{new SimpleGrantedAuthority("users")});
    }
}

