/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.service;

import com.google.javascript.jscomp.jarjar.com.google.re2j.Pattern;
import io.meeds.layout.model.LayoutModel;
import io.meeds.layout.model.PageCreateModel;
import io.meeds.layout.model.PageTemplate;
import io.meeds.layout.model.PermissionUpdateModel;
import io.meeds.layout.model.PortletInstancePreference;
import io.meeds.layout.service.ContainerLayoutService;
import io.meeds.layout.service.LayoutAclService;
import io.meeds.layout.service.PageTemplateService;
import io.meeds.layout.service.PortletInstanceService;
import io.meeds.layout.util.JsonUtils;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.addons.AddOnService;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.ApplicationState;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.ModelStyle;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageBody;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.config.model.TransientApplicationState;
import org.exoplatform.portal.config.serialize.model.SiteLayout;
import org.exoplatform.portal.mop.PageType;
import org.exoplatform.portal.mop.QueryResult;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.Utils;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.page.PageState;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.pom.spi.portlet.Portlet;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PageLayoutService {
    private static final String ADDON_CONTAINER_FACTORY_ID = "addonContainer";
    private static final Log LOG = ExoLogger.getLogger(PageLayoutService.class);
    private static final Pattern GENERIC_STYLE_MATCHER_VALIDATOR = Pattern.compile((String)"[#0-9a-zA-Z\\(\\),\\./\"'\\-%_ ]+");
    private static final String PAGE_NOT_EXISTS_MESSAGE = "Page with key %s doesn't exist";
    private static final String PAGE_NOT_ACCESSIBLE_MESSAGE = "Page with ref %s isn't accessible for user %s";
    private static final String PAGE_NOT_EDITABLE_MESSAGE = "Page with ref %s isn't editable for user %s";
    @Autowired
    private LayoutService layoutService;
    @Autowired
    private LayoutAclService aclService;
    @Autowired
    private ContainerLayoutService containerLayoutService;
    @Autowired
    private PageTemplateService pageTemplateService;
    @Autowired
    private PortletInstanceService portletInstanceService;
    @Autowired
    private AddOnService addOnService;

    public List<PageContext> getPages(String siteTypeName, String siteName, String pageDisplayName, int offset, int limit, String username) {
        SiteType siteType = null;
        if (StringUtils.isNotBlank((CharSequence)siteTypeName)) {
            siteType = SiteType.valueOf((String)siteTypeName.toUpperCase());
        }
        QueryResult queryResult = this.layoutService.findPages(offset, limit, siteType, siteName, null, pageDisplayName);
        ArrayList pages = new ArrayList();
        queryResult.iterator().forEachRemaining(pages::add);
        return pages.stream().filter(p -> this.aclService.canViewPage(p.getKey(), username)).toList();
    }

    public PageContext getPage(PageKey pageKey, String username) throws ObjectNotFoundException, IllegalAccessException {
        PageContext page = this.layoutService.getPageContext(pageKey);
        if (page == null) {
            throw new ObjectNotFoundException(String.format(PAGE_NOT_ACCESSIBLE_MESSAGE, pageKey, username));
        }
        if (!this.aclService.canViewPage(pageKey, username)) {
            throw new IllegalAccessException(String.format(PAGE_NOT_ACCESSIBLE_MESSAGE, pageKey, username));
        }
        return page;
    }

    public Application getPageApplicationLayout(PageKey pageKey, long applicationId, String username) throws ObjectNotFoundException, IllegalAccessException {
        ModelObject page = this.getPageLayout(pageKey, username);
        Application application = this.findApplication(page, applicationId);
        if (application == null) {
            throw new ObjectNotFoundException(String.format("Application with id %s wasn't found in page %s", applicationId, pageKey));
        }
        if (!this.aclService.hasAccessPermission((ModelObject)application, username)) {
            throw new IllegalAccessException(String.format("Application with id %s access denied", applicationId));
        }
        this.portletInstanceService.expandPortletPreferences(application, null);
        return application;
    }

    public void impersonateSite(SiteKey siteKey) {
        PortalConfig portalConfig = this.layoutService.getPortalConfig(siteKey);
        this.impersonateModel((ModelObject)portalConfig.getPortalLayout(), null);
        List pages = this.layoutService.findPages(siteKey);
        if (CollectionUtils.isNotEmpty((Collection)pages)) {
            pages.forEach(page -> this.impersonatePage(page.getKey()));
        }
    }

    public void impersonatePage(PageKey pageKey) {
        Page page = this.getPageLayout(pageKey);
        this.impersonateModel((ModelObject)page, page);
    }

    public ModelObject getPageLayout(PageKey pageKey, String username) throws ObjectNotFoundException, IllegalAccessException {
        return this.getPageLayout(pageKey, 0L, false, username);
    }

    public ModelObject getPageLayout(PageKey pageKey, long siteId, String username) throws ObjectNotFoundException, IllegalAccessException {
        return this.getPageLayout(pageKey, siteId, false, username);
    }

    public ModelObject getPageLayout(PageKey pageKey, long siteId, boolean impersonate, String username) throws ObjectNotFoundException, IllegalAccessException {
        Page page = this.getPageLayout(pageKey);
        if (page == null) {
            throw new ObjectNotFoundException(String.format(PAGE_NOT_ACCESSIBLE_MESSAGE, pageKey, username));
        }
        if (!this.aclService.canViewPage(pageKey, username) || !this.aclService.canViewSite(pageKey.getSite(), username)) {
            throw new IllegalAccessException(String.format(PAGE_NOT_ACCESSIBLE_MESSAGE, pageKey, username));
        }
        if (siteId > 0L) {
            PortalConfig site = this.layoutService.getPortalConfig(siteId);
            if (site == null) {
                throw new ObjectNotFoundException(String.format("Site width id %s not found", siteId));
            }
            SiteLayout portalLayout = site.getPortalLayout();
            this.replacePageBody((Container)portalLayout, (Container)page);
            page = portalLayout;
        }
        if (impersonate) {
            this.impersonateModel((ModelObject)page);
        }
        return this.filterByPermission((ModelObject)page, username);
    }

    public Page getPageLayout(PageKey pageKey) {
        Page page = this.layoutService.getPage(pageKey);
        if (page != null) {
            this.expandAddonContainerChildren((Container)page);
        }
        return page;
    }

    public PageContext createPage(PageCreateModel pageModel, String username) throws ObjectNotFoundException, IllegalAccessException, IllegalArgumentException {
        SiteKey siteKey = new SiteKey(pageModel.getPageSiteType(), pageModel.getPageSiteName());
        PortalConfig portalConfig = this.layoutService.getPortalConfig(siteKey);
        if (portalConfig == null) {
            throw new ObjectNotFoundException(String.format("Site with key %s doesn't exist", siteKey));
        }
        if (!this.aclService.canEditNavigation(siteKey, username)) {
            throw new IllegalAccessException();
        }
        String pageName = pageModel.getPageName() == null ? UUID.randomUUID().toString() : pageModel.getPageName() + "_" + String.valueOf(UUID.randomUUID());
        Page page = this.createPageInstance(pageModel.getPageSiteType(), pageModel.getPageSiteName(), pageName, this.getPageType(pageModel.getPageType()), pageModel.getPageTemplateId(), pageModel.getLink());
        page.setName(pageName);
        page.setTitle(pageModel.getPageTitle());
        String[] accessPermissions = pageModel.getAccessPermissions() == null ? portalConfig.getAccessPermissions() : pageModel.getAccessPermissions();
        page.setAccessPermissions(accessPermissions);
        String editPermission = pageModel.getEditPermission() == null ? portalConfig.getEditPermission() : pageModel.getEditPermission();
        page.setEditPermission(editPermission);
        this.validateCSSInputs((ModelObject)page);
        this.layoutService.save(new PageContext(page.getPageKey(), Utils.toPageState((Page)page)), page);
        return this.layoutService.getPageContext(page.getPageKey());
    }

    public PageKey clonePage(PageKey pageKey, String username) throws IllegalAccessException, ObjectNotFoundException {
        Page page = this.getPageLayout(pageKey);
        if (page == null) {
            throw new ObjectNotFoundException(String.format(PAGE_NOT_EXISTS_MESSAGE, pageKey.format()));
        }
        if (!this.aclService.canEditPage(pageKey, username)) {
            throw new IllegalAccessException(String.format(PAGE_NOT_EDITABLE_MESSAGE, pageKey.format(), username));
        }
        page.resetStorage();
        page.setName(page.getName() + "_draft_" + username);
        page.setTitle(page.getTitle() + " Draft " + username);
        this.replaceAddonContainerChildren((Container)page);
        this.layoutService.save(new PageContext(page.getPageKey(), Utils.toPageState((Page)page)), page);
        return page.getPageKey();
    }

    public void cloneSection(PageKey pageKey, long containerId, String username) throws IllegalAccessException, ObjectNotFoundException {
        Container container = this.containerLayoutService.findContainer(pageKey, containerId);
        if (container == null) {
            throw new ObjectNotFoundException(String.format(PAGE_NOT_EXISTS_MESSAGE, pageKey.format()));
        }
        if (!this.aclService.canEditPage(pageKey, username)) {
            throw new IllegalAccessException(String.format(PAGE_NOT_EDITABLE_MESSAGE, pageKey.format(), username));
        }
        Page page = this.getPageLayout(pageKey);
        Container parentContainer = this.findParentContainer((ModelObject)page, String.valueOf(containerId));
        Container clonedContainer = this.containerLayoutService.cloneContainer(container);
        int containerIndex = parentContainer.getChildren().stream().map(ModelObject::getStorageId).toList().indexOf(container.getStorageId());
        parentContainer.getChildren().add(containerIndex + 1, clonedContainer);
        this.layoutService.save(new PageContext(page.getPageKey(), Utils.toPageState((Page)page)), page);
    }

    public void updatePageApplicationPreferences(PageKey pageKey, long applicationId, List<PortletInstancePreference> preferences, String username) throws IllegalAccessException, ObjectNotFoundException {
        Page page = this.layoutService.getPage(pageKey);
        if (page == null) {
            throw new ObjectNotFoundException(String.format(PAGE_NOT_EXISTS_MESSAGE, pageKey.format()));
        }
        if (!this.aclService.canEditPage(pageKey, username)) {
            throw new IllegalAccessException(String.format(PAGE_NOT_EDITABLE_MESSAGE, pageKey.format(), username));
        }
        Application application = this.findApplication((ModelObject)page, applicationId);
        if (application == null) {
            throw new ObjectNotFoundException(String.format("Application with id %s wasn't found in page %s", applicationId, pageKey));
        }
        Portlet portletPreferences = new Portlet();
        preferences.forEach(preference -> portletPreferences.setValue(preference.getName(), preference.getValue()));
        this.layoutService.save(application.getState(), portletPreferences);
    }

    public PageContext updatePageLayout(String pageRef, Page page, boolean publish, String username) throws IllegalAccessException, ObjectNotFoundException {
        PageKey pageKey = PageKey.parse((String)pageRef);
        Page existingPage = this.layoutService.getPage(pageKey);
        if (existingPage == null) {
            throw new ObjectNotFoundException(String.format(PAGE_NOT_EXISTS_MESSAGE, pageKey.format()));
        }
        if (!this.aclService.canEditPage(pageKey, username)) {
            throw new IllegalAccessException(String.format(PAGE_NOT_EDITABLE_MESSAGE, pageKey.format(), username));
        }
        try {
            if (publish) {
                page.resetStorage();
            } else {
                page.checkStorage();
            }
        }
        catch (ObjectNotFoundException e) {
            LOG.debug((Object)"Error while accessing page applications storage information", (Throwable)e);
            throw new IllegalStateException("layout.pageOutdatedError");
        }
        this.validateCSSInputs((ModelObject)page);
        existingPage.setChildren(page.getChildren());
        this.layoutService.save(existingPage);
        return this.layoutService.getPageContext(existingPage.getPageKey());
    }

    public void updatePageLink(PageKey pageKey, String link, String username) throws ObjectNotFoundException, IllegalAccessException, IllegalStateException {
        PageContext pageContext = this.layoutService.getPageContext(pageKey);
        if (pageContext == null) {
            throw new ObjectNotFoundException(String.format(PAGE_NOT_EXISTS_MESSAGE, pageKey));
        }
        if (!this.aclService.canEditPage(pageKey, username)) {
            throw new IllegalAccessException();
        }
        PageState pageState = pageContext.getState();
        PageType pageType = this.getPageType(pageState.getType());
        if (pageType != PageType.LINK) {
            throw new IllegalStateException(String.format("Page %s isn't of type 'LINK'", pageKey));
        }
        pageState.setType(pageState.getType());
        pageState.setLink(link);
        pageContext.setState(pageState);
        this.layoutService.save(pageContext);
    }

    public void updatePagePermissions(PageKey pageKey, PermissionUpdateModel permissionUpdateModel, String username) throws ObjectNotFoundException, IllegalAccessException {
        PageContext pageContext = this.layoutService.getPageContext(pageKey);
        if (pageContext == null) {
            throw new ObjectNotFoundException(String.format(PAGE_NOT_EXISTS_MESSAGE, pageKey));
        }
        if (!this.aclService.canEditPage(pageKey, username)) {
            throw new IllegalAccessException();
        }
        PageState pageState = pageContext.getState();
        pageState.setAccessPermissions(permissionUpdateModel.getAccessPermissions());
        pageState.setEditPermission(permissionUpdateModel.getEditPermission());
        this.layoutService.save(pageContext);
    }

    public void impersonateModel(ModelObject object) {
        if (object instanceof Container) {
            Container container = (Container)object;
            ArrayList children = container.getChildren();
            if (CollectionUtils.isNotEmpty((Collection)children)) {
                children.forEach(this::impersonateModel);
            }
        } else if (object instanceof Application) {
            Application application = (Application)object;
            Portlet preferences = this.portletInstanceService.getApplicationPortletPreferences(application);
            application.setState((ApplicationState)new TransientApplicationState(this.layoutService.getId(application.getState()), preferences));
        }
    }

    private Page createPageInstance(String siteType, String siteName, String pageName, PageType pageType, Long pageTemplateId, String pageLink) throws IllegalArgumentException {
        return switch (pageType) {
            case PageType.PAGE -> {
                if (pageTemplateId == null) {
                    throw new IllegalArgumentException("pageTemplateId is mandatory");
                }
                PageTemplate pageTemplate = this.pageTemplateService.getPageTemplate(pageTemplateId);
                if (pageTemplate == null) {
                    throw new ObjectNotFoundException("pageTemplate not found");
                }
                if (pageTemplate.isDisabled()) {
                    throw new IllegalArgumentException("pageTemplate with designated Id is disabled");
                }
                Page page = new Page(siteType, siteName, pageName);
                Page pageLayout = JsonUtils.fromJsonString(pageTemplate.getContent(), LayoutModel.class).toPage();
                page.setChildren(pageLayout.getChildren());
                page.resetStorage();
                page.setType(pageType.name());
                yield page;
            }
            case PageType.LINK -> {
                Page page = new Page(siteType, siteName, pageName);
                page.setLink(pageLink);
                page.setType(pageType.name());
                yield page;
            }
            default -> throw new IllegalArgumentException("pageType is mandatory");
        };
    }

    private PageType getPageType(String pageType) {
        return StringUtils.isBlank((CharSequence)pageType) ? PageType.PAGE : PageType.valueOf((String)pageType.toUpperCase());
    }

    private void expandAddonContainerChildren(Container container) {
        if (StringUtils.equals((CharSequence)container.getFactoryId(), (CharSequence)ADDON_CONTAINER_FACTORY_ID)) {
            List applications = this.addOnService.getApplications(container.getName());
            if (CollectionUtils.isNotEmpty((Collection)applications)) {
                container.setChildren(new ArrayList(applications));
            }
        } else if (container.getChildren() != null) {
            container.getChildren().stream().filter(Objects::nonNull).filter(Container.class::isInstance).map(Container.class::cast).forEach(this::expandAddonContainerChildren);
        }
    }

    private void replaceAddonContainerChildren(Container container) {
        ArrayList subContainers = container.getChildren();
        if (subContainers == null) {
            return;
        }
        LinkedHashMap<Integer, List> addonContainerChildren = new LinkedHashMap<Integer, List>();
        for (int i = subContainers.size() - 1; i >= 0; --i) {
            ModelObject modelObject = (ModelObject)subContainers.get(i);
            if (!(modelObject instanceof Container)) continue;
            Container subContainer = (Container)modelObject;
            if (StringUtils.equals((CharSequence)subContainer.getFactoryId(), (CharSequence)ADDON_CONTAINER_FACTORY_ID)) {
                List applications2 = this.addOnService.getApplications(subContainer.getName());
                if (!CollectionUtils.isNotEmpty((Collection)applications2)) continue;
                addonContainerChildren.put(i, applications2);
                continue;
            }
            this.replaceAddonContainerChildren(subContainer);
        }
        if (!addonContainerChildren.isEmpty()) {
            addonContainerChildren.forEach((index, applications) -> {
                subContainers.remove((int)index);
                subContainers.addAll((int)index, applications);
            });
            container.setChildren(subContainers);
        }
    }

    private void validateCSSInputs(ModelObject modelObject) {
        Container container;
        ModelStyle cssStyle = modelObject.getCssStyle();
        Arrays.asList(modelObject.getHeight(), modelObject.getWidth(), cssStyle == null ? null : cssStyle.getBorderColor(), cssStyle == null ? null : cssStyle.getBorderSize(), cssStyle == null ? null : cssStyle.getBoxShadow(), cssStyle == null ? null : cssStyle.getBackgroundColor(), cssStyle == null ? null : cssStyle.getBackgroundImage(), cssStyle == null ? null : cssStyle.getBackgroundEffect(), cssStyle == null ? null : cssStyle.getBackgroundPosition(), cssStyle == null ? null : cssStyle.getBackgroundSize(), cssStyle == null ? null : cssStyle.getBackgroundRepeat(), cssStyle == null ? null : cssStyle.getTextTitleColor(), cssStyle == null ? null : cssStyle.getTextTitleFontSize(), cssStyle == null ? null : cssStyle.getTextTitleFontWeight(), cssStyle == null ? null : cssStyle.getTextTitleFontStyle(), cssStyle == null ? null : cssStyle.getTextColor(), cssStyle == null ? null : cssStyle.getTextFontSize(), cssStyle == null ? null : cssStyle.getTextFontWeight(), cssStyle == null ? null : cssStyle.getTextFontStyle(), cssStyle == null ? null : cssStyle.getTextHeaderColor(), cssStyle == null ? null : cssStyle.getTextHeaderFontSize(), cssStyle == null ? null : cssStyle.getTextHeaderFontWeight(), cssStyle == null ? null : cssStyle.getTextHeaderFontStyle(), cssStyle == null ? null : cssStyle.getTextSubtitleColor(), cssStyle == null ? null : cssStyle.getTextSubtitleFontSize(), cssStyle == null ? null : cssStyle.getTextSubtitleFontWeight(), cssStyle == null ? null : cssStyle.getTextSubtitleFontStyle()).forEach(this::validateCSSStyleValue);
        if (modelObject instanceof Container && !CollectionUtils.isEmpty((Collection)(container = (Container)modelObject).getChildren())) {
            container.getChildren().forEach(this::validateCSSInputs);
        }
    }

    private void validateCSSStyleValue(String value) {
        if (StringUtils.isNotBlank((CharSequence)value) && (!GENERIC_STYLE_MATCHER_VALIDATOR.matches(value) || value.contains("javascript") || value.contains("eval"))) {
            throw new IllegalArgumentException(String.format("Invalid css value input %s", value));
        }
    }

    private ModelObject filterByPermission(ModelObject modelObject, String username) {
        Container container;
        if (!this.aclService.hasAccessPermission(modelObject, username)) {
            return null;
        }
        if (modelObject instanceof Container && CollectionUtils.isNotEmpty((Collection)(container = (Container)modelObject).getChildren())) {
            container.setChildren(container.getChildren().stream().map(c -> this.filterByPermission((ModelObject)c, username)).filter(Objects::nonNull).collect(Collectors.toCollection(ArrayList::new)));
        }
        return modelObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void impersonateModel(ModelObject object, Page page) {
        block10: {
            Portlet preferences;
            Container container;
            if (object instanceof Container && !StringUtils.equals((CharSequence)(container = (Container)object).getFactoryId(), (CharSequence)ADDON_CONTAINER_FACTORY_ID)) {
                ArrayList children = container.getChildren();
                try {
                    this.containerLayoutService.impersonateContainer(container, page);
                }
                catch (Exception e) {
                    LOG.warn("Error while impersonating container '{}' in page '{}'. Ignore cloning container background image.", new Object[]{container.getStorageId(), page.getStorageId(), e});
                }
                if (CollectionUtils.isNotEmpty((Collection)children)) {
                    children.forEach(c -> this.impersonateModel((ModelObject)c, page));
                }
                break block10;
            }
            if (!(object instanceof Application)) break block10;
            Application application = (Application)object;
            ModelStyle cssStyle = object.getCssStyle();
            if (cssStyle != null && StringUtils.isNotBlank((CharSequence)cssStyle.getBackgroundImage())) {
                String clonedBackgroundImageUrl = null;
                try {
                    clonedBackgroundImageUrl = this.containerLayoutService.cloneBackgroundUrl(object, page, cssStyle.getBackgroundImage());
                }
                catch (Throwable throwable) {
                    cssStyle.setBackgroundImage(clonedBackgroundImageUrl);
                    throw throwable;
                }
                cssStyle.setBackgroundImage(clonedBackgroundImageUrl);
            }
            if ((preferences = this.portletInstanceService.getApplicationPortletPreferences(application)) != null && StringUtils.isNotBlank((CharSequence)application.getStorageId())) {
                this.layoutService.save(application.getState(), preferences);
            }
        }
    }

    private void replacePageBody(Container portalLayout, Container page) {
        if (portalLayout == null || CollectionUtils.isEmpty((Collection)portalLayout.getChildren())) {
            return;
        }
        int index = -1;
        ArrayList children = portalLayout.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            ModelObject modelObject = (ModelObject)children.get(i);
            if (modelObject instanceof PageBody) {
                index = i;
                break;
            }
            if (!(modelObject instanceof Container)) continue;
            Container container = (Container)modelObject;
            this.replacePageBody(container, page);
        }
        if (index >= 0) {
            children.remove(index);
            Container pageLayout = this.getPageBody((ModelObject)page);
            if (pageLayout == null) {
                pageLayout = page;
            }
            if (pageLayout != null) {
                pageLayout.setTemplate("PageBody");
                children.add(index, pageLayout);
            } else {
                children.add(index, page);
            }
        }
    }

    private Container getPageBody(ModelObject page) {
        if (page == null || !(page instanceof Container)) {
            return null;
        }
        Container container = (Container)page;
        if (StringUtils.equals((CharSequence)container.getTemplate(), (CharSequence)"system:/groovy/portal/webui/container/UIPageLayout.gtmpl")) {
            return container;
        }
        if (CollectionUtils.isEmpty((Collection)container.getChildren())) {
            return null;
        }
        return container.getChildren().stream().map(this::getPageBody).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private Application findApplication(ModelObject modelObject, long applicationId) {
        if (modelObject == null) {
            return null;
        }
        ModelObject modelObject2 = modelObject;
        Objects.requireNonNull(modelObject2);
        ModelObject modelObject3 = modelObject2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Container.class, Application.class}, (Object)modelObject3, n)) {
            case 0 -> {
                Container container = (Container)modelObject3;
                if (!CollectionUtils.isEmpty((Collection)container.getChildren())) {
                    yield container.getChildren().stream().map(m -> this.findApplication((ModelObject)m, applicationId)).filter(Objects::nonNull).findFirst().orElse(null);
                }
                yield null;
            }
            case 1 -> {
                Application application = (Application)modelObject3;
                if (StringUtils.equals((CharSequence)application.getStorageId(), (CharSequence)String.valueOf(applicationId))) {
                    yield application;
                }
                yield null;
            }
            default -> null;
        };
    }

    private Container findParentContainer(ModelObject modelObject, String containerStorageId) {
        if (modelObject == null) {
            return null;
        }
        ModelObject modelObject2 = modelObject;
        Objects.requireNonNull(modelObject2);
        ModelObject modelObject3 = modelObject2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Container.class}, (Object)modelObject3, n)) {
            case 0 -> {
                Container container = (Container)modelObject3;
                if (CollectionUtils.isNotEmpty((Collection)container.getChildren())) {
                    if (container.getChildren().stream().anyMatch(m -> StringUtils.equals((CharSequence)containerStorageId, (CharSequence)m.getStorageId()))) {
                        yield container;
                    }
                    yield container.getChildren().stream().map(m -> this.findParentContainer((ModelObject)m, containerStorageId)).filter(Objects::nonNull).findFirst().orElse(null);
                }
                yield null;
            }
            default -> null;
        };
    }
}

