/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.plugin.translation;

import io.meeds.layout.plugin.translation.CmsPortletTranslationPlugin;
import io.meeds.layout.service.LayoutAclService;
import io.meeds.social.translation.service.TranslationService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={CmsPortletTranslationPlugin.class})
@ExtendWith(value={MockitoExtension.class})
class CmsPortletTranslationPluginTest {
    @MockBean
    private LayoutAclService layoutAclService;
    @MockBean
    private TranslationService translationService;
    @Autowired
    private CmsPortletTranslationPlugin translationPlugin;
    private String username = "test";

    CmsPortletTranslationPluginTest() {
    }

    @Test
    void getObjectType() {
        Assertions.assertEquals((Object)"cmsPortlet", (Object)this.translationPlugin.getObjectType());
        Assertions.assertEquals((Object)"cmsPortlet", (Object)this.translationPlugin.getObjectType());
    }

    @Test
    void hasEditPermission() {
        Assertions.assertFalse((boolean)this.translationPlugin.hasEditPermission(0L, null));
        Assertions.assertFalse((boolean)this.translationPlugin.hasEditPermission(0L, this.username));
        Mockito.when((Object)this.layoutAclService.isAdministrator(this.username)).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.translationPlugin.hasEditPermission(0L, this.username));
    }

    @Test
    void hasAccessPermission() {
        Assertions.assertTrue((boolean)this.translationPlugin.hasAccessPermission(1L, this.username));
    }

    @Test
    void getAudienceId() {
        Assertions.assertEquals((long)0L, (long)this.translationPlugin.getAudienceId(0L));
    }

    @Test
    void getSpaceId() {
        Assertions.assertEquals((long)0L, (long)this.translationPlugin.getSpaceId(0L));
    }
}

