/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.rest;

import io.meeds.layout.model.LayoutModel;
import io.meeds.layout.model.NodeLabel;
import io.meeds.layout.model.SiteCreateModel;
import io.meeds.layout.model.SiteUpdateModel;
import io.meeds.layout.rest.SiteLayoutRest;
import io.meeds.layout.rest.util.RestEntityBuilder;
import io.meeds.layout.service.SiteLayoutService;
import io.meeds.spring.web.security.PortalAuthenticationManager;
import io.meeds.spring.web.security.WebSecurityConfiguration;
import jakarta.servlet.Filter;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Locale;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.importer.ImportMode;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.social.rest.entity.SiteEntity;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureWebMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.http.MediaType;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.test.web.servlet.request.SecurityMockMvcRequestPostProcessors;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

@SpringBootTest(classes={SiteLayoutRest.class, PortalAuthenticationManager.class})
@ContextConfiguration(classes={WebSecurityConfiguration.class})
@AutoConfigureWebMvc
@AutoConfigureMockMvc(addFilters=false)
@ExtendWith(value={MockitoExtension.class})
public class SiteLayoutRestTest {
    private static final String SIMPLE_USER = "simple";
    private static final String TEST_PASSWORD = "testPassword";
    private static final String SITE_NAME = "testsitename";
    private static final SiteKey SITE_KEY = new SiteKey(PortalConfig.DRAFT, "testsitename");
    private static final String REST_PATH = "/sites";
    private static final String LAYOUT_REST_PATH = "/sites/layout";
    private static final String LAYOUT_REST_PATH_WITH_PARAMS = "/sites/layout?siteType=DRAFT&siteName=testsitename";
    private static final String GET_SITE_REST_PATH = "/sites?lang=fr&siteType=DRAFT&siteName=testsitename";
    private static final String DELETE_LAYOUT_REST_PATH = "/sites?siteType=DRAFT&siteName=testsitename";
    private static final String CREATE_DRAFT_LAYOUT_REST_PATH = "/sites/draft?siteType=DRAFT&siteName=testsitename";
    private static final String RESTORE_LAYOUT_REST_PATH = "/sites/restore";
    private static final String RESTORE_LAYOUT_PARAMS = "siteType=DRAFT&siteName=testsitename&importMode=INSERT&siteLayout=true&pagesLayout=true&navigation=true";
    @MockBean
    private SiteLayoutService siteLayoutService;
    @MockBean
    private LayoutService layoutService;
    @Autowired
    private SecurityFilterChain filterChain;
    @Autowired
    private WebApplicationContext context;
    @Mock
    private NodeLabel nodeLabel;
    private MockMvc mockMvc;

    @BeforeEach
    void setup() {
        this.mockMvc = ((DefaultMockMvcBuilder)MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.context).addFilters(this.filterChain.getFilters().toArray(new Filter[0]))).build();
    }

    @Test
    void getSiteByIdWhenNotFound() throws Exception {
        ((SiteLayoutService)Mockito.doThrow(ObjectNotFoundException.class).when((Object)this.siteLayoutService)).getSite(2L, SIMPLE_USER);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/sites/2", (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    void getSiteByIdWhenIllegalAccess() throws Exception {
        ((SiteLayoutService)Mockito.doThrow(IllegalAccessException.class).when((Object)this.siteLayoutService)).getSite(2L, SIMPLE_USER);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/sites/2", (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void getSiteById() throws Exception {
        PortalConfig site = (PortalConfig)Mockito.mock(PortalConfig.class);
        Mockito.when((Object)this.siteLayoutService.getSite(2L, SIMPLE_USER)).thenReturn((Object)site);
        try (MockedStatic restEntityBuilder = Mockito.mockStatic(RestEntityBuilder.class);){
            restEntityBuilder.when(() -> RestEntityBuilder.toSiteEntity((PortalConfig)((PortalConfig)Mockito.any()), (HttpServletRequest)((HttpServletRequest)Mockito.any()), (Locale)((Locale)Mockito.any()))).thenReturn(Mockito.mock(SiteEntity.class));
            ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/sites/2", (Object[])new Object[0]).with(this.testSimpleUser()));
            response.andExpect(MockMvcResultMatchers.status().isOk());
        }
    }

    @Test
    void getSiteWhenNotFound() throws Exception {
        ((SiteLayoutService)Mockito.doThrow(ObjectNotFoundException.class).when((Object)this.siteLayoutService)).getSite(SITE_KEY, SIMPLE_USER);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)GET_SITE_REST_PATH, (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    void getSiteWhenIllegalAccess() throws Exception {
        ((SiteLayoutService)Mockito.doThrow(IllegalAccessException.class).when((Object)this.siteLayoutService)).getSite(SITE_KEY, SIMPLE_USER);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)GET_SITE_REST_PATH, (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void getSite() throws Exception {
        PortalConfig site = (PortalConfig)Mockito.mock(PortalConfig.class);
        Mockito.when((Object)this.siteLayoutService.getSite(SITE_KEY, SIMPLE_USER)).thenReturn((Object)site);
        Mockito.when((Object)site.getId()).thenReturn((Object)2L);
        Mockito.when((Object)this.siteLayoutService.getSite(2L, SIMPLE_USER)).thenReturn((Object)site);
        try (MockedStatic restEntityBuilder = Mockito.mockStatic(RestEntityBuilder.class);){
            restEntityBuilder.when(() -> RestEntityBuilder.toSiteEntity((PortalConfig)((PortalConfig)Mockito.any()), (HttpServletRequest)((HttpServletRequest)Mockito.any()), (Locale)((Locale)Mockito.any()))).thenReturn(Mockito.mock(SiteEntity.class));
            ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)GET_SITE_REST_PATH, (Object[])new Object[0]).with(this.testSimpleUser()));
            response.andExpect(MockMvcResultMatchers.status().isOk());
        }
    }

    @Test
    void getSiteLayoutWhenNotFound() throws Exception {
        ((SiteLayoutService)Mockito.doThrow(ObjectNotFoundException.class).when((Object)this.siteLayoutService)).getSiteLayout(SITE_KEY, SIMPLE_USER);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)LAYOUT_REST_PATH_WITH_PARAMS, (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    void getSiteLayoutWhenIllegalAccess() throws Exception {
        ((SiteLayoutService)Mockito.doThrow(IllegalAccessException.class).when((Object)this.siteLayoutService)).getSiteLayout(SITE_KEY, SIMPLE_USER);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)LAYOUT_REST_PATH_WITH_PARAMS, (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void getSiteLayout() throws Exception {
        ModelObject modelObject = (ModelObject)Mockito.mock(ModelObject.class);
        Mockito.when((Object)this.siteLayoutService.getSiteLayout(SITE_KEY, SIMPLE_USER)).thenReturn((Object)modelObject);
        LayoutModel layoutModel = (LayoutModel)Mockito.mock(LayoutModel.class);
        try (MockedStatic restEntityBuilder = Mockito.mockStatic(RestEntityBuilder.class);){
            restEntityBuilder.when(() -> RestEntityBuilder.toLayoutModel((ModelObject)((ModelObject)Mockito.any()), (LayoutService)((LayoutService)Mockito.any()), (String)((String)Mockito.any()))).thenReturn((Object)layoutModel);
            ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)LAYOUT_REST_PATH_WITH_PARAMS, (Object[])new Object[0]).with(this.testSimpleUser()));
            response.andExpect(MockMvcResultMatchers.status().isOk());
        }
    }

    @Test
    void deleteSiteWhenNotFound() {
        ((SiteLayoutService)Mockito.doThrow(ObjectNotFoundException.class).when((Object)this.siteLayoutService)).deleteSite(SITE_KEY, SIMPLE_USER);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)DELETE_LAYOUT_REST_PATH, (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    void deleteSiteWhenIllegalAccess() {
        ((SiteLayoutService)Mockito.doThrow(IllegalAccessException.class).when((Object)this.siteLayoutService)).deleteSite(SITE_KEY, SIMPLE_USER);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)DELETE_LAYOUT_REST_PATH, (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void deleteSite() {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)DELETE_LAYOUT_REST_PATH, (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    void updateSiteWhenNotFound() {
        ((SiteLayoutService)Mockito.doThrow(ObjectNotFoundException.class).when((Object)this.siteLayoutService)).updateSite((SiteUpdateModel)Mockito.any(), (String)Mockito.eq((Object)SIMPLE_USER));
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)REST_PATH, (Object[])new Object[0]).content("{}").contentType(MediaType.APPLICATION_JSON).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    void updateSiteWhenIllegalAccess() {
        ((SiteLayoutService)Mockito.doThrow(IllegalAccessException.class).when((Object)this.siteLayoutService)).updateSite((SiteUpdateModel)Mockito.any(), (String)Mockito.eq((Object)SIMPLE_USER));
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)REST_PATH, (Object[])new Object[0]).content("{}").contentType(MediaType.APPLICATION_JSON).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void updateSite() {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)REST_PATH, (Object[])new Object[0]).content("{}").contentType(MediaType.APPLICATION_JSON).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    void restoreSiteWhenNotFound() {
        ((SiteLayoutService)Mockito.doThrow(ObjectNotFoundException.class).when((Object)this.siteLayoutService)).restoreSite(SITE_KEY, ImportMode.INSERT, true, true, true, SIMPLE_USER);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)RESTORE_LAYOUT_REST_PATH, (Object[])new Object[0]).contentType("application/x-www-form-urlencoded").content(RESTORE_LAYOUT_PARAMS).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    void restoreSiteWhenIllegalAccess() {
        ((SiteLayoutService)Mockito.doThrow(IllegalAccessException.class).when((Object)this.siteLayoutService)).restoreSite(SITE_KEY, ImportMode.INSERT, true, true, true, SIMPLE_USER);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)RESTORE_LAYOUT_REST_PATH, (Object[])new Object[0]).contentType("application/x-www-form-urlencoded").content(RESTORE_LAYOUT_PARAMS).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void restoreSiteWhenIllegalState() {
        ((SiteLayoutService)Mockito.doThrow(IllegalStateException.class).when((Object)this.siteLayoutService)).restoreSite(SITE_KEY, ImportMode.INSERT, true, true, true, SIMPLE_USER);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)RESTORE_LAYOUT_REST_PATH, (Object[])new Object[0]).contentType("application/x-www-form-urlencoded").content(RESTORE_LAYOUT_PARAMS).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    void restoreSite() {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)RESTORE_LAYOUT_REST_PATH, (Object[])new Object[0]).contentType("application/x-www-form-urlencoded").content(RESTORE_LAYOUT_PARAMS).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    void createSiteWhenNotFound() {
        ((SiteLayoutService)Mockito.doThrow(ObjectAlreadyExistsException.class).when((Object)this.siteLayoutService)).createSite((SiteCreateModel)Mockito.any(), (String)Mockito.eq((Object)SIMPLE_USER));
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)REST_PATH, (Object[])new Object[0]).content("{}").contentType(MediaType.APPLICATION_JSON).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isConflict());
    }

    @Test
    void createSiteWhenIllegalAccess() {
        ((SiteLayoutService)Mockito.doThrow(IllegalAccessException.class).when((Object)this.siteLayoutService)).createSite((SiteCreateModel)Mockito.any(), (String)Mockito.eq((Object)SIMPLE_USER));
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)REST_PATH, (Object[])new Object[0]).content("{}").contentType(MediaType.APPLICATION_JSON).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void createSite() {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)REST_PATH, (Object[])new Object[0]).content("{}").contentType(MediaType.APPLICATION_JSON).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    void createDraftSiteWhenNotFound() {
        ((SiteLayoutService)Mockito.doThrow(ObjectNotFoundException.class).when((Object)this.siteLayoutService)).createDraftSite(SITE_KEY, SIMPLE_USER);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)CREATE_DRAFT_LAYOUT_REST_PATH, (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    void createDraftSiteWhenIllegalAccess() {
        ((SiteLayoutService)Mockito.doThrow(IllegalAccessException.class).when((Object)this.siteLayoutService)).createDraftSite(SITE_KEY, SIMPLE_USER);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)CREATE_DRAFT_LAYOUT_REST_PATH, (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void createDraftSite() {
        SiteKey draftSiteKey = new SiteKey(SiteType.DRAFT, "draftTest");
        PortalConfig draftSite = (PortalConfig)Mockito.mock(PortalConfig.class);
        Mockito.when((Object)draftSite.getId()).thenReturn((Object)3L);
        Mockito.when((Object)this.siteLayoutService.getSite(3L, SIMPLE_USER)).thenReturn((Object)draftSite);
        Mockito.when((Object)this.siteLayoutService.getSite(draftSiteKey, SIMPLE_USER)).thenReturn((Object)draftSite);
        Mockito.when((Object)this.siteLayoutService.createDraftSite(SITE_KEY, SIMPLE_USER)).thenReturn((Object)draftSiteKey);
        try (MockedStatic restEntityBuilder = Mockito.mockStatic(RestEntityBuilder.class);){
            restEntityBuilder.when(() -> RestEntityBuilder.toSiteEntity((PortalConfig)((PortalConfig)Mockito.any()), (HttpServletRequest)((HttpServletRequest)Mockito.any()), (Locale)((Locale)Mockito.any()))).thenReturn(Mockito.mock(SiteEntity.class));
            ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)CREATE_DRAFT_LAYOUT_REST_PATH, (Object[])new Object[0]).with(this.testSimpleUser()));
            response.andExpect(MockMvcResultMatchers.status().isOk());
        }
    }

    @Test
    void updateSiteLayoutWhenNotFound() {
        ((SiteLayoutService)Mockito.doThrow(ObjectNotFoundException.class).when((Object)this.siteLayoutService)).updateSiteLayout((SiteKey)Mockito.eq((Object)SITE_KEY), (PortalConfig)Mockito.any(), Mockito.anyBoolean(), (String)Mockito.eq((Object)SIMPLE_USER));
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)LAYOUT_REST_PATH_WITH_PARAMS, (Object[])new Object[0]).content("{}").contentType(MediaType.APPLICATION_JSON).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    void updateSiteLayoutWhenIllegalAccess() {
        ((SiteLayoutService)Mockito.doThrow(IllegalAccessException.class).when((Object)this.siteLayoutService)).updateSiteLayout((SiteKey)Mockito.eq((Object)SITE_KEY), (PortalConfig)Mockito.any(), Mockito.anyBoolean(), (String)Mockito.eq((Object)SIMPLE_USER));
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)LAYOUT_REST_PATH_WITH_PARAMS, (Object[])new Object[0]).content("{}").contentType(MediaType.APPLICATION_JSON).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void updateSiteLayout() {
        ModelObject modelObject = (ModelObject)Mockito.mock(ModelObject.class);
        Mockito.when((Object)this.siteLayoutService.getSiteLayout(SITE_KEY, SIMPLE_USER)).thenReturn((Object)modelObject);
        LayoutModel layoutModel = (LayoutModel)Mockito.mock(LayoutModel.class);
        try (MockedStatic restEntityBuilder = Mockito.mockStatic(RestEntityBuilder.class);){
            restEntityBuilder.when(() -> RestEntityBuilder.toLayoutModel((ModelObject)((ModelObject)Mockito.any()), (LayoutService)((LayoutService)Mockito.any()), (String)((String)Mockito.any()))).thenReturn((Object)layoutModel);
            ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)LAYOUT_REST_PATH_WITH_PARAMS, (Object[])new Object[0]).content("{}").contentType(MediaType.APPLICATION_JSON).with(this.testSimpleUser()));
            response.andExpect(MockMvcResultMatchers.status().isOk());
        }
    }

    @Test
    void getSiteLabels() throws Exception {
        ((SiteLayoutService)Mockito.doThrow(ObjectNotFoundException.class).when((Object)this.siteLayoutService)).getSiteLabels(Long.valueOf(2L), null);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/sites/2/labels", (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
        ((SiteLayoutService)Mockito.doThrow(IllegalAccessException.class).when((Object)this.siteLayoutService)).getSiteLabels(Long.valueOf(3L), null);
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/sites/3/labels", (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
        ((SiteLayoutService)Mockito.doReturn((Object)this.nodeLabel).when((Object)this.siteLayoutService)).getSiteLabels(Long.valueOf(4L), null);
        Mockito.when((Object)this.nodeLabel.getDefaultLanguage()).thenReturn((Object)"en");
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/sites/4/labels", (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.defaultLanguage", (Object[])new Object[0]).value((Object)"en"));
    }

    @Test
    void getSiteDescriptions() throws Exception {
        ((SiteLayoutService)Mockito.doThrow(ObjectNotFoundException.class).when((Object)this.siteLayoutService)).getSiteDescriptions(Long.valueOf(2L), null);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/sites/2/descriptions", (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
        ((SiteLayoutService)Mockito.doThrow(IllegalAccessException.class).when((Object)this.siteLayoutService)).getSiteDescriptions(Long.valueOf(3L), null);
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/sites/3/descriptions", (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
        ((SiteLayoutService)Mockito.doReturn((Object)this.nodeLabel).when((Object)this.siteLayoutService)).getSiteDescriptions(Long.valueOf(4L), null);
        Mockito.when((Object)this.nodeLabel.getDefaultLanguage()).thenReturn((Object)"en");
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/sites/4/descriptions", (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.defaultLanguage", (Object[])new Object[0]).value((Object)"en"));
    }

    private RequestPostProcessor testSimpleUser() {
        return SecurityMockMvcRequestPostProcessors.user((String)SIMPLE_USER).password(TEST_PASSWORD).authorities(new GrantedAuthority[]{new SimpleGrantedAuthority("users")});
    }
}

