/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.storage;

import io.meeds.layout.model.NavigationCreateModel;
import io.meeds.layout.model.SectionTemplate;
import io.meeds.layout.service.ContainerLayoutService;
import io.meeds.layout.service.NavigationLayoutService;
import io.meeds.layout.service.PageLayoutService;
import io.meeds.layout.storage.SectionTemplateLayoutStorage;
import java.util.ArrayList;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeState;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.service.NavigationService;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={SectionTemplateLayoutStorage.class})
@ExtendWith(value={MockitoExtension.class})
public class SectionTemplateLayoutStorageTest {
    @MockBean
    private LayoutService layoutService;
    @MockBean
    private NavigationService navigationService;
    @MockBean
    private PageLayoutService pageLayoutService;
    @MockBean
    private ContainerLayoutService containerLayoutService;
    @MockBean
    private NavigationLayoutService navigationLayoutService;
    @Autowired
    private SectionTemplateLayoutStorage sectionTemplateLayoutStorage;
    @Mock
    private SectionTemplate sectionTemplate;
    private String username = "testuser";

    @Test
    public void generateSectionTemplateNodeIdWhenNew() {
        NodeContext parentNode = (NodeContext)Mockito.mock(NodeContext.class);
        Mockito.when((Object)parentNode.getId()).thenReturn((Object)"85");
        Mockito.when((Object)this.navigationService.loadNode(SectionTemplateLayoutStorage.GLOBAL_SITE_KEY)).thenReturn((Object)parentNode);
        Mockito.when((Object)this.sectionTemplate.getContent()).thenReturn((Object)"{\"template\": \"FlexContainer\"}");
        this.sectionTemplateLayoutStorage.generateSectionTemplateNodeId(this.sectionTemplate, this.username);
        ((NavigationLayoutService)Mockito.verify((Object)this.navigationLayoutService)).createNode((NavigationCreateModel)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)this.username));
        ((PageLayoutService)Mockito.verify((Object)this.pageLayoutService)).impersonatePage((PageKey)ArgumentMatchers.any());
    }

    @Test
    public void generateSectionTemplateNodeIdWhenUpdate() {
        NodeContext parentNode = (NodeContext)Mockito.mock(NodeContext.class);
        NodeContext clonedNode = (NodeContext)Mockito.mock(NodeContext.class);
        Mockito.when((Object)this.navigationService.loadNode(SectionTemplateLayoutStorage.GLOBAL_SITE_KEY)).thenReturn((Object)parentNode);
        Mockito.when((Object)this.navigationLayoutService.findNode((NodeContext)ArgumentMatchers.any(), ArgumentMatchers.anyString())).thenReturn((Object)clonedNode);
        NodeState nodeState = (NodeState)Mockito.mock(NodeState.class);
        Mockito.when((Object)clonedNode.getState()).thenReturn((Object)nodeState);
        NodeState.Builder builder = (NodeState.Builder)Mockito.mock(NodeState.Builder.class);
        Mockito.when((Object)nodeState.builder()).thenReturn((Object)builder);
        Mockito.when((Object)builder.pageRef((PageKey)ArgumentMatchers.any())).thenReturn((Object)builder);
        Mockito.when((Object)builder.build()).thenReturn((Object)nodeState);
        Mockito.when((Object)clonedNode.getId()).thenReturn((Object)"21");
        Mockito.when((Object)this.sectionTemplate.getContent()).thenReturn((Object)"{\"template\": \"FlexContainer\"}");
        this.sectionTemplateLayoutStorage.generateSectionTemplateNodeId(this.sectionTemplate, this.username);
        ((NavigationService)Mockito.verify((Object)this.navigationService)).updateNode(Long.valueOf(21L), nodeState);
    }

    @Test
    public void generateSectionTemplateContent() {
        NodeContext parentNode = (NodeContext)Mockito.mock(NodeContext.class);
        NodeContext clonedNode = (NodeContext)Mockito.mock(NodeContext.class);
        Mockito.when((Object)this.navigationService.loadNode(SectionTemplateLayoutStorage.GLOBAL_SITE_KEY)).thenReturn((Object)parentNode);
        Mockito.when((Object)this.navigationLayoutService.findNode((NodeContext)ArgumentMatchers.any(), ArgumentMatchers.anyString())).thenReturn((Object)clonedNode);
        PageKey pageKey = (PageKey)Mockito.mock(PageKey.class);
        NodeState nodeState = (NodeState)Mockito.mock(NodeState.class);
        Mockito.when((Object)clonedNode.getState()).thenReturn((Object)nodeState);
        Mockito.when((Object)nodeState.getPageRef()).thenReturn((Object)pageKey);
        Container section = this.mockSectionPage(pageKey);
        this.sectionTemplateLayoutStorage.generateSectionTemplateContent(this.sectionTemplate, this.username);
        ((ContainerLayoutService)Mockito.verify((Object)this.containerLayoutService)).exportPortletPreferences((ModelObject)section);
    }

    @Test
    public void generateSectionTemplateContentByContainer() {
        Container section = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)this.containerLayoutService.cloneContainer(section)).thenReturn((Object)section);
        Page page = (Page)Mockito.mock(Page.class);
        Mockito.when((Object)this.layoutService.getPage((PageKey)ArgumentMatchers.any(PageKey.class))).thenReturn((Object)page);
        Container modelObject = (Container)Mockito.mock(Container.class);
        ArrayList<Container> children1 = new ArrayList<Container>();
        children1.add(modelObject);
        Mockito.when((Object)page.getChildren()).thenReturn(children1);
        ArrayList<Container> children2 = new ArrayList<Container>();
        children2.add(section);
        Mockito.when((Object)modelObject.getChildren()).thenReturn(children2);
        Mockito.when((Object)section.getTemplate()).thenReturn((Object)"FlexContainer");
        this.sectionTemplateLayoutStorage.generateSectionTemplateContent(this.sectionTemplate, section, this.username);
        ((ContainerLayoutService)Mockito.verify((Object)this.containerLayoutService)).exportPortletPreferences((ModelObject)section);
        ((PageLayoutService)Mockito.verify((Object)this.pageLayoutService)).impersonatePage((PageKey)ArgumentMatchers.any());
    }

    private Container mockSectionPage(PageKey pageKey) {
        Page page = (Page)Mockito.mock(Page.class);
        Mockito.when((Object)this.layoutService.getPage(pageKey)).thenReturn((Object)page);
        Container modelObject = (Container)Mockito.mock(Container.class);
        ArrayList<Container> children1 = new ArrayList<Container>();
        children1.add(modelObject);
        Mockito.when((Object)page.getChildren()).thenReturn(children1);
        ArrayList<Container> children2 = new ArrayList<Container>();
        Container section = (Container)Mockito.mock(Container.class);
        children2.add(section);
        Mockito.when((Object)modelObject.getChildren()).thenReturn(children2);
        return section;
    }
}

