/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.service;

import io.meeds.layout.model.SiteTemplate;
import io.meeds.layout.service.LayoutAclService;
import io.meeds.layout.service.SiteTemplateService;
import io.meeds.social.translation.service.TranslationService;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteFilter;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.service.NavigationService;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.social.attachment.AttachmentService;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={SiteTemplateService.class})
@ExtendWith(value={MockitoExtension.class})
public class SiteTemplateServiceTest {
    private static final Locale LOCALE = Locale.ENGLISH;
    private static final long ID = 5L;
    private static final String NAME = "Sample Site Template";
    private static final String DESCRIPTION = "This is a sample site template.";
    @MockBean
    private LayoutService layoutService;
    @MockBean
    private NavigationService navigationService;
    @MockBean
    private UserPortalConfigService portalConfigService;
    @MockBean
    private LayoutAclService aclService;
    @MockBean
    private TranslationService translationService;
    @MockBean
    private AttachmentService attachmentService;
    @MockBean
    private ListenerService listenerService;
    @Autowired
    private SiteTemplateService siteTemplateService;
    private String testuser = "testuser";
    private SiteTemplate siteTemplate;
    private PortalConfig portalConfig;

    @BeforeEach
    void setUp() {
        this.siteTemplate = new SiteTemplate();
        this.siteTemplate.setId(5L);
        this.siteTemplate.setLayout("layout");
        this.siteTemplate.setName(NAME);
        this.siteTemplate.setDescription(DESCRIPTION);
        this.siteTemplate.setIcon("icon.png");
        this.siteTemplate.setSystem(false);
        this.siteTemplate.setDisabled(false);
        this.portalConfig = (PortalConfig)Mockito.mock(PortalConfig.class);
        Mockito.lenient().when((Object)this.portalConfig.getId()).thenReturn((Object)5L);
        Mockito.lenient().when((Object)this.portalConfig.getName()).thenReturn((Object)"layout");
        Mockito.lenient().when((Object)this.portalConfig.getType()).thenReturn((Object)PortalConfig.PORTAL_TEMPLATE);
        Mockito.lenient().when((Object)this.portalConfig.getIcon()).thenReturn((Object)this.siteTemplate.getIcon());
        Mockito.lenient().when((Object)this.portalConfig.isRemovable()).thenReturn((Object)(!this.siteTemplate.isSystem() ? 1 : 0));
        Mockito.lenient().when((Object)this.portalConfig.getProperty("SITE_ENABLED")).thenReturn((Object)String.valueOf(!this.siteTemplate.isDisabled()));
    }

    @Test
    void testGetSiteTemplates() {
        Mockito.when((Object)this.layoutService.getSites((SiteFilter)ArgumentMatchers.any())).thenReturn(Arrays.asList(this.portalConfig));
        List templates = this.siteTemplateService.getSiteTemplates(LOCALE);
        Assertions.assertNotNull((Object)templates);
        Assertions.assertEquals((int)1, (int)templates.size());
    }

    @Test
    void testGetSiteTemplateById() {
        Mockito.when((Object)this.layoutService.getPortalConfig(5L)).thenReturn((Object)this.portalConfig);
        SiteTemplate template = this.siteTemplateService.getSiteTemplate(5L);
        Assertions.assertNotNull((Object)template);
        Assert.assertNull((Object)template.getName());
        Assert.assertNull((Object)template.getDescription());
        Assertions.assertEquals((long)0L, (long)template.getIllustrationId());
    }

    @Test
    void testGetSiteTemplateByIdWithDetails() {
        Mockito.when((Object)this.layoutService.getPortalConfig(5L)).thenReturn((Object)this.portalConfig);
        Mockito.when((Object)this.translationService.getTranslationLabelOrDefault("siteTemplate", this.portalConfig.getId(), "title", LOCALE)).thenReturn((Object)NAME);
        Mockito.when((Object)this.translationService.getTranslationLabelOrDefault("siteTemplate", this.portalConfig.getId(), "description", LOCALE)).thenReturn((Object)DESCRIPTION);
        Mockito.when((Object)this.attachmentService.getAttachmentFileIds("siteTemplate", String.valueOf(5L))).thenReturn(Collections.singletonList("4"));
        SiteTemplate template = this.siteTemplateService.getSiteTemplate(5L, LOCALE);
        Assertions.assertNotNull((Object)template);
        Assertions.assertEquals((Object)NAME, (Object)template.getName());
        Assertions.assertEquals((Object)DESCRIPTION, (Object)template.getDescription());
        Assertions.assertEquals((long)4L, (long)template.getIllustrationId());
    }

    @Test
    void testCreateSiteTemplate() {
        Mockito.when((Object)this.aclService.isAdministrator(this.testuser)).thenReturn((Object)true);
        ((UserPortalConfigService)Mockito.doAnswer(invocation -> {
            Mockito.when((Object)this.layoutService.getPortalConfig(SiteKey.portalTemplate((String)this.siteTemplate.getLayout()))).thenReturn((Object)this.portalConfig);
            return null;
        }).when((Object)this.portalConfigService)).createSiteFromTemplate(SiteKey.portalTemplate((String)"basic"), SiteKey.portalTemplate((String)this.siteTemplate.getLayout()));
        SiteTemplate createdTemplate = this.siteTemplateService.createSiteTemplate(this.siteTemplate, this.testuser);
        Assertions.assertNotNull((Object)createdTemplate);
        ((ListenerService)Mockito.verify((Object)this.listenerService)).broadcast("layout.siteTemplate.created", (Object)createdTemplate, (Object)this.testuser);
    }

    @Test
    void testCreateSiteTemplateWithExistingName() {
        Mockito.when((Object)this.aclService.isAdministrator(this.testuser)).thenReturn((Object)true);
        Mockito.when((Object)this.layoutService.getPortalConfig((SiteKey)ArgumentMatchers.any(SiteKey.class))).thenReturn((Object)this.portalConfig);
        Assertions.assertThrows(ObjectAlreadyExistsException.class, () -> this.siteTemplateService.createSiteTemplate(this.siteTemplate, this.testuser));
    }

    @Test
    void testCreateSiteTemplateWhenNotAdmin() {
        Mockito.when((Object)this.layoutService.getPortalConfig(5L)).thenReturn((Object)this.portalConfig);
        Assertions.assertThrows(IllegalAccessException.class, () -> this.siteTemplateService.createSiteTemplate(this.siteTemplate, this.testuser));
    }

    @Test
    void testUpdateSiteTemplate() {
        Mockito.when((Object)this.aclService.isAdministrator(this.testuser)).thenReturn((Object)true);
        Mockito.when((Object)this.layoutService.getPortalConfig(5L)).thenReturn((Object)this.portalConfig);
        SiteTemplate updatedTemplate = this.siteTemplateService.updateSiteTemplate(this.siteTemplate, this.testuser);
        Assertions.assertNotNull((Object)updatedTemplate);
        ((ListenerService)Mockito.verify((Object)this.listenerService)).broadcast("layout.siteTemplate.updated", (Object)updatedTemplate, (Object)this.testuser);
    }

    @Test
    void testUpdateSiteTemplateWhenNotFound() {
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.siteTemplateService.updateSiteTemplate(this.siteTemplate, this.testuser));
    }

    @Test
    void testUpdateSiteTemplateWhenNotAdmin() {
        Mockito.when((Object)this.layoutService.getPortalConfig(5L)).thenReturn((Object)this.portalConfig);
        Assertions.assertThrows(IllegalAccessException.class, () -> this.siteTemplateService.updateSiteTemplate(this.siteTemplate, this.testuser));
    }

    @Test
    void testDeleteSiteTemplate() {
        Mockito.when((Object)this.aclService.isAdministrator(this.testuser)).thenReturn((Object)true);
        Mockito.when((Object)this.layoutService.getPortalConfig(5L)).thenReturn((Object)this.portalConfig);
        Mockito.when((Object)this.layoutService.getPortalConfig(SiteKey.portalTemplate((String)this.siteTemplate.getLayout()))).thenReturn((Object)this.portalConfig);
        this.siteTemplateService.deleteSiteTemplate(5L, this.testuser);
        ((LayoutService)Mockito.verify((Object)this.layoutService)).remove((PortalConfig)ArgumentMatchers.any(PortalConfig.class));
        ((ListenerService)Mockito.verify((Object)this.listenerService)).broadcast("layout.siteTemplate.deleted", (Object)this.siteTemplate, (Object)this.testuser);
    }

    @Test
    void testDeleteSiteTemplateWhenSystem() {
        Mockito.when((Object)this.aclService.isAdministrator(this.testuser)).thenReturn((Object)true);
        Mockito.when((Object)this.layoutService.getPortalConfig(5L)).thenReturn((Object)this.portalConfig);
        Mockito.when((Object)this.portalConfig.isRemovable()).thenReturn((Object)false);
        Assertions.assertThrows(IllegalAccessException.class, () -> this.siteTemplateService.deleteSiteTemplate(5L, this.testuser));
    }

    @Test
    void testDeleteSiteTemplateWithoutAdminPermission() {
        Mockito.when((Object)this.layoutService.getPortalConfig(5L)).thenReturn((Object)this.portalConfig);
        Mockito.when((Object)this.aclService.isAdministrator(this.testuser)).thenReturn((Object)false);
        Assertions.assertThrows(IllegalAccessException.class, () -> this.siteTemplateService.deleteSiteTemplate(5L, this.testuser));
    }

    @Test
    void testDeleteSiteTemplateWhenNotFound() {
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.siteTemplateService.deleteSiteTemplate(5L, this.testuser));
    }
}

