/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.chat.listeners;

import io.meeds.chat.model.MatrixRoomPermissions;
import io.meeds.chat.model.MatrixUserPermission;
import io.meeds.chat.model.Room;
import io.meeds.chat.service.MatrixService;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MatrixSpaceListener
extends SpaceListenerPlugin {
    private static final Log LOG = ExoLogger.getLogger(MatrixSpaceListener.class);
    @Autowired
    private MatrixService matrixService;
    @Autowired
    private SpaceService spaceService;
    @Autowired
    OrganizationService organizationService;

    @PostConstruct
    public void init() {
        this.spaceService.registerSpaceListenerPlugin((SpaceListenerPlugin)this);
    }

    public void spaceCreated(SpaceLifeCycleEvent event) {
        if (!this.matrixService.isServiceAvailable()) {
            return;
        }
        Space space = event.getSpace();
        try {
            String matrixRoomId = this.matrixService.createRoom(space);
            if (StringUtils.isNotBlank((CharSequence)matrixRoomId)) {
                ArrayList<String> members = new ArrayList<String>(Arrays.asList(space.getMembers()));
                for (String manager : space.getManagers()) {
                    String matrixIdOfUser = this.matrixService.getMatrixIdForUser(manager);
                    if (!StringUtils.isNotBlank((CharSequence)matrixRoomId) || !StringUtils.isNotBlank((CharSequence)matrixIdOfUser)) continue;
                    this.matrixService.joinUserToRoom(matrixRoomId, matrixIdOfUser);
                    this.updateMemberRoleInSpace(space, matrixIdOfUser, "50");
                    members.remove(manager);
                }
                for (String member : members) {
                    String matrixIdOfUser = this.matrixService.getMatrixIdForUser(member);
                    if (!StringUtils.isNotBlank((CharSequence)matrixRoomId) || !StringUtils.isNotBlank((CharSequence)matrixIdOfUser)) continue;
                    this.matrixService.joinUserToRoom(matrixRoomId, matrixIdOfUser);
                }
            }
        }
        catch (Exception e) {
            LOG.error("Matrix integration: Could not create a room for space {}", new Object[]{space.getDisplayName(), e});
        }
    }

    public void spaceRenamed(SpaceLifeCycleEvent event) {
        if (!this.matrixService.isServiceAvailable()) {
            return;
        }
        Space space = event.getSpace();
        String spaceDisplayName = space.getDisplayName();
        Room room = this.matrixService.getRoomBySpace(space);
        if (StringUtils.isNotBlank((CharSequence)room.getRoomId())) {
            try {
                this.matrixService.renameRoom(room.getRoomId(), spaceDisplayName);
            }
            catch (Exception e) {
                LOG.error("Could not rename the room linked to the space {}", new Object[]{space.getDisplayName(), e});
            }
        }
    }

    public void joined(SpaceLifeCycleEvent event) {
        Room room;
        String roomId;
        if (!this.matrixService.isServiceAvailable()) {
            return;
        }
        Space space = event.getSpace();
        String userId = event.getTarget();
        String restrictedGroupOfUsers = PropertyManager.getProperty((String)"meeds.matrix.restricted.users.groupId");
        String matrixUserAdmin = PropertyManager.getProperty((String)"meeds.matrix.user.name");
        String matrixIdOfUser = this.matrixService.getMatrixIdForUser(userId);
        if (StringUtils.isBlank((CharSequence)matrixIdOfUser) && StringUtils.isNotBlank((CharSequence)restrictedGroupOfUsers) && restrictedGroupOfUsers.equals(space.getGroupId()) && !userId.equals(matrixUserAdmin)) {
            try {
                User user = this.organizationService.getUserHandler().findUserByName(userId);
                matrixIdOfUser = this.matrixService.saveUserAccount(user, true, false);
            }
            catch (Exception e) {
                LOG.error("Could not retrieve the user {}", new Object[]{userId, e});
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(roomId = (room = this.matrixService.getRoomBySpace(space)).getRoomId())) && StringUtils.isNotBlank((CharSequence)matrixIdOfUser)) {
            try {
                this.matrixService.joinUserToRoom(roomId, matrixIdOfUser);
            }
            catch (Exception e) {
                LOG.error("Could not join the user {} to the room of the space {} on Matrix", new Object[]{userId, space.getDisplayName(), e});
            }
        }
    }

    public void left(SpaceLifeCycleEvent event) {
        if (!this.matrixService.isServiceAvailable()) {
            return;
        }
        Space space = event.getSpace();
        String userId = event.getTarget();
        Room room = this.matrixService.getRoomBySpace(space);
        String roomId = room.getRoomId();
        String matrixIdOfUser = this.matrixService.getMatrixIdForUser(userId);
        if (StringUtils.isNotBlank((CharSequence)roomId) && StringUtils.isNotBlank((CharSequence)matrixIdOfUser)) {
            try {
                this.matrixService.kickUserFromRoom(roomId, matrixIdOfUser, "The user is no more member of the space %s, thus he was kicked out of this room!".formatted(space.getDisplayName()));
            }
            catch (Exception e) {
                LOG.error("Could not kick the user {] from the room of the space {}", new Object[]{userId, space.getDisplayName(), e});
            }
        }
    }

    public void grantedLead(SpaceLifeCycleEvent event) {
        if (!this.matrixService.isServiceAvailable()) {
            return;
        }
        Space space = event.getSpace();
        String matrixIdOfUser = this.matrixService.getMatrixIdForUser(event.getTarget());
        this.updateMemberRoleInSpace(space, matrixIdOfUser, "50");
    }

    public void revokedLead(SpaceLifeCycleEvent event) {
        if (!this.matrixService.isServiceAvailable()) {
            return;
        }
        Space space = event.getSpace();
        String matrixIdOfUser = this.matrixService.getMatrixIdForUser(event.getTarget());
        this.updateMemberRoleInSpace(space, matrixIdOfUser, "0");
    }

    private boolean updateMemberRoleInSpace(Space space, String matrixIdOfUser, String userRole) {
        Room room = this.matrixService.getRoomBySpace(space);
        String roomId = room.getRoomId();
        if (StringUtils.isNotBlank((CharSequence)roomId)) {
            try {
                MatrixRoomPermissions matrixRoomPermissions = this.matrixService.getRoomSettings(roomId);
                if (matrixRoomPermissions != null) {
                    if ("0".equals(userRole)) {
                        for (MatrixUserPermission userPermission : matrixRoomPermissions.getUsers()) {
                            String fullMatrixUserId = "@%s:%s".formatted(matrixIdOfUser, PropertyManager.getProperty((String)"meeds.matrix.server.name"));
                            if (!fullMatrixUserId.equals(userPermission.getUserName())) continue;
                            userPermission.setUserRole(userRole);
                        }
                    } else {
                        MatrixUserPermission matrixUserPermission = new MatrixUserPermission("@%s:%s".formatted(matrixIdOfUser, PropertyManager.getProperty((String)"meeds.matrix.server.name")), userRole);
                        matrixRoomPermissions.getUsers().add(matrixUserPermission);
                    }
                }
                return this.matrixService.updateRoomSettings(roomId, matrixRoomPermissions);
            }
            catch (Exception e) {
                LOG.error("Could not update member roles in the space {}", new Object[]{space.getDisplayName(), e});
            }
        }
        return false;
    }

    public void spaceAvatarEdited(SpaceLifeCycleEvent event) {
        if (!this.matrixService.isServiceAvailable()) {
            return;
        }
        Space space = event.getSpace();
        try {
            Room room = this.matrixService.getRoomBySpace(space);
            String roomId = room.getRoomId();
            this.matrixService.updateRoomAvatar(space, roomId);
        }
        catch (Exception e) {
            LOG.error((Object)"Could not update the room avatar on Matrix", (Throwable)e);
        }
    }

    public void spaceDescriptionEdited(SpaceLifeCycleEvent event) {
        if (!this.matrixService.isServiceAvailable()) {
            return;
        }
        Space space = event.getSpace();
        Room room = this.matrixService.getRoomBySpace(space);
        String roomId = room.getRoomId();
        try {
            if (StringUtils.isNotBlank((CharSequence)roomId)) {
                this.matrixService.updateRoomDescription(roomId, space.getDescription());
            }
        }
        catch (Exception e) {
            LOG.error("Could not save the description of space {} ", new Object[]{space.getDisplayName(), e});
        }
    }

    public void spaceRemoved(SpaceLifeCycleEvent event) {
        if (!this.matrixService.isServiceAvailable()) {
            return;
        }
        Space space = event.getSpace();
        Room room = this.matrixService.getRoomBySpace(space);
        String roomId = room.getRoomId();
        if (StringUtils.isNotBlank((CharSequence)roomId)) {
            try {
                this.matrixService.deleteRoom(roomId);
            }
            catch (Exception e) {
                LOG.error("Could not delete the room {} linked to the space {}", new Object[]{roomId, space.getDisplayName()});
            }
        }
    }
}

