/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.chat.service;

import io.meeds.chat.MatrixBaseTest;
import io.meeds.chat.model.MatrixRoomPermissions;
import io.meeds.chat.model.MatrixUserPermission;
import io.meeds.chat.model.Room;
import io.meeds.chat.rest.model.Message;
import io.meeds.chat.rest.model.RoomEntity;
import io.meeds.chat.rest.model.RoomList;
import io.meeds.chat.service.MatrixService;
import io.meeds.chat.service.utils.MatrixHttpClient;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.jpa.search.ProfileSearchConnector;
import org.exoplatform.social.core.jpa.storage.RDBMSIdentityStorageImpl;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.cache.CachedIdentityStorage;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.test.context.junit.jupiter.SpringJUnitConfig;

@SpringJUnitConfig(value={MatrixBaseTest.class})
class MatrixServiceTest
extends MatrixBaseTest {
    @MockBean
    MatrixHttpClient matrixHttpClient;
    @Autowired
    MatrixService matrixService;
    @Autowired
    SpaceService spaceService;
    @Autowired
    IdentityManager identityManager;
    @Autowired
    CachedIdentityStorage identityStorage;
    @MockBean
    ProfileSearchConnector profileSearchConnector;
    private List<Space> spacesToDelete = new ArrayList<Space>();

    MatrixServiceTest() {
    }

    @Test
    void init() {
        try {
            this.matrixService.init();
        }
        catch (Exception e) {
            Assertions.fail();
        }
    }

    @Test
    void updateUserDisplayName() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.getContainer();
        this.begin();
        Mockito.when((Object)this.profileSearchConnector.search((Identity)ArgumentMatchers.any(), (ProfileFilter)ArgumentMatchers.any(), (Relationship.Type)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).thenReturn(List.of("1", "2"));
        Mockito.when((Object)this.profileSearchConnector.count((Identity)ArgumentMatchers.any(), (ProfileFilter)ArgumentMatchers.any(), (Relationship.Type)ArgumentMatchers.any())).thenReturn((Object)2);
        ((RDBMSIdentityStorageImpl)this.identityStorage.getStorage()).setProfileSearchConnector(this.profileSearchConnector);
        Mockito.when((Object)this.matrixHttpClient.getAdminAccessToken(ArgumentMatchers.anyString())).thenReturn((Object)"ThisIsAnAccessToken");
    }

    @AfterEach
    void tearDown() {
        for (Space space : this.spacesToDelete) {
            try {
                this.spaceService.deleteSpace(space);
            }
            catch (Exception exception) {}
        }
        this.end();
    }

    @Test
    void createRoom() throws Exception {
        String matrixRoomId = "!thisIsACreatedRoom:matrix.exo.tn";
        Mockito.when((Object)this.matrixHttpClient.createRoom(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)matrixRoomId);
        MatrixUserPermission matrixUserPermission = new MatrixUserPermission();
        matrixUserPermission.setUserName("demo");
        matrixUserPermission.setUserRole("50");
        MatrixUserPermission raulUserPermission = new MatrixUserPermission();
        raulUserPermission.setUserName("raul");
        raulUserPermission.setUserRole("0");
        MatrixRoomPermissions matrixRoomPermissions = new MatrixRoomPermissions();
        matrixRoomPermissions.setUsers(new ArrayList<MatrixUserPermission>(List.of(new MatrixUserPermission[]{matrixUserPermission, raulUserPermission})));
        Mockito.when((Object)this.matrixHttpClient.getRoomSettings(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)matrixRoomPermissions);
        Space space = this.getSpaceInstance(1);
        String returnedMatrixRoomId = this.matrixService.createRoom(space);
        Assertions.assertNotNull((Object)matrixRoomId);
        Assertions.assertEquals((Object)matrixRoomId, (Object)returnedMatrixRoomId);
    }

    private Space getSpaceInstance(int number) {
        Space space = new Space();
        space.setDisplayName("my space " + number);
        space.setPrettyName(space.getDisplayName());
        space.setRegistration("open");
        space.setDescription("add new space " + number);
        space.setVisibility("public");
        space.setRegistration("validation");
        Space createdSpace = this.spaceService.createSpace(space, "root");
        String[] managers = new String[]{"demo", "tom"};
        String[] members = new String[]{"demo", "raul", "ghost", "dragon"};
        String[] invitedUsers = new String[]{"register1", "mary"};
        String[] pendingUsers = new String[]{"jame", "paul", "hacker"};
        Arrays.stream(pendingUsers).forEach(u -> this.spaceService.addPendingUser(createdSpace, u));
        Arrays.stream(invitedUsers).forEach(u -> this.spaceService.addInvitedUser(createdSpace, u));
        Arrays.stream(members).forEach(u -> this.spaceService.addMember(createdSpace, u));
        Arrays.stream(managers).forEach(u -> this.spaceService.addMember(createdSpace, u));
        Arrays.stream(managers).forEach(u -> this.spaceService.setManager(createdSpace, u, true));
        this.spacesToDelete.add(createdSpace);
        return createdSpace;
    }

    @Test
    void updateUserPresence() throws JsonException, IOException, InterruptedException {
        Mockito.when((Object)this.matrixHttpClient.setUserPresence(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)"online");
        String presence = this.matrixService.updateUserPresence("@user:matrix.exo.tn", "online", "I am available");
        Assertions.assertNotNull((Object)presence);
        Assertions.assertEquals((Object)"online", (Object)presence);
        Mockito.when((Object)this.matrixHttpClient.setUserPresence(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenThrow(new Throwable[]{new JsonException("Error")});
        presence = this.matrixService.updateUserPresence("@user:matrix.exo.tn", "online", "I am available");
        Assertions.assertNull((Object)presence);
    }

    public RoomList createRoomsList(int numberOfRooms) {
        ArrayList<RoomEntity> rooms = new ArrayList<RoomEntity>();
        for (int i = 0; i < numberOfRooms; ++i) {
            Space space = this.getSpaceInstance(i);
            Room room = this.matrixService.getRoomBySpace(space);
            RoomEntity roomEntity = this.toRoomEntity(room, space);
            rooms.add(roomEntity);
        }
        RoomList roomList = new RoomList();
        roomList.setTotalUnreadMessages(20L);
        roomList.setRooms(rooms);
        return roomList;
    }

    public RoomEntity toRoomEntity(Room room, Space space) {
        RoomEntity roomEntity = new RoomEntity();
        roomEntity.setId(room.getRoomId());
        roomEntity.setTopic(space.getDescription());
        roomEntity.setAvatarUrl(space.getAvatarUrl());
        roomEntity.setLastMessage(new Message("last message of " + space.getDisplayName(), "root"));
        roomEntity.setUnreadMessages(5L);
        roomEntity.setDirectChat(false);
        return roomEntity;
    }
}

