/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.chat.service;

import io.meeds.chat.model.Room;
import io.meeds.chat.service.MatrixService;
import io.meeds.chat.service.MatrixSynchronizationService;
import java.io.IOException;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class MatrixSynchronizationServiceTest {
    MatrixSynchronizationService matrixSynchronizationService;
    MatrixService matrixService;
    private SpaceService spaceService;
    private IdentityManager identityManager;

    MatrixSynchronizationServiceTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.spaceService = (SpaceService)Mockito.mock(SpaceService.class);
        this.identityManager = (IdentityManager)Mockito.mock(IdentityManager.class);
        this.matrixService = (MatrixService)Mockito.mock(MatrixService.class);
        this.matrixSynchronizationService = (MatrixSynchronizationService)Mockito.mock(MatrixSynchronizationService.class);
        ListAccess usersListAccess = (ListAccess)Mockito.mock(ListAccess.class);
        Mockito.when((Object)usersListAccess.getSize()).thenReturn((Object)3);
        Identity user1Identity = new Identity("user1");
        user1Identity.setRemoteId("user1");
        Identity user2Identity = new Identity("user2");
        user2Identity.setRemoteId("user2");
        Identity user3Identity = new Identity("user3");
        user3Identity.setRemoteId("user3");
        Profile user1Profile = new Profile(user1Identity);
        Profile user2Profile = new Profile(user2Identity);
        Profile user3Profile = new Profile(user3Identity);
        user1Profile.setProperty("matrixId", (Object)"user1");
        user2Profile.setProperty("matrixId", (Object)"user2");
        user3Profile.setProperty("matrixId", (Object)"user3");
        user1Identity.setProfile(user1Profile);
        user2Identity.setProfile(user2Profile);
        user3Identity.setProfile(user3Profile);
        Mockito.when((Object)((Identity[])usersListAccess.load(Mockito.anyInt(), Mockito.anyInt()))).thenReturn((Object)new Identity[]{user1Identity, user2Identity, user3Identity});
        Mockito.when((Object)this.identityManager.getIdentitiesByProfileFilter((String)Mockito.eq((Object)"organization"), (ProfileFilter)Mockito.any(ProfileFilter.class), Mockito.anyBoolean())).thenReturn((Object)usersListAccess);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity((String)Mockito.eq((Object)"user1"))).thenReturn((Object)user1Identity);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity((String)Mockito.eq((Object)"user2"))).thenReturn((Object)user2Identity);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity((String)Mockito.eq((Object)"user3"))).thenReturn((Object)user3Identity);
        Space space = new Space();
        space.setId(1L);
        space.setMembers(new String[]{"user1", "user2", "user3"});
        ListAccess spaces = (ListAccess)Mockito.mock(ListAccess.class);
        Mockito.when((Object)spaces.getSize()).thenReturn((Object)1);
        Mockito.when((Object)((Space[])spaces.load(Mockito.anyInt(), Mockito.anyInt()))).thenReturn((Object)new Space[]{space});
        Mockito.when((Object)this.spaceService.getMemberSpaces(Mockito.anyString())).thenReturn((Object)spaces);
        Mockito.when((Object)this.spaceService.getAllSpacesByFilter((SpaceFilter)Mockito.any())).thenReturn((Object)spaces);
        this.matrixSynchronizationService = new MatrixSynchronizationService(this.matrixService, this.spaceService, this.identityManager);
    }

    @Test
    void synchronizeSpaces() throws Exception {
        Mockito.when((Object)this.matrixService.createRoom((Space)Mockito.any())).thenReturn((Object)"!indexOfCreatedRoom:matrix.server.tn");
        this.matrixSynchronizationService.synchronizeSpaces();
        ((MatrixService)Mockito.verify((Object)this.matrixService, (VerificationMode)Mockito.times((int)1))).createRoom((Space)Mockito.any());
        ((MatrixService)Mockito.verify((Object)this.matrixService, (VerificationMode)Mockito.times((int)3))).joinUserToRoom(Mockito.anyString(), Mockito.anyString());
        ((MatrixService)Mockito.verify((Object)this.matrixService, (VerificationMode)Mockito.times((int)1))).updateRoomAvatar((Space)Mockito.any(), Mockito.anyString());
        Room room = new Room();
        room.setRoomId("!ThisIsAnIdentifierOfARoom:matrix.exo.tn");
        room.setSpaceId("1");
        Mockito.when((Object)this.matrixService.getRoomBySpace((Space)Mockito.any())).thenReturn((Object)room);
        this.matrixSynchronizationService.synchronizeSpaces();
        ((MatrixService)Mockito.verify((Object)this.matrixService, (VerificationMode)Mockito.times((int)1))).createRoom((Space)Mockito.any());
        ((MatrixService)Mockito.verify((Object)this.matrixService, (VerificationMode)Mockito.times((int)2))).updateRoomAvatar((Space)Mockito.any(), Mockito.anyString());
    }

    @Test
    void synchronizeUsers() throws JsonException, IOException, InterruptedException {
        this.matrixSynchronizationService.synchronizeUsers();
        ((MatrixService)Mockito.verify((Object)this.matrixService, (VerificationMode)Mockito.times((int)3))).updateUserAvatar((Profile)Mockito.any(), Mockito.anyString());
    }
}

