/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.chat;

import io.meeds.kernel.test.AbstractSpringTest;
import io.meeds.kernel.test.KernelExtension;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.component.test.KernelBootstrap;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class, KernelExtension.class})
@SpringBootApplication(scanBasePackages={"io.meeds.chat", "io.meeds.spring.kernel.test", "io.meeds.spring.jpa", "io.meeds.spring.liquibase", "io.meeds.spring.web"})
@EnableJpaRepositories(basePackages={"io.meeds.chat"})
@TestPropertySource(properties={"spring.liquibase.change-log=classpath:db/changelog/matrix-rdbms.db.changelog-master.xml", "spring.profiles.active=matrix"})
@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/matrix-test-configuration.xml")})
public class MatrixBaseTest
extends AbstractSpringTest {
    public static final String MODULE_NAME = "io.meeds.chat";
    private static KernelBootstrap bootstrap;
    public static final String CHANGELOG_PATH = "classpath:db/changelog/matrix-rdbms.db.changelog-master.xml";

    @BeforeAll
    static void beforeAll() {
        PropertyManager.setProperty((String)"meeds.matrix.jwt.secret", (String)"ThisIsAJWTSecretOfMatrixForTestingPurposes");
        PropertyManager.setProperty((String)"meeds.matrix.server.url", (String)"https://matrix.exo.tn");
        PropertyManager.setProperty((String)"meeds.matrix.server.name", (String)"matrix.exo.tn");
    }

    public PortalContainer getContainer() {
        return bootstrap == null ? this.bootContainer() : bootstrap.getContainer();
    }

    protected PortalContainer bootContainer() {
        PortalContainer container = MatrixBaseTest.bootContainer(((Object)((Object)this)).getClass());
        ExoContainerContext.setCurrentContainer((ExoContainer)container);
        return container;
    }

    protected void begin() {
        PortalContainer container = this.getContainer();
        ExoContainerContext.setCurrentContainer((ExoContainer)container);
        RequestLifeCycle.begin((ExoContainer)container);
    }

    protected void end() {
        RequestLifeCycle.end();
    }
}

