/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.chat.service;

import io.meeds.chat.MatrixBaseTest;
import io.meeds.chat.model.MatrixRoomPermissions;
import io.meeds.chat.model.MatrixUserPermission;
import io.meeds.chat.model.Room;
import io.meeds.chat.rest.model.Message;
import io.meeds.chat.rest.model.RoomEntity;
import io.meeds.chat.rest.model.RoomList;
import io.meeds.chat.service.MatrixService;
import io.meeds.chat.service.utils.MatrixHttpClient;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.jpa.search.ProfileSearchConnector;
import org.exoplatform.social.core.jpa.storage.RDBMSIdentityStorageImpl;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.model.AvatarAttachment;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.cache.CachedIdentityStorage;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.test.context.junit.jupiter.SpringJUnitConfig;

@SpringJUnitConfig(value={MatrixBaseTest.class})
class MatrixServiceTest
extends MatrixBaseTest {
    @MockBean
    MatrixHttpClient matrixHttpClient;
    @Autowired
    MatrixService matrixService;
    @Autowired
    SpaceService spaceService;
    @Autowired
    IdentityManager identityManager;
    @Autowired
    CachedIdentityStorage identityStorage;
    @MockBean
    ProfileSearchConnector profileSearchConnector;
    private List<Space> spacesToDelete = new ArrayList<Space>();
    private String matrixRoomId = "!thisIsACreatedRoom:matrix.exo.tn";
    private String accessToken = "ThisIsAnAccessToken";

    MatrixServiceTest() {
    }

    @Test
    void init() {
        try {
            this.matrixService.init();
        }
        catch (Exception e) {
            Assertions.fail();
        }
    }

    @Test
    void updateUserDisplayName() throws JsonException, IOException, InterruptedException {
        String userId = "@testuser:matrix.meeds.com";
        Mockito.when((Object)this.matrixHttpClient.getUserDisplayName((String)Mockito.eq((Object)userId), Mockito.anyString())).thenReturn((Object)"Test User");
        this.matrixService.updateUserDisplayName(userId, "Chat Bot");
        ((MatrixHttpClient)Mockito.verify((Object)this.matrixHttpClient, (VerificationMode)Mockito.times((int)1))).updateUserDisplayName(userId, "Chat Bot", this.accessToken);
    }

    @BeforeEach
    void setUp() throws Exception {
        this.getContainer();
        this.begin();
        PropertyManager.setProperty((String)"meeds.matrix.user.name", (String)"demo");
        Mockito.when((Object)this.profileSearchConnector.search((Identity)Mockito.any(), (ProfileFilter)Mockito.any(), (Relationship.Type)Mockito.any(), Mockito.anyLong(), Mockito.anyLong())).thenReturn(List.of("1", "2"));
        Mockito.when((Object)this.profileSearchConnector.count((Identity)Mockito.any(), (ProfileFilter)Mockito.any(), (Relationship.Type)Mockito.any())).thenReturn((Object)2);
        ((RDBMSIdentityStorageImpl)this.identityStorage.getStorage()).setProfileSearchConnector(this.profileSearchConnector);
        Mockito.when((Object)this.matrixHttpClient.getAdminAccessToken(Mockito.anyString())).thenReturn((Object)this.accessToken);
        Mockito.when((Object)this.matrixHttpClient.createRoom(Mockito.anyString(), Mockito.anyString(), Mockito.anyString())).thenReturn((Object)this.matrixRoomId);
        MatrixUserPermission matrixUserPermission = new MatrixUserPermission();
        matrixUserPermission.setUserName("demo");
        matrixUserPermission.setUserRole("50");
        MatrixUserPermission raulUserPermission = new MatrixUserPermission();
        raulUserPermission.setUserName("raul");
        raulUserPermission.setUserRole("0");
        MatrixRoomPermissions matrixRoomPermissions = new MatrixRoomPermissions();
        matrixRoomPermissions.setUsers(new ArrayList<MatrixUserPermission>(List.of(new MatrixUserPermission[]{matrixUserPermission, raulUserPermission})));
        Mockito.when((Object)this.matrixHttpClient.getRoomSettings(Mockito.anyString(), Mockito.anyString())).thenReturn((Object)matrixRoomPermissions);
        Mockito.when((Object)this.matrixHttpClient.saveUserAccount((Identity)Mockito.any(), Mockito.anyString(), Mockito.anyBoolean(), Mockito.anyString())).thenReturn((Object)"@demo:matrix.meeds.tn");
        Mockito.when((Object)this.matrixHttpClient.saveUserAccount((Identity)Mockito.any(), Mockito.anyString(), Mockito.anyBoolean(), Mockito.anyString(), Mockito.anyBoolean(), Mockito.anyBoolean())).thenReturn((Object)"@demo:matrix.meeds.tn");
    }

    @AfterEach
    void tearDown() {
        for (Space space : this.spacesToDelete) {
            try {
                this.spaceService.deleteSpace(space);
            }
            catch (Exception exception) {}
        }
        this.end();
    }

    @Test
    void createRoom() throws Exception {
        Space space = this.getSpaceInstance(1);
        String returnedMatrixRoomId = this.matrixService.createRoom(space);
        Assertions.assertNotNull((Object)this.matrixRoomId);
        Assertions.assertEquals((Object)this.matrixRoomId, (Object)returnedMatrixRoomId);
    }

    private Space getSpaceInstance(int number) {
        Space space = new Space();
        space.setDisplayName("my space " + number);
        space.setPrettyName(space.getDisplayName());
        space.setRegistration("open");
        space.setDescription("add new space " + number);
        space.setVisibility("public");
        space.setRegistration("validation");
        Space createdSpace = this.spaceService.createSpace(space, "root");
        String[] managers = new String[]{"demo", "tom"};
        String[] members = new String[]{"demo", "raul", "ghost", "dragon"};
        String[] invitedUsers = new String[]{"register1", "mary"};
        String[] pendingUsers = new String[]{"jame", "paul", "hacker"};
        Arrays.stream(pendingUsers).forEach(u -> this.spaceService.addPendingUser(createdSpace, u));
        Arrays.stream(invitedUsers).forEach(u -> this.spaceService.addInvitedUser(createdSpace, u));
        Arrays.stream(members).forEach(u -> this.spaceService.addMember(createdSpace, u));
        Arrays.stream(managers).forEach(u -> this.spaceService.addMember(createdSpace, u));
        Arrays.stream(managers).forEach(u -> this.spaceService.setManager(createdSpace, u, true));
        this.spacesToDelete.add(createdSpace);
        return createdSpace;
    }

    @Test
    void updateUserPresence() throws JsonException, IOException, InterruptedException {
        Mockito.when((Object)this.matrixHttpClient.setUserPresence(Mockito.anyString(), Mockito.anyString(), Mockito.anyString(), Mockito.anyString())).thenReturn((Object)"online");
        String presence = this.matrixService.updateUserPresence("@user:matrix.exo.tn", "online", "I am available");
        Assertions.assertNotNull((Object)presence);
        Assertions.assertEquals((Object)"online", (Object)presence);
        Mockito.when((Object)this.matrixHttpClient.setUserPresence(Mockito.anyString(), Mockito.anyString(), Mockito.anyString(), Mockito.anyString())).thenThrow(new Throwable[]{new JsonException("Error")});
        presence = this.matrixService.updateUserPresence("@user:matrix.exo.tn", "online", "I am available");
        Assertions.assertNull((Object)presence);
    }

    public RoomList createRoomsList(int numberOfRooms) {
        ArrayList<RoomEntity> rooms = new ArrayList<RoomEntity>();
        for (int i = 0; i < numberOfRooms; ++i) {
            Space space = this.getSpaceInstance(i);
            Room room = this.matrixService.getRoomBySpace(space);
            RoomEntity roomEntity = this.toRoomEntity(room, space);
            rooms.add(roomEntity);
        }
        RoomList roomList = new RoomList();
        roomList.setTotalUnreadMessages(20L);
        roomList.setRooms(rooms);
        return roomList;
    }

    public RoomEntity toRoomEntity(Room room, Space space) {
        RoomEntity roomEntity = new RoomEntity();
        roomEntity.setId(room.getRoomId());
        roomEntity.setTopic(space.getDescription());
        roomEntity.setAvatarUrl(space.getAvatarUrl());
        roomEntity.setLastMessage(new Message("last message of " + space.getDisplayName(), "root"));
        roomEntity.setUnreadMessages(5L);
        roomEntity.setDirectChat(false);
        return roomEntity;
    }

    @Test
    void getRoomBySpace() throws Exception {
        Space space = this.getSpaceInstance(1);
        Room room = this.matrixService.getRoomBySpace(space);
        Assertions.assertNotNull((Object)room);
        Assertions.assertEquals((Object)this.matrixRoomId, (Object)room.getRoomId());
    }

    @Test
    void updateUserAvatar() throws JsonException, IOException, InterruptedException {
        Profile demoProfile = this.identityManager.getOrCreateUserIdentity("demo").getProfile();
        String demoIdOnMatrix = "@demo:matrix.meeds.tn";
        InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("meeds.png");
        AvatarAttachment attachment = new AvatarAttachment(null, "meeds.png", "image/png", inputStream, System.currentTimeMillis());
        Mockito.when((Object)this.matrixHttpClient.uploadFile("avatar-of-demo.jpg", "image/png", attachment.getImageBytes(), this.accessToken)).thenReturn((Object)"/This/Is/An/URL/Of/AVATAR");
        demoProfile.setProperty("avatar", (Object)attachment);
        this.identityStorage.saveProfile(demoProfile);
        demoProfile = this.identityStorage.loadProfile(demoProfile);
        this.matrixService.updateUserAvatar(demoProfile, demoIdOnMatrix);
        ((MatrixHttpClient)Mockito.verify((Object)this.matrixHttpClient, (VerificationMode)Mockito.times((int)1))).updateUserAvatar(Mockito.anyString(), Mockito.anyString(), (String)Mockito.eq((Object)this.accessToken));
    }

    @Test
    void updateRoomAvatar() throws Exception {
        Space space = this.getSpaceInstance(1);
        InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("meeds.png");
        AvatarAttachment attachment = new AvatarAttachment(null, "meeds.png", "image/png", inputStream, System.currentTimeMillis());
        space.setAvatarAttachment(attachment);
        this.spaceService.updateSpaceAvatar(space, "demo");
        Mockito.when((Object)this.matrixHttpClient.uploadFile("avatar-space-my_space_1.png", "image/png", attachment.getImageBytes(), this.accessToken)).thenReturn((Object)"/This/Is/An/URL/Of/AVATAR");
        this.matrixService.updateRoomAvatar(space, this.matrixRoomId);
        ((MatrixHttpClient)Mockito.verify((Object)this.matrixHttpClient, (VerificationMode)Mockito.times((int)1))).updateRoomAvatar((String)Mockito.eq((Object)this.matrixRoomId), Mockito.anyString(), (String)Mockito.eq((Object)this.accessToken));
    }

    @Test
    void saveUserAccount() throws JsonException, IOException, InterruptedException {
        Identity demoIdentity = this.identityManager.getOrCreateUserIdentity("demo");
        String userIdOnMatrix = this.matrixService.saveUserAccount(demoIdentity, true);
        Assertions.assertNotNull((Object)userIdOnMatrix);
        Assertions.assertEquals((Object)"@demo:matrix.meeds.tn", (Object)userIdOnMatrix);
    }

    @Test
    void createDirectMessagingRoom() throws ObjectAlreadyExistsException {
        Room directMessagingRoom = new Room();
        directMessagingRoom.setRoomId("!ThisIsARoomId:matrix.meeds.tn");
        directMessagingRoom.setFirstParticipant("demo");
        directMessagingRoom.setSecondParticipant("raul");
        Room createdRoom = this.matrixService.createDirectMessagingRoom(directMessagingRoom);
        Assertions.assertNotNull((Object)createdRoom);
        Assertions.assertNotEquals((long)0L, (long)createdRoom.getId());
        Assertions.assertEquals((Object)directMessagingRoom.getRoomId(), (Object)createdRoom.getRoomId());
    }

    @Test
    void getById() throws Exception {
        Space space = this.getSpaceInstance(1);
        String roomId = this.matrixService.createRoom(space);
        Assertions.assertNotNull((Object)roomId);
        Room room = this.matrixService.getById(roomId);
        Assertions.assertNotNull((Object)room);
        String splitRoomId = roomId.substring(0, roomId.indexOf(":"));
        Room room1 = this.matrixService.getById(splitRoomId);
        Assertions.assertNotNull((Object)room1);
    }
}

