/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.chat.service;

import com.fasterxml.jackson.core.type.TypeReference;
import io.meeds.chat.MatrixBaseTest;
import io.meeds.chat.model.MatrixMessage;
import io.meeds.chat.model.Room;
import io.meeds.chat.service.ChatNotificationService;
import io.meeds.chat.service.MatrixService;
import io.meeds.pwa.model.PwaNotificationMessage;
import io.meeds.pwa.service.PwaNotificationService;
import io.meeds.social.util.JsonUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import org.exoplatform.commons.api.notification.model.UserSetting;
import org.exoplatform.commons.api.notification.service.setting.UserSettingService;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.resources.Orientation;
import org.exoplatform.services.resources.impl.LocaleConfigImpl;
import org.exoplatform.services.user.UserStateModel;
import org.exoplatform.services.user.UserStateService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.junit.jupiter.SpringJUnitConfig;
import org.springframework.test.util.ReflectionTestUtils;

@SpringJUnitConfig(value={MatrixBaseTest.class})
class ChatNotificationServiceTest
extends MatrixBaseTest {
    @Autowired
    MatrixService matrixService;
    @Autowired
    IdentityManager identityManager;
    @Autowired
    ChatNotificationService chatNotificationService;
    @Autowired
    PwaNotificationService pwaNotificationService;
    @Mock
    private UserStateService userStateService;
    @Mock
    private UserStateModel userStateModel;
    @Mock
    private UserSetting userSetting;
    @Mock
    private UserSettingService userSettingService;
    @Mock
    private SettingService settingService;
    private MockedStatic<CommonsUtils> commonsUtils;

    ChatNotificationServiceTest() {
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.commonsUtils = Mockito.mockStatic(CommonsUtils.class, (Answer)Mockito.CALLS_REAL_METHODS);
        this.commonsUtils.when(() -> CommonsUtils.getService(UserStateService.class)).thenReturn((Object)this.userStateService);
        this.commonsUtils.when(() -> CommonsUtils.getService(UserSettingService.class)).thenReturn((Object)this.userSettingService);
        Mockito.when((Object)this.userStateService.getUserState(Mockito.anyString())).thenReturn((Object)this.userStateModel);
        Mockito.when((Object)this.userSettingService.get(Mockito.anyString())).thenReturn((Object)this.userSetting);
        ReflectionTestUtils.setField((Object)this.chatNotificationService, (String)"settingService", (Object)this.settingService);
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        if (this.commonsUtils != null) {
            this.commonsUtils.close();
        }
    }

    @Test
    void sendCreateNotificationAction() throws Exception {
        Space space = this.getSpaceInstance(2);
        String roomId = this.matrixService.createRoom(space);
        this.roomsToDelete.add(roomId);
        Mockito.when((Object)this.userStateModel.getStatus()).thenReturn((Object)"available");
        Mockito.when((Object)this.userSetting.isSpaceMuted(Mockito.anyLong())).thenReturn((Object)false);
        ScheduledFuture action = this.chatNotificationService.sendCreateNotificationAction("eventIDOnMatrix", "demo", roomId, 5);
        Assertions.assertNotNull((Object)action);
        Mockito.when((Object)this.userStateModel.getStatus()).thenReturn((Object)"donotdisturb");
        Mockito.when((Object)this.userSetting.isSpaceMuted(Mockito.anyLong())).thenReturn((Object)false);
        action = this.chatNotificationService.sendCreateNotificationAction("eventIDOnMatrix", "demo", roomId, 5);
        Assertions.assertNull((Object)action);
        Mockito.when((Object)this.userStateModel.getStatus()).thenReturn((Object)"available");
        Mockito.when((Object)this.userSetting.isSpaceMuted(Mockito.anyLong())).thenReturn((Object)true);
        action = this.chatNotificationService.sendCreateNotificationAction("eventIDOnMatrix", "demo", roomId, 5);
        Assertions.assertNull((Object)action);
    }

    @Test
    void createNotification() throws Exception {
        Mockito.when((Object)this.userStateModel.getStatus()).thenReturn((Object)"available");
        Mockito.when((Object)this.userSetting.isSpaceMuted(Mockito.anyLong())).thenReturn((Object)false);
        String eventId = "eventIDOnMatrix";
        Space space = this.getSpaceInstance(1);
        String roomId = this.matrixService.createRoom(space);
        this.roomsToDelete.add(roomId);
        String userName = "demo";
        Identity demoIdentity = this.identityManager.getOrCreateUserIdentity("demo");
        String userIdOnMatrix = this.matrixService.saveUserAccount(demoIdentity, true);
        MatrixMessage matrixMessage = new MatrixMessage(eventId, roomId, "m.room.message", "This is a chat message", "m.text", userIdOnMatrix, new ArrayList());
        Mockito.when((Object)this.matrixHttpClient.getEventById(eventId, this.matrixRoomId, this.accessToken)).thenReturn((Object)matrixMessage);
        LocaleConfigImpl localeConfig = new LocaleConfigImpl();
        localeConfig.setLocale(Locale.ENGLISH);
        localeConfig.setOrientation(Orientation.LT);
        PwaNotificationMessage pwaNotificationMessage = this.chatNotificationService.createNotification(eventId, this.matrixRoomId, userName, this.accessToken);
        Assertions.assertNotNull((Object)pwaNotificationMessage);
        Assertions.assertEquals((Object)"Demo exo in my space 1", (Object)pwaNotificationMessage.getTitle());
        Assertions.assertEquals((Object)"This is a chat message", (Object)pwaNotificationMessage.getBody());
        Room oneToOneRoom = new Room();
        oneToOneRoom.setRoomId("!oneToOneRoom:matrix.meeds.tn");
        oneToOneRoom.setFirstParticipant("demo");
        oneToOneRoom.setSecondParticipant("tom");
        oneToOneRoom = this.matrixService.createDirectMessagingRoom(oneToOneRoom);
        this.roomsToDelete.add(oneToOneRoom.getRoomId());
        Identity tomIdentity = this.identityManager.getOrCreateUserIdentity("tom");
        matrixMessage = new MatrixMessage(eventId, oneToOneRoom.getRoomId(), "m.room.message", "This is a private chat message", "m.text", userIdOnMatrix, new ArrayList());
        Mockito.when((Object)this.matrixHttpClient.getEventById(eventId, oneToOneRoom.getRoomId(), this.accessToken)).thenReturn((Object)matrixMessage);
        pwaNotificationMessage = this.chatNotificationService.createNotification(eventId, oneToOneRoom.getRoomId(), userName, this.accessToken);
        Assertions.assertNotNull((Object)pwaNotificationMessage);
        Assertions.assertNotNull((Object)pwaNotificationMessage.getIcon());
        Assertions.assertEquals((Object)tomIdentity.getProfile().getFullName(), (Object)pwaNotificationMessage.getTitle());
        Assertions.assertEquals((Object)"This is a private chat message", (Object)pwaNotificationMessage.getBody());
    }

    @Test
    void testIsRoomMutedForUser() {
        String userName = "demo";
        String mutedRoomId = "!mutedRoom:matrix.meeds.tn";
        String otherRoomId = "!otherRoom:matrix.meeds.tn";
        Scope scope = ChatNotificationService.USER_CHAT_NOTIFICATION_SCOPE;
        String key = "mutedRooms";
        SettingValue settingValue = SettingValue.create((String)JsonUtils.toJsonString(Set.of(mutedRoomId)));
        Mockito.when((Object)this.settingService.get(Context.USER.id(userName), scope, key)).thenReturn((Object)settingValue);
        Assertions.assertTrue((boolean)this.chatNotificationService.isPrivateRoomMutedForUser(userName, mutedRoomId));
        SettingValue otherSettingValue = SettingValue.create((String)JsonUtils.toJsonString(Set.of(otherRoomId)));
        Mockito.when((Object)this.settingService.get(Context.USER.id(userName), scope, key)).thenReturn((Object)otherSettingValue);
        Assertions.assertFalse((boolean)this.chatNotificationService.isPrivateRoomMutedForUser(userName, mutedRoomId));
        Mockito.when((Object)this.settingService.get(Context.USER.id(userName), scope, key)).thenReturn(null);
        Assertions.assertFalse((boolean)this.chatNotificationService.isPrivateRoomMutedForUser(userName, mutedRoomId));
    }

    @Test
    void testToggleMutePrivateRoom() {
        String userName = "demo";
        String roomId = "!newRoom:matrix.meeds.tn";
        Scope scope = ChatNotificationService.USER_CHAT_NOTIFICATION_SCOPE;
        String key = "mutedRooms";
        Set[] currentMutedRooms = new Set[]{new HashSet()};
        Mockito.when((Object)this.settingService.get((Context)Mockito.eq((Object)Context.USER.id(userName)), (Scope)Mockito.eq((Object)scope), (String)Mockito.eq((Object)key))).thenAnswer(invocation -> SettingValue.create((String)JsonUtils.toJsonString((Object)currentMutedRooms[0])));
        ((SettingService)Mockito.doAnswer(invocation -> {
            String json = ((SettingValue)invocation.getArgument(3, SettingValue.class)).getValue().toString();
            currentMutedRooms[0] = (Set)JsonUtils.OBJECT_MAPPER.readValue(json, (TypeReference)new TypeReference<Set<String>>(this){});
            return null;
        }).when((Object)this.settingService)).set((Context)Mockito.any(), (Scope)Mockito.any(), (String)Mockito.any(), (SettingValue)Mockito.any());
        this.chatNotificationService.toggleMutePrivateRoom(userName, roomId);
        Assertions.assertTrue((boolean)currentMutedRooms[0].contains(roomId));
        this.chatNotificationService.toggleMutePrivateRoom(userName, roomId);
        Assertions.assertFalse((boolean)currentMutedRooms[0].contains(roomId));
        ((SettingService)Mockito.verify((Object)this.settingService, (VerificationMode)Mockito.times((int)2))).set((Context)Mockito.eq((Object)Context.USER.id(userName)), (Scope)Mockito.eq((Object)scope), (String)Mockito.eq((Object)key), (SettingValue)Mockito.any());
    }
}

