/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.chat.service;

import io.meeds.chat.MatrixBaseTest;
import io.meeds.chat.entity.RoomStatus;
import io.meeds.chat.model.Room;
import io.meeds.chat.rest.model.LastMessage;
import io.meeds.chat.rest.model.RoomEntity;
import io.meeds.chat.rest.model.RoomList;
import io.meeds.chat.service.MatrixService;
import io.meeds.chat.service.utils.MatrixHttpClient;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.model.AvatarAttachment;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.junit.jupiter.SpringJUnitConfig;

@SpringJUnitConfig(value={MatrixBaseTest.class})
class MatrixServiceTest
extends MatrixBaseTest {
    @Autowired
    MatrixService matrixService;
    @Autowired
    IdentityManager identityManager;

    MatrixServiceTest() {
    }

    @Test
    void init() {
        try {
            this.matrixService.init();
        }
        catch (Exception e) {
            Assertions.fail();
        }
    }

    @Test
    void updateUserDisplayName() throws JsonException, IOException, InterruptedException {
        String userId = "@testuser:matrix.meeds.com";
        Mockito.when((Object)this.matrixHttpClient.getUserDisplayName((String)Mockito.eq((Object)userId), Mockito.anyString())).thenReturn((Object)"Test User");
        this.matrixService.updateUserDisplayName(userId, "Chat Bot");
        ((MatrixHttpClient)Mockito.verify((Object)this.matrixHttpClient, (VerificationMode)Mockito.times((int)1))).updateUserDisplayName(userId, "Chat Bot", this.accessToken);
    }

    @Test
    void createRoom() throws Exception {
        Space space = this.getSpaceInstance(1);
        Room spaceRoom = this.matrixService.getRoomBySpace(space);
        Assertions.assertNotNull((Object)spaceRoom);
        this.roomsToDelete.add(spaceRoom.getRoomId());
        Assertions.assertEquals((Object)this.matrixRoomId, (Object)spaceRoom.getRoomId());
    }

    @Test
    void updateUserPresence() throws JsonException, IOException, InterruptedException {
        Mockito.when((Object)this.matrixHttpClient.setUserPresence(Mockito.anyString(), Mockito.anyString(), Mockito.anyString(), Mockito.anyString())).thenReturn((Object)"online");
        String presence = this.matrixService.updateUserPresence("@user:matrix.meeds.tn", "online", "I am available");
        Assertions.assertNotNull((Object)presence);
        Assertions.assertEquals((Object)"online", (Object)presence);
        Mockito.when((Object)this.matrixHttpClient.setUserPresence(Mockito.anyString(), Mockito.anyString(), Mockito.anyString(), Mockito.anyString())).thenThrow(new Throwable[]{new JsonException("Error")});
        presence = this.matrixService.updateUserPresence("@user:matrix.meeds.tn", "online", "I am available");
        Assertions.assertNull((Object)presence);
    }

    public RoomList createRoomsList(int numberOfRooms) {
        ArrayList<RoomEntity> rooms = new ArrayList<RoomEntity>();
        for (int i = 0; i < numberOfRooms; ++i) {
            Space space = this.getSpaceInstance(i);
            Room room = this.matrixService.getRoomBySpace(space);
            RoomEntity roomEntity = this.toRoomEntity(room, space);
            rooms.add(roomEntity);
        }
        RoomList roomList = new RoomList();
        roomList.setTotalUnreadMessages(20L);
        roomList.setRooms(rooms);
        return roomList;
    }

    public RoomEntity toRoomEntity(Room room, Space space) {
        RoomEntity roomEntity = new RoomEntity();
        roomEntity.setId(room.getRoomId());
        roomEntity.setTopic(space.getDescription());
        roomEntity.setAvatarUrl(space.getAvatarUrl());
        LastMessage lastMessage = new LastMessage();
        lastMessage.setContent("last message of " + space.getDisplayName());
        lastMessage.setSender("root");
        roomEntity.setLastMessage(lastMessage);
        roomEntity.setUnreadMessages(5L);
        roomEntity.setDirectChat(false);
        return roomEntity;
    }

    @Test
    void getRoomBySpace() throws Exception {
        Space space = this.getSpaceInstance(1);
        Room room = this.matrixService.getRoomBySpace(space);
        this.roomsToDelete.add(room.getRoomId());
        Assertions.assertNotNull((Object)room);
        Assertions.assertEquals((Object)this.matrixRoomId, (Object)room.getRoomId());
    }

    @Test
    void updateUserAvatar() throws JsonException, IOException, InterruptedException {
        Profile demoProfile = this.identityManager.getOrCreateUserIdentity("demo").getProfile();
        String demoIdOnMatrix = "@demo:matrix.meeds.tn";
        InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("meeds.png");
        AvatarAttachment attachment = new AvatarAttachment(null, "meeds.png", "image/png", inputStream, System.currentTimeMillis());
        Mockito.when((Object)this.matrixHttpClient.uploadFile("avatar-of-demo.jpg", "image/png", attachment.getImageBytes(), this.accessToken)).thenReturn((Object)"/This/Is/An/URL/Of/AVATAR");
        demoProfile.setProperty("avatar", (Object)attachment);
        this.identityStorage.saveProfile(demoProfile);
        demoProfile = this.identityStorage.loadProfile(demoProfile);
        this.matrixService.updateUserAvatar(demoProfile, demoIdOnMatrix);
        ((MatrixHttpClient)Mockito.verify((Object)this.matrixHttpClient, (VerificationMode)Mockito.times((int)1))).updateUserAvatar(Mockito.anyString(), Mockito.anyString(), (String)Mockito.eq((Object)this.accessToken));
    }

    @Test
    void updateRoomAvatar() throws Exception {
        Space space = this.getSpaceInstance(1);
        String roomId = this.matrixService.createRoom(space);
        this.roomsToDelete.add(roomId);
        InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("meeds.png");
        AvatarAttachment attachment = new AvatarAttachment(null, "meeds.png", "image/png", inputStream, System.currentTimeMillis());
        space.setAvatarAttachment(attachment);
        this.spaceService.updateSpaceAvatar(space, "demo");
        Mockito.when((Object)this.matrixHttpClient.uploadFile("avatar-space-my_space_1.png", "image/png", attachment.getImageBytes(), this.accessToken)).thenReturn((Object)"/This/Is/An/URL/Of/AVATAR");
        this.matrixService.updateRoomAvatar(space, this.matrixRoomId);
        ((MatrixHttpClient)Mockito.verify((Object)this.matrixHttpClient, (VerificationMode)Mockito.times((int)1))).updateRoomAvatar((String)Mockito.eq((Object)this.matrixRoomId), Mockito.anyString(), (String)Mockito.eq((Object)this.accessToken));
    }

    @Test
    void saveUserAccount() throws JsonException, IOException, InterruptedException {
        Identity demoIdentity = this.identityManager.getOrCreateUserIdentity("demo");
        String userIdOnMatrix = this.matrixService.saveUserAccount(demoIdentity, true);
        Assertions.assertNotNull((Object)userIdOnMatrix);
        Assertions.assertEquals((Object)"@demo:matrix.meeds.tn", (Object)userIdOnMatrix);
    }

    @Test
    void createDirectMessagingRoom() throws ObjectAlreadyExistsException {
        Room directMessagingRoom = new Room();
        directMessagingRoom.setRoomId("!ThisIsARoomId:matrix.meeds.tn");
        directMessagingRoom.setFirstParticipant("demo");
        directMessagingRoom.setSecondParticipant("raul");
        Room createdRoom = this.matrixService.createDirectMessagingRoom(directMessagingRoom);
        this.roomsToDelete.add(createdRoom.getRoomId());
        Assertions.assertNotNull((Object)createdRoom);
        Assertions.assertNotEquals((long)0L, (long)createdRoom.getId());
        Assertions.assertEquals((Object)directMessagingRoom.getRoomId(), (Object)createdRoom.getRoomId());
    }

    @Test
    void getById() throws Exception {
        Space space = this.getSpaceInstance(1);
        String roomId = this.matrixService.createRoom(space);
        this.roomsToDelete.add(roomId);
        Assertions.assertNotNull((Object)roomId);
        Room room = this.matrixService.getById(roomId);
        Assertions.assertNotNull((Object)room);
        String splitRoomId = roomId.substring(0, roomId.indexOf(":"));
        Room room1 = this.matrixService.getById(splitRoomId);
        Assertions.assertNotNull((Object)room1);
    }

    @Test
    void enableSpaceChat() throws Exception {
        Space space = this.getSpaceInstance(1);
        this.roomsToDelete.add(this.matrixRoomId);
        Room room = this.matrixService.getById(this.matrixRoomId);
        Assertions.assertEquals((Object)room.getStatus(), (Object)RoomStatus.ENABLED.name());
        this.matrixService.enableSpaceChat(space, false);
        ((MatrixHttpClient)Mockito.verify((Object)this.matrixHttpClient, (VerificationMode)Mockito.times((int)1))).kickUserFromRoom(Mockito.anyString(), Mockito.anyString(), Mockito.anyString(), Mockito.anyString());
        this.matrixService.enableSpaceChat(space, true);
        ((MatrixHttpClient)Mockito.verify((Object)this.matrixHttpClient, (VerificationMode)Mockito.times((int)2))).joinUserToRoom(Mockito.anyString(), Mockito.anyString(), Mockito.anyString());
    }

    @Test
    void overrideAdminRateLimit() throws IOException, InterruptedException {
        String admin = "admin";
        Mockito.when((Object)this.matrixHttpClient.getOverriddenRateLimitForUser(admin, this.accessToken)).thenReturn((Object)"{\n  \"messages_per_second\": 0,\n  \"burst_count\": 0\n}");
        this.matrixService.overrideAdminRateLimit(admin);
        ((MatrixHttpClient)Mockito.verify((Object)this.matrixHttpClient, (VerificationMode)Mockito.times((int)0))).overrideRateLimitForUser(admin, 0, 0, this.accessToken);
        Mockito.when((Object)this.matrixHttpClient.getOverriddenRateLimitForUser(admin, this.accessToken)).thenReturn((Object)"{\n  \"messages_per_second\": 10,\n  \"burst_count\": 20\n}");
        this.matrixService.overrideAdminRateLimit(admin);
        ((MatrixHttpClient)Mockito.verify((Object)this.matrixHttpClient, (VerificationMode)Mockito.times((int)1))).overrideRateLimitForUser(admin, 0, 0, this.accessToken);
    }
}

