/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.chat.web;

import io.meeds.chat.service.MatrixService;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.web.filter.Filter;

public class MatrixAuthJWTFilter
implements Filter {
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Cookie[] cookies;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        MatrixService matrixService = (MatrixService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(MatrixService.class);
        if (matrixService.isServiceAvailable() && (cookies = httpRequest.getCookies()) != null) {
            Cookie oldCookie;
            if (httpRequest.getRemoteUser() != null && Arrays.stream(cookies).noneMatch(cookie -> "matrix_jwt_token".equals(cookie.getName()))) {
                String sessionToken = matrixService.getJWTSessionToken(httpRequest.getRemoteUser());
                Cookie cookie2 = new Cookie("matrix_jwt_token", sessionToken);
                cookie2.setPath("/");
                cookie2.setMaxAge(604800);
                cookie2.setHttpOnly(false);
                cookie2.setSecure(request.isSecure());
                httpResponse.addCookie(cookie2);
            } else if (StringUtils.isBlank((CharSequence)httpRequest.getRemoteUser()) && (oldCookie = (Cookie)Arrays.stream(cookies).filter(cookie -> "matrix_jwt_token".equals(cookie.getName())).findFirst().orElse(null)) != null) {
                oldCookie.setValue("");
                oldCookie.setMaxAge(0);
                oldCookie.setPath("/");
                oldCookie.setHttpOnly(false);
                oldCookie.setSecure(request.isSecure());
                httpResponse.addCookie(oldCookie);
            }
        }
        chain.doFilter(request, response);
    }
}

