/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.chat.upgrade;

import io.meeds.chat.model.MatrixRoomPermissions;
import io.meeds.chat.model.Room;
import io.meeds.chat.service.MatrixService;
import io.meeds.chat.upgrade.UpdateRoomPermissionsUpgradePlugin;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.exoplatform.container.xml.InitParams;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class UpdateRoomPermissionsUpgradePluginTest {
    UpdateRoomPermissionsUpgradePluginTest() {
    }

    @Test
    void processUpgrade() {
        try {
            InitParams initParams = new InitParams();
            MatrixService matrixService = (MatrixService)Mockito.mock(MatrixService.class);
            Mockito.when((Object)matrixService.getSpaceRooms()).thenReturn(this.createSpaceRooms(3));
            Mockito.when((Object)matrixService.getRoomSettings(Mockito.anyString())).thenReturn((Object)this.createMatrixRoomPermission("0"), (Object[])new MatrixRoomPermissions[]{this.createMatrixRoomPermission("0"), this.createMatrixRoomPermission("0")});
            UpdateRoomPermissionsUpgradePlugin updateRoomPermissionsUpgradePlugin = new UpdateRoomPermissionsUpgradePlugin(initParams, matrixService);
            updateRoomPermissionsUpgradePlugin.processUpgrade("version1", "version2");
            ((MatrixService)Mockito.verify((Object)matrixService, (VerificationMode)Mockito.times((int)3))).updateRoomSettings(Mockito.anyString(), (MatrixRoomPermissions)Mockito.any(MatrixRoomPermissions.class));
        }
        catch (Exception e) {
            Assertions.fail();
        }
    }

    @Test
    void processUpgradeSomeRooms() {
        try {
            InitParams initParams = new InitParams();
            MatrixService matrixService = (MatrixService)Mockito.mock(MatrixService.class);
            Mockito.when((Object)matrixService.getSpaceRooms()).thenReturn(this.createSpaceRooms(3));
            Mockito.when((Object)matrixService.getRoomSettings(Mockito.anyString())).thenReturn((Object)this.createMatrixRoomPermission("0"), (Object[])new MatrixRoomPermissions[]{this.createMatrixRoomPermission("100"), this.createMatrixRoomPermission("0")});
            UpdateRoomPermissionsUpgradePlugin updateRoomPermissionsUpgradePlugin = new UpdateRoomPermissionsUpgradePlugin(initParams, matrixService);
            updateRoomPermissionsUpgradePlugin.processUpgrade("version1", "version2");
            ((MatrixService)Mockito.verify((Object)matrixService, (VerificationMode)Mockito.times((int)2))).updateRoomSettings(Mockito.anyString(), (MatrixRoomPermissions)Mockito.any(MatrixRoomPermissions.class));
        }
        catch (Exception e) {
            Assertions.fail();
        }
    }

    @Test
    void processUpgradeWithError() {
        try {
            InitParams initParams = new InitParams();
            MatrixService matrixService = (MatrixService)Mockito.mock(MatrixService.class);
            Mockito.when((Object)matrixService.getSpaceRooms()).thenReturn(this.createSpaceRooms(1));
            Mockito.when((Object)matrixService.getRoomSettings(Mockito.anyString())).thenThrow(new Throwable[]{new Exception("Exception")});
            UpdateRoomPermissionsUpgradePlugin updateRoomPermissionsUpgradePlugin = new UpdateRoomPermissionsUpgradePlugin(initParams, matrixService);
            updateRoomPermissionsUpgradePlugin.processUpgrade("version1", "version2");
            Assertions.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Room createSpaceRoom() {
        Random random = new Random();
        int randomInt = random.nextInt(100);
        Room spaceRoom = new Room();
        spaceRoom.setRoomId("RandomRoomId" + randomInt);
        spaceRoom.setSpaceId(String.valueOf(randomInt));
        return spaceRoom;
    }

    private List<Room> createSpaceRooms(int count) {
        ArrayList<Room> spaceRooms = new ArrayList<Room>();
        for (int i = 0; i < count; ++i) {
            spaceRooms.add(this.createSpaceRoom());
        }
        return spaceRooms;
    }

    private MatrixRoomPermissions createMatrixRoomPermission(String role) {
        MatrixRoomPermissions matrixRoomPermissions = new MatrixRoomPermissions();
        matrixRoomPermissions.setInvite(role);
        return matrixRoomPermissions;
    }
}

