/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.chat.listeners;

import io.meeds.chat.listeners.MatrixInfectedFileCleanupListener;
import io.meeds.chat.rest.model.MediaInfo;
import io.meeds.chat.service.MatrixService;
import java.util.Map;
import java.util.Optional;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.ListenerService;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

class MatrixInfectedFileCleanupListenerTest {
    @Mock
    private ListenerService listenerService;
    @Mock
    private MatrixService matrixService;
    @InjectMocks
    private MatrixInfectedFileCleanupListener listener;

    MatrixInfectedFileCleanupListenerTest() {
    }

    @BeforeEach
    void setup() {
        MockitoAnnotations.openMocks((Object)this);
    }

    @Test
    void shouldDeleteSynapseMediaAndBroadcastEvent() throws Exception {
        String path = "/scan/synapse/media/local_content/co/uJ/GGfSoxnTRbAOkmZwjsBh";
        String mediaId = "couJGGfSoxnTRbAOkmZwjsBh";
        Map<String, String> data = Map.of("infectedItemPath", path);
        Event event = new Event("clean-file-infected", (Object)"externalFileSystem", data);
        MediaInfo mediaInfo = new MediaInfo();
        mediaInfo.setFilename("test.png");
        mediaInfo.setMediaId(mediaId);
        mediaInfo.setOwner("john");
        mediaInfo.setCreatedTs(123456789L);
        Mockito.when((Object)this.matrixService.getMediaInfo(mediaId)).thenReturn(Optional.of(mediaInfo));
        this.listener.onEvent(event);
        ((MatrixService)Mockito.verify((Object)this.matrixService)).getMediaInfo(mediaId);
        ((MatrixService)Mockito.verify((Object)this.matrixService)).deleteMedia(mediaId);
        ((ListenerService)Mockito.verify((Object)this.listenerService)).broadcast(Mockito.anyString(), Mockito.any(), Mockito.any());
    }

    @Test
    void shouldIgnoreIfNotSynapsePath() throws Exception {
        Map<String, String> data = Map.of("infectedItemPath", "/scan/other/system/file.txt");
        Event event = new Event("clean-file-infected", (Object)"externalFileSystem", data);
        this.listener.onEvent(event);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.matrixService});
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.never())).broadcast((String)Mockito.any(), Mockito.any(), Mockito.any());
    }

    @Test
    void shouldIgnoreIfMediaNotFound() throws Exception {
        String path = "/scan/synapse/media/local_content/co/uJ/ABCDEF123";
        Map<String, String> data = Map.of("infectedItemPath", path);
        Mockito.when((Object)this.matrixService.getMediaInfo(Mockito.anyString())).thenReturn(Optional.empty());
        Event event = new Event("clean-file-infected", (Object)"externalFileSystem", data);
        this.listener.onEvent(event);
        ((MatrixService)Mockito.verify((Object)this.matrixService)).getMediaInfo("couJABCDEF123");
        ((MatrixService)Mockito.verify((Object)this.matrixService, (VerificationMode)Mockito.never())).deleteMedia(Mockito.anyString());
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.never())).broadcast((String)Mockito.any(), Mockito.any(), Mockito.any());
    }
}

