/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service.plugin;

import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.attachment.AttachmentPlugin;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.wiki.model.DraftPage;
import org.exoplatform.wiki.service.NoteService;
import org.exoplatform.wiki.utils.Utils;

public class WikiDraftPageAttachmentPlugin
extends AttachmentPlugin {
    private final NoteService noteService;
    private final SpaceService spaceService;
    public static final String OBJECT_TYPE = "wikiDraft";

    public WikiDraftPageAttachmentPlugin(NoteService noteService, SpaceService spaceService) {
        this.noteService = noteService;
        this.spaceService = spaceService;
    }

    public String getObjectType() {
        return OBJECT_TYPE;
    }

    public boolean hasAccessPermission(Identity identity, String draftId) {
        try {
            DraftPage draftPage = this.noteService.getDraftNoteById(draftId, identity.getUserId());
            return draftPage != null && draftPage.isCanView();
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean hasEditPermission(Identity identity, String draftId) throws ObjectNotFoundException {
        try {
            DraftPage draftPage = this.noteService.getDraftNoteById(draftId, identity.getUserId());
            return draftPage != null && draftPage.isCanManage();
        }
        catch (Exception e) {
            return false;
        }
    }

    public long getAudienceId(String s) throws ObjectNotFoundException {
        return 0L;
    }

    public long getSpaceId(String draftId) throws ObjectNotFoundException {
        try {
            String username = Utils.getCurrentUser();
            DraftPage draftPage = this.noteService.getDraftNoteById(draftId, username);
            return Long.parseLong(this.spaceService.getSpaceByGroupId(draftPage.getWikiOwner()).getId());
        }
        catch (Exception exception) {
            return 0L;
        }
    }
}

