/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.jpa.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import org.exoplatform.wiki.jpa.entity.BasePageEntity;
import org.exoplatform.wiki.jpa.entity.PageEntity;

@Entity(name="WikiDraftPageEntity")
@Table(name="WIKI_DRAFT_PAGES")
@NamedQueries(value={@NamedQuery(name="wikiDraftPage.findDraftPages", query="SELECT d FROM WikiDraftPageEntity d ORDER BY d.updatedDate DESC"), @NamedQuery(name="wikiDraftPage.findDraftPageByName", query="SELECT d FROM WikiDraftPageEntity d WHERE d.name = :draftPageName ORDER BY d.updatedDate DESC"), @NamedQuery(name="wikiDraftPage.findLatestDraftPageByTargetPage", query="SELECT d FROM WikiDraftPageEntity d WHERE d.targetPage.id = :targetPageId ORDER BY d.updatedDate DESC"), @NamedQuery(name="wikiDraftPage.findDraftPageByTargetPage", query="SELECT d FROM WikiDraftPageEntity d WHERE d.targetPage.id = :targetPageId"), @NamedQuery(name="wikiDraftPage.findDraftPagesByParentPage", query="SELECT d FROM WikiDraftPageEntity d WHERE d.parentPage.id = :parentPageId"), @NamedQuery(name="wikiDraftPage.countDraftPagesByParentPage", query="SELECT count(*) FROM WikiDraftPageEntity d WHERE d.parentPage.id = :parentPageId"), @NamedQuery(name="wikiDraftPage.findLatestDraftPageByTargetPageAndLang", query="SELECT d FROM WikiDraftPageEntity d WHERE d.targetPage.id = :targetPageId AND ((:lang IS NULL AND d.lang IS NULL) OR (:lang IS NOT NULL AND d.lang = :lang)) ORDER BY d.updatedDate DESC"), @NamedQuery(name="wikiDraftPage.deleteOrphanDraftPagesByParentPage", query="DELETE FROM WikiDraftPageEntity d WHERE d.targetPage IS NULL AND d.parentPage.id=:id")})
public class DraftPageEntity
extends BasePageEntity {
    @Id
    @SequenceGenerator(name="SEQ_WIKI_DRAFT_PAGES_DRAFT_ID", sequenceName="SEQ_WIKI_DRAFT_PAGES_DRAFT_ID", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_WIKI_DRAFT_PAGES_DRAFT_ID")
    @Column(name="DRAFT_PAGE_ID")
    private long id;
    @ManyToOne
    @JoinColumn(name="TARGET_PAGE_ID")
    private PageEntity targetPage;
    @ManyToOne
    @JoinColumn(name="PARENT_PAGE_ID")
    private PageEntity parentPage;
    @Column(name="TARGET_PAGE_REVISION")
    private String targetRevision;
    @Column(name="NEW_PAGE")
    private boolean newPage;
    @Column(name="LANG")
    private String lang;

    public PageEntity getTargetPage() {
        return this.targetPage;
    }

    public void setTargetPage(PageEntity targetPage) {
        this.targetPage = targetPage;
    }

    public PageEntity getParentPage() {
        return this.parentPage;
    }

    public void setParentPage(PageEntity parentPage) {
        this.parentPage = parentPage;
    }

    public String getTargetRevision() {
        return this.targetRevision;
    }

    public void setTargetRevision(String targetRevision) {
        this.targetRevision = targetRevision;
    }

    public boolean isNewPage() {
        return this.newPage;
    }

    public void setNewPage(boolean newPage) {
        this.newPage = newPage;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }
}

