/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.jpa.dao;

import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.wiki.jpa.dao.PageDAO;
import org.exoplatform.wiki.jpa.dao.WikiBaseDAO;
import org.exoplatform.wiki.jpa.dao.WikiDAO$AjcClosure1;
import org.exoplatform.wiki.jpa.entity.WikiEntity;
import org.exoplatform.wiki.model.WikiType;

public class WikiDAO
extends WikiBaseDAO<WikiEntity, Long> {
    private PageDAO pageDAO;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public WikiDAO(PageDAO pageDAO) {
        this.pageDAO = pageDAO;
    }

    public List<Long> findAllIds(int offset, int limit) {
        return this.getEntityManager().createNamedQuery("wiki.getAllIds", Long.class).setFirstResult(offset).setMaxResults(limit).getResultList();
    }

    public WikiEntity getWikiByTypeAndOwner(String wikiType, String wikiOwner) {
        if (wikiType.toUpperCase().equals(WikiType.GROUP.name())) {
            wikiOwner = this.validateGroupWikiOwner(wikiOwner);
        }
        TypedQuery query = this.getEntityManager().createNamedQuery("wiki.getWikiByTypeAndOwner", WikiEntity.class).setParameter("type", (Object)wikiType).setParameter("owner", (Object)wikiOwner);
        try {
            return (WikiEntity)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<WikiEntity> getWikisByType(String wikiType) {
        TypedQuery query = this.getEntityManager().createNamedQuery("wiki.getWikisByType", WikiEntity.class).setParameter("type", (Object)wikiType);
        return query.getResultList();
    }

    @ExoTransactional
    public void delete(WikiEntity entity) {
        WikiEntity wikiEntity = entity;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)wikiEntity);
        Object[] objectArray = new Object[]{this, wikiEntity, joinPoint};
        WikiDAO$AjcClosure1 wikiDAO$AjcClosure1 = new WikiDAO$AjcClosure1(objectArray);
        ExoTransactionalAspect.aspectOf().around(wikiDAO$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    static {
        WikiDAO.ajc$preClinit();
    }

    static final /* synthetic */ void delete_aroundBody0(WikiDAO ajc$this, WikiEntity entity, JoinPoint joinPoint) {
        if (entity.getWikiHome() != null) {
            ajc$this.pageDAO.delete(entity.getWikiHome());
        }
        entity.setWikiHome(null);
        super.delete((Object)entity);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("WikiDAO.java", WikiDAO.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "delete", "org.exoplatform.wiki.jpa.dao.WikiDAO", "org.exoplatform.wiki.jpa.entity.WikiEntity", "entity", "", "void"), 76);
    }
}

