/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.notes.service;

import io.meeds.notes.service.NotePageViewService;
import io.meeds.social.cms.service.CMSService;
import io.meeds.social.cms.service.CMSServiceImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Random;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.PageType;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.page.PageState;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.jpa.BaseTest;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.service.NoteService;
import org.junit.Assert;

public class NotePageViewServiceTest
extends BaseTest {
    protected static final Random RANDOM = new Random();
    private static final long USER_IDENTITY_ID = 5L;
    private static final String USERS_GROUP = "*:/platform/users";
    private static final String ADMINISTRATORS_GROUP = "*:/platform/administrators";
    private static final String USERNAME = "testUser";
    private NoteService noteService;
    private NotePageViewService notePageViewService;
    private CMSService cmsService;
    private LayoutService layoutService;
    private IdentityRegistry identityRegistry;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.notePageViewService = (NotePageViewService)this.getContainer().getComponentInstanceOfType(NotePageViewService.class);
        this.cmsService = (CMSService)this.getContainer().getComponentInstanceOfType(CMSServiceImpl.class);
        this.layoutService = (LayoutService)this.getContainer().getComponentInstanceOfType(LayoutService.class);
        this.identityRegistry = (IdentityRegistry)this.getContainer().getComponentInstanceOfType(IdentityRegistry.class);
        this.noteService = (NoteService)this.getContainer().getComponentInstanceOfType(NoteService.class);
    }

    public void testGetNotePageWithAnonim() throws IllegalAccessException, ObjectAlreadyExistsException, ObjectNotFoundException {
        NotePageViewServiceTest.assertNull((Object)this.notePageViewService.getNotePage("notExistingPage", null, null));
        String pageNoteName = "pageNoteName" + RANDOM.nextLong();
        String pageContent = "pageContent" + RANDOM.nextLong();
        String pageReference = this.createPage("pageName" + RANDOM.nextLong(), "Everyone", ADMINISTRATORS_GROUP);
        this.cmsService.saveSettingName("notePage", pageNoteName, pageReference, 0L, 5L);
        Page notePage = this.notePageViewService.getNotePage(pageNoteName, null, null);
        NotePageViewServiceTest.assertNull((Object)notePage);
        Assert.assertThrows(IllegalAccessException.class, () -> this.notePageViewService.saveNotePage(pageNoteName, pageContent, null, null));
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.notePageViewService.saveNotePage(pageNoteName + "22", pageContent, null, null));
        this.notePageViewService.saveNotePage(pageNoteName, pageContent, null, this.registerAdministratorUser(USERNAME));
        notePage = this.notePageViewService.getNotePage(pageNoteName, null, null);
        NotePageViewServiceTest.assertNotNull((Object)notePage);
        NotePageViewServiceTest.assertEquals((String)pageContent, (String)notePage.getContent());
    }

    public void testGetNotePageWithAuthenticated() throws IllegalAccessException, ObjectAlreadyExistsException, ObjectNotFoundException, WikiException {
        String pageNoteName = "pageNoteName" + RANDOM.nextLong();
        String pageContentEn = "pageContentEn" + RANDOM.nextLong();
        String pageContentFr = "pageContentFr" + RANDOM.nextLong();
        String pageReference = this.createPage("pageName" + RANDOM.nextLong(), USERS_GROUP, ADMINISTRATORS_GROUP);
        this.cmsService.saveSettingName("notePage", pageNoteName, pageReference, 0L, 5L);
        Assert.assertThrows(IllegalAccessException.class, () -> this.notePageViewService.getNotePage(pageNoteName, null, null));
        Page notePage = this.notePageViewService.getNotePage(pageNoteName, null, this.registerInternalUser(USERNAME));
        NotePageViewServiceTest.assertNull((Object)notePage);
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.notePageViewService.saveNotePage(pageNoteName + "22", pageContentEn, null, null));
        Assert.assertThrows(IllegalAccessException.class, () -> this.notePageViewService.saveNotePage(pageNoteName, pageContentEn, null, null));
        Assert.assertThrows(IllegalAccessException.class, () -> this.notePageViewService.saveNotePage(pageNoteName, pageContentEn, null, this.registerInternalUser(USERNAME)));
        this.notePageViewService.saveNotePage(pageNoteName, pageContentFr, null, this.registerAdministratorUser(USERNAME));
        this.notePageViewService.saveNotePage(pageNoteName, pageContentEn, "fr", this.registerAdministratorUser(USERNAME));
        Assert.assertThrows(IllegalAccessException.class, () -> this.notePageViewService.getNotePage(pageNoteName, null, null));
        notePage = this.notePageViewService.getNotePage(pageNoteName, null, this.registerInternalUser(USERNAME));
        NotePageViewServiceTest.assertNotNull((Object)notePage);
        NotePageViewServiceTest.assertEquals((String)pageContentEn, (String)notePage.getContent());
        notePage = this.notePageViewService.getNotePage(pageNoteName, "fr", this.registerInternalUser(USERNAME));
        NotePageViewServiceTest.assertNotNull((Object)notePage);
        NotePageViewServiceTest.assertEquals((String)pageContentEn, (String)notePage.getContent());
        this.notePageViewService.saveNotePage(pageNoteName, pageContentFr, "fr", this.registerAdministratorUser(USERNAME));
        notePage.setLang(null);
        notePage.setUpdatedDate(new Date());
        this.noteService.updateNote(notePage);
        notePage.setLang("fr");
        notePage.setContent(pageContentFr);
        this.noteService.createVersionOfNote(notePage, USERNAME);
        notePage = this.notePageViewService.getNotePage(pageNoteName, "fr", this.registerInternalUser(USERNAME));
        NotePageViewServiceTest.assertNotNull((Object)notePage);
        NotePageViewServiceTest.assertEquals((String)pageContentFr, (String)notePage.getContent());
        notePage = this.notePageViewService.getNotePage(pageNoteName, "it", this.registerInternalUser(USERNAME));
        NotePageViewServiceTest.assertNotNull((Object)notePage);
        NotePageViewServiceTest.assertEquals((String)pageContentEn, (String)notePage.getContent());
    }

    private String createPage(String pageName, String accessPermission, String editPermission) {
        String siteType = "portal";
        String siteName = "classic";
        if (this.layoutService.getPortalConfig(siteName) == null) {
            PortalConfig portal = new PortalConfig();
            portal.setType(siteType);
            portal.setName(siteName);
            portal.setLocale("en");
            portal.setLabel("Test");
            portal.setDescription("Test");
            portal.setAccessPermissions(new String[]{"Everyone"});
            this.layoutService.create(portal);
        }
        PageKey pageKey = new PageKey(siteType, siteName, pageName);
        PageState pageState = new PageState(pageName, null, false, false, null, Collections.singletonList(accessPermission), editPermission, Collections.singletonList(editPermission), Collections.singletonList(editPermission), PageType.PAGE.name(), null);
        this.layoutService.save(new PageContext(pageKey, pageState));
        return pageKey.format();
    }

    private Identity registerAdministratorUser(String user) {
        Identity identity = new Identity(user, Arrays.asList(new MembershipEntry("/platform/administrators")));
        this.identityRegistry.register(identity);
        return identity;
    }

    private Identity registerInternalUser(String username) {
        Identity identity = new Identity(username, Arrays.asList(new MembershipEntry("/platform/users")));
        this.identityRegistry.register(identity);
        return identity;
    }
}

