/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service.rest;

import io.meeds.notes.model.NoteFeaturedImage;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.rest.impl.EnvironmentContext;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.rest.api.EntityBuilder;
import org.exoplatform.social.rest.api.RestUtils;
import org.exoplatform.social.rest.entity.IdentityEntity;
import org.exoplatform.upload.UploadService;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.model.DraftPage;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.model.Wiki;
import org.exoplatform.wiki.service.BreadcrumbData;
import org.exoplatform.wiki.service.NoteService;
import org.exoplatform.wiki.service.NotesExportService;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.service.impl.BeanToJsons;
import org.exoplatform.wiki.service.rest.NotesRestService;
import org.exoplatform.wiki.service.search.SearchResult;
import org.exoplatform.wiki.service.search.WikiSearchData;
import org.exoplatform.wiki.tree.JsonNodeData;
import org.exoplatform.wiki.tree.TreeNode;
import org.exoplatform.wiki.tree.utils.TreeUtils;
import org.exoplatform.wiki.utils.Utils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.AdditionalAnswers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class NotesRestServiceTest
extends AbstractKernelTest {
    @Mock
    private NoteService noteService;
    @Mock
    private WikiService noteBookService;
    @Mock
    private UploadService uploadService;
    @Mock
    private IdentityManager identityManager;
    @Mock
    private NotesExportService notesExportService;
    private NotesRestService notesRestService;
    private ResourceBundleService resourceBundleService;
    @Mock
    private Identity identity;
    @Mock
    private SpaceService spaceService;
    private MockedStatic<ConversationState> conversationStateStatic;
    private MockedStatic<EnvironmentContext> environmentContextStatic;
    private MockedStatic<TreeUtils> treeUtilsStatic;
    private MockedStatic<Utils> utilsStatic;
    private MockedStatic<RestUtils> REST_UTILS;
    private MockedStatic<EntityBuilder> ENTITY_BUILDER;
    private MockedStatic<ExoContainerContext> containerContextStatic;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.conversationStateStatic = Mockito.mockStatic(ConversationState.class);
        this.environmentContextStatic = Mockito.mockStatic(EnvironmentContext.class);
        this.treeUtilsStatic = Mockito.mockStatic(TreeUtils.class);
        this.utilsStatic = Mockito.mockStatic(Utils.class);
        this.REST_UTILS = Mockito.mockStatic(RestUtils.class);
        this.ENTITY_BUILDER = Mockito.mockStatic(EntityBuilder.class);
        this.containerContextStatic = Mockito.mockStatic(ExoContainerContext.class);
        this.resourceBundleService = (ResourceBundleService)Mockito.mock(ResourceBundleService.class);
        ResourceBundle resourceBundle = (ResourceBundle)Mockito.mock(ResourceBundle.class);
        Mockito.when((Object)resourceBundle.getString(Mockito.anyString())).thenReturn((Object)("Notes" + System.currentTimeMillis()));
        Mockito.when((Object)this.resourceBundleService.getResourceBundle(Mockito.anyString(), (Locale)Mockito.any())).thenReturn((Object)resourceBundle);
        this.notesRestService = new NotesRestService(this.noteService, this.noteBookService, this.uploadService, this.identityManager, this.resourceBundleService, this.notesExportService);
        ConversationState currentConversationState = (ConversationState)Mockito.mock(ConversationState.class);
        this.conversationStateStatic.when(() -> ConversationState.getCurrent()).thenReturn((Object)currentConversationState);
        this.conversationStateStatic.when(() -> ConversationState.getCurrent().getIdentity()).thenReturn((Object)this.identity);
        EnvironmentContext environmentContext = (EnvironmentContext)Mockito.mock(EnvironmentContext.class);
        this.environmentContextStatic.when(() -> EnvironmentContext.getCurrent()).thenReturn((Object)environmentContext);
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getLocale()).thenReturn((Object)new Locale("en"));
        Mockito.when((Object)environmentContext.get(HttpServletRequest.class)).thenReturn((Object)request);
        ExoContainer exoContainer = (ExoContainer)Mockito.mock(ExoContainer.class);
        this.containerContextStatic.when(() -> ExoContainerContext.getCurrentContainer()).thenReturn((Object)exoContainer);
        Mockito.when((Object)((WikiService)exoContainer.getComponentInstanceOfType(WikiService.class))).thenReturn((Object)this.noteBookService);
        Mockito.when((Object)((NoteService)exoContainer.getComponentInstanceOfType(NoteService.class))).thenReturn((Object)this.noteService);
        Mockito.when((Object)((SpaceService)exoContainer.getComponentInstanceOfType(SpaceService.class))).thenReturn((Object)this.spaceService);
    }

    @After
    public void tearDown() throws Exception {
        this.conversationStateStatic.close();
        this.environmentContextStatic.close();
        this.treeUtilsStatic.close();
        this.utilsStatic.close();
        this.REST_UTILS.close();
        this.ENTITY_BUILDER.close();
        this.containerContextStatic.close();
        super.tearDown();
    }

    @Test
    public void testGetNote() throws WikiException, IllegalAccessException {
        Page homePage = new Page("home");
        homePage.setWikiOwner("user");
        homePage.setWikiType("WIKIHOME");
        homePage.setOwner("user");
        homePage.setId("1");
        homePage.setParentPageId("0");
        homePage.setHasChild(true);
        Wiki noteBook = new Wiki();
        noteBook.setOwner("user");
        noteBook.setType("WIKI");
        noteBook.setId("0");
        noteBook.setWikiHome(homePage);
        Mockito.when((Object)this.noteBookService.getWikiByTypeAndOwner("group", "/spaces/test")).thenReturn((Object)noteBook);
        Page page = new Page();
        page.setId("1");
        page.setName("note1");
        page.setActivityId("1");
        page.setLang("en");
        page.setUrl("/space/test/notes/1");
        page.setContent("<h3>test</h3>");
        Mockito.when((Object)this.noteService.getNoteOfNoteBookByName("group", "/spaces/test", "1", this.identity, "source")).thenReturn((Object)page);
        ArrayList<BreadcrumbData> breadcrumb = new ArrayList<BreadcrumbData>();
        breadcrumb.add(new BreadcrumbData("1", "test", "note", "user"));
        Mockito.when((Object)this.noteService.getNoteByIdAndLang(Long.valueOf(1L), this.identity, "source", "en")).thenReturn((Object)page);
        Mockito.when((Object)this.noteService.getBreadCrumb("group", "/spaces/test", "1", "en", this.identity, false)).thenReturn(breadcrumb);
        Response response = this.notesRestService.getNote("group", "/spaces/test", "1", "source", "en");
        NotesRestServiceTest.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        Page fetchedNote = (Page)response.getEntity();
        NotesRestServiceTest.assertEquals((String)page.getName(), (String)fetchedNote.getName());
        ((NoteService)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalAccessException("Fake Exception")}).when((Object)this.noteService)).getNoteByIdAndLang(Long.valueOf(1L), this.identity, "source", "en");
        Response response1 = this.notesRestService.getNote("group", "/spaces/test", "1", "source", "en");
        NotesRestServiceTest.assertEquals((int)Response.Status.UNAUTHORIZED.getStatusCode(), (int)response1.getStatus());
        ((NoteService)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalStateException("Fake Exception")}).when((Object)this.noteService)).getNoteByIdAndLang(Long.valueOf(1L), this.identity, "source", "en");
        Response response2 = this.notesRestService.getNote("group", "/spaces/test", "1", "source", "en");
        NotesRestServiceTest.assertEquals((int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (int)response2.getStatus());
    }

    @Test
    public void testGetNoteById() throws WikiException, IllegalAccessException {
        Page page = new Page();
        ArrayList<Page> children = new ArrayList<Page>();
        children.add(new Page("child1"));
        ArrayList<BreadcrumbData> breadcrumb = new ArrayList<BreadcrumbData>();
        breadcrumb.add(new BreadcrumbData("1", "test", "note", "user"));
        page.setDeleted(true);
        Mockito.when((Object)this.noteService.getNoteByIdAndLang(Long.valueOf(1L), this.identity, "source", null)).thenReturn(null);
        Response response = this.notesRestService.getNoteById("1", "note", "user", true, "source", "en");
        NotesRestServiceTest.assertEquals((int)Response.Status.NOT_FOUND.getStatusCode(), (int)response.getStatus());
        Mockito.when((Object)this.noteService.getNoteByIdAndLang(Long.valueOf(1L), this.identity, "source", "en")).thenReturn((Object)page);
        Response response1 = this.notesRestService.getNoteById("1", "note", "user", true, "source", "en");
        NotesRestServiceTest.assertEquals((int)Response.Status.NOT_FOUND.getStatusCode(), (int)response1.getStatus());
        page.setDeleted(false);
        page.setWikiType("type");
        Response response2 = this.notesRestService.getNoteById("1", "note", "user", true, "source", "en");
        NotesRestServiceTest.assertEquals((int)Response.Status.NOT_FOUND.getStatusCode(), (int)response2.getStatus());
        page.setWikiType("note");
        page.setWikiOwner("owner");
        Response response3 = this.notesRestService.getNoteById("1", "note", "user", true, "source", "en");
        NotesRestServiceTest.assertEquals((int)Response.Status.NOT_FOUND.getStatusCode(), (int)response3.getStatus());
        page.setWikiOwner("user");
        page.setContent("any wiki-children-pages ck-widget any");
        Mockito.when((Object)this.identity.getUserId()).thenReturn((Object)"userId");
        Mockito.when((Object)this.noteService.getChildrenNoteOf(page, false, true)).thenReturn(children);
        Mockito.when((Object)this.noteService.getBreadCrumb("note", "user", "1", false)).thenReturn(breadcrumb);
        Mockito.when((Object)this.noteService.updateNote(page)).thenReturn((Object)page);
        Response response4 = this.notesRestService.getNoteById("1", "note", "user", true, "source", "en");
        NotesRestServiceTest.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response4.getStatus());
        ((NoteService)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalAccessException("Fake Exception")}).when((Object)this.noteService)).getNoteByIdAndLang(Long.valueOf(1L), this.identity, "source", "en");
        Response response5 = this.notesRestService.getNoteById("1", "note", "user", true, "source", "en");
        NotesRestServiceTest.assertEquals((int)Response.Status.UNAUTHORIZED.getStatusCode(), (int)response5.getStatus());
        ((NoteService)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalStateException("Fake Exception")}).when((Object)this.noteService)).getNoteByIdAndLang(Long.valueOf(1L), this.identity, "source", "en");
        Response response6 = this.notesRestService.getNoteById("1", "note", "user", true, "source", "en");
        NotesRestServiceTest.assertEquals((int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (int)response6.getStatus());
    }

    @Test
    public void testGetFullTreeData() throws Exception {
        Page homePage = new Page("home");
        homePage.setWikiOwner("user");
        homePage.setWikiType("WIKIHOME");
        homePage.setOwner("user");
        homePage.setId("1");
        homePage.setParentPageId("0");
        homePage.setHasChild(true);
        Wiki noteBook = new Wiki();
        noteBook.setOwner("user");
        noteBook.setType("WIKI");
        noteBook.setId("0");
        noteBook.setWikiHome(homePage);
        Page page = new Page("testPage");
        page.setName("testPage");
        page.setTitle("testPage");
        page.setId("10");
        page.setParentPageId("1");
        page.setWikiType("PAGE");
        Page page1 = new Page("testPage 1");
        page1.setName("testPage 1");
        page1.setTitle("testPage 1");
        page1.setId("11");
        page1.setParentPageId("1");
        page1.setWikiType("PAGE");
        Page page2 = new Page("testPage 2");
        page2.setName("testPage 22");
        page2.setTitle("testPage 22");
        page2.setId("12");
        page2.setParentPageId("1");
        page2.setWikiType("PAGE");
        Page page10 = new Page("testPage 10");
        page10.setName("testPage 10");
        page10.setTitle("testPage 10");
        page10.setId("13");
        page10.setParentPageId("1");
        page10.setWikiType("PAGE");
        Page page12 = new Page("testPage 12");
        page12.setName("testPage 2");
        page12.setTitle("testPage 2");
        page12.setId("14");
        page12.setParentPageId("1");
        page12.setWikiType("PAGE");
        DraftPage draftPage = new DraftPage();
        draftPage.setId("3");
        draftPage.setName("testPageDraft");
        page.setWikiType("PAGE");
        draftPage.setParentPageId("1");
        draftPage.setDraftPage(true);
        draftPage.setWikiType("PAGE");
        WikiPageParams pageParams = new WikiPageParams();
        pageParams.setPageName("home");
        pageParams.setOwner("user");
        pageParams.setType("WIKI");
        ArrayList<Page> childrenWithDraft = new ArrayList<Page>(List.of(page, draftPage, page10, page12, page2, page1));
        ArrayList<Page> childrenWithoutDrafts = new ArrayList<Page>(List.of(page12, page10, page1, page, page2));
        Deque paramsDeque = (Deque)Mockito.mock(Deque.class);
        Mockito.when((Object)this.identity.getUserId()).thenReturn((Object)"1");
        this.treeUtilsStatic.when(() -> TreeUtils.getPageParamsFromPath((String)"path")).thenReturn((Object)pageParams);
        this.utilsStatic.when(() -> Utils.getStackParams((Page)homePage)).thenReturn((Object)paramsDeque);
        Mockito.when(paramsDeque.pop()).thenReturn((Object)pageParams);
        Mockito.when((Object)this.noteService.getNoteOfNoteBookByName(pageParams.getType(), pageParams.getOwner(), pageParams.getPageName(), this.identity)).thenReturn(null);
        Mockito.when((Object)this.noteService.getNoteOfNoteBookByName(pageParams.getType(), pageParams.getOwner(), "Home")).thenReturn((Object)homePage);
        Mockito.when((Object)this.noteBookService.getWikiByTypeAndOwner(pageParams.getType(), pageParams.getOwner())).thenReturn((Object)noteBook);
        Mockito.when((Object)this.noteBookService.getWikiByTypeAndOwner(homePage.getWikiType(), homePage.getWikiOwner())).thenReturn((Object)noteBook);
        Mockito.when((Object)this.noteService.getChildrenNoteOf(homePage, true, false)).thenReturn(childrenWithDraft);
        Mockito.when((Object)this.noteService.getChildrenNoteOf(homePage, false, false)).thenReturn(childrenWithoutDrafts);
        this.treeUtilsStatic.when(() -> TreeUtils.getPathFromPageParams((WikiPageParams)((WikiPageParams)Mockito.any()))).thenCallRealMethod();
        this.treeUtilsStatic.when(() -> TreeUtils.tranformToJson((TreeNode)((TreeNode)Mockito.any()), (HashMap)((HashMap)Mockito.any()))).thenCallRealMethod();
        this.utilsStatic.when(() -> Utils.validateWikiOwner((String)homePage.getWikiType(), (String)homePage.getWikiOwner())).thenCallRealMethod();
        this.utilsStatic.when(() -> Utils.getObjectFromParams((WikiPageParams)pageParams)).thenReturn((Object)homePage);
        this.utilsStatic.when(() -> Utils.isDescendantPage((Page)homePage, (Page)page)).thenReturn((Object)true);
        this.utilsStatic.when(() -> Utils.isDescendantPage((Page)homePage, (Page)page1)).thenReturn((Object)true);
        this.utilsStatic.when(() -> Utils.isDescendantPage((Page)homePage, (Page)page2)).thenReturn((Object)true);
        this.utilsStatic.when(() -> Utils.isDescendantPage((Page)homePage, (Page)page10)).thenReturn((Object)true);
        this.utilsStatic.when(() -> Utils.isDescendantPage((Page)homePage, (Page)page12)).thenReturn((Object)true);
        this.utilsStatic.when(() -> NotesRestServiceTest.lambda$testGetFullTreeData$15(homePage, (Page)draftPage)).thenReturn((Object)true);
        this.utilsStatic.when(() -> Utils.canManageNotes((String)Mockito.anyString(), (Space)((Space)Mockito.any(Space.class)), (Page)((Page)Mockito.any(Page.class)))).thenReturn((Object)true);
        Mockito.when((Object)this.spaceService.getSpaceByGroupId(Mockito.anyString())).thenReturn((Object)((Space)Mockito.mock(Space.class)));
        this.treeUtilsStatic.when(() -> TreeUtils.cleanDraftChildren((List)Mockito.anyList(), (Locale)((Locale)Mockito.any()))).then(AdditionalAnswers.returnsFirstArg());
        Response response = this.notesRestService.getFullTreeData("path", Boolean.valueOf(true));
        NotesRestServiceTest.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        Response response3 = this.notesRestService.getFullTreeData("path", Boolean.valueOf(false));
        NotesRestServiceTest.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response3.getStatus());
        NotesRestServiceTest.assertEquals((int)6, (int)((BeanToJsons)response3.getEntity()).getJsonList().size());
        List treeNodeList = ((BeanToJsons)response3.getEntity()).getTreeNodeData();
        JsonNodeData jsonNodeData = (JsonNodeData)treeNodeList.get(0);
        NotesRestServiceTest.assertEquals((int)5, (int)jsonNodeData.getChildren().size());
        NotesRestServiceTest.assertEquals((String)"testPage", (String)((JsonNodeData)jsonNodeData.getChildren().get(0)).getName());
        NotesRestServiceTest.assertEquals((String)"testPage 1", (String)((JsonNodeData)jsonNodeData.getChildren().get(1)).getName());
        NotesRestServiceTest.assertEquals((String)"testPage 2", (String)((JsonNodeData)jsonNodeData.getChildren().get(2)).getName());
        NotesRestServiceTest.assertEquals((String)"testPage 10", (String)((JsonNodeData)jsonNodeData.getChildren().get(3)).getName());
        NotesRestServiceTest.assertEquals((String)"testPage 22", (String)((JsonNodeData)jsonNodeData.getChildren().get(4)).getName());
        ((NoteService)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalAccessException()}).when((Object)this.noteService)).getNoteOfNoteBookByName(pageParams.getType(), pageParams.getOwner(), pageParams.getPageName(), this.identity);
        Response response1 = this.notesRestService.getFullTreeData("path", Boolean.valueOf(true));
        NotesRestServiceTest.assertEquals((int)Response.Status.UNAUTHORIZED.getStatusCode(), (int)response1.getStatus());
        ((NoteService)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.noteService)).getNoteOfNoteBookByName(pageParams.getType(), pageParams.getOwner(), pageParams.getPageName(), this.identity);
        Response response2 = this.notesRestService.getFullTreeData("path", Boolean.valueOf(true));
        NotesRestServiceTest.assertEquals((int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (int)response2.getStatus());
    }

    @Test
    public void testGetPageAvailableTranslationLanguages() throws WikiException {
        ArrayList<String> langs = new ArrayList<String>();
        langs.add("ar");
        langs.add("en");
        Response response = this.notesRestService.getPageAvailableTranslationLanguages(null, Boolean.valueOf(false));
        NotesRestServiceTest.assertEquals((int)Response.Status.BAD_REQUEST.getStatusCode(), (int)response.getStatus());
        Mockito.when((Object)this.identity.getUserId()).thenReturn((Object)"1");
        Mockito.when((Object)this.noteService.getPageAvailableTranslationLanguages(Long.valueOf(1L), false)).thenReturn(langs);
        response = this.notesRestService.getPageAvailableTranslationLanguages(Long.valueOf(1L), Boolean.valueOf(false));
        NotesRestServiceTest.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        ((NoteService)Mockito.doThrow((Throwable[])new Throwable[]{new WikiException()}).when((Object)this.noteService)).getPageAvailableTranslationLanguages(Long.valueOf(2L), false);
        response = this.notesRestService.getPageAvailableTranslationLanguages(Long.valueOf(2L), Boolean.valueOf(false));
        NotesRestServiceTest.assertEquals((int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (int)response.getStatus());
    }

    @Test
    public void testSearchData() throws Exception {
        UriInfo uriInfo = (UriInfo)Mockito.mock(UriInfo.class);
        Mockito.when((Object)uriInfo.getPath()).thenReturn((Object)"uriPath");
        this.REST_UTILS.when(() -> RestUtils.getLimit((UriInfo)uriInfo)).thenReturn((Object)10);
        Mockito.when((Object)this.identity.getUserId()).thenReturn((Object)"1");
        SearchResult searchResult = new SearchResult();
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        searchResult.setTitle("title");
        searchResult.setCreatedDate(Calendar.getInstance());
        searchResult.setUpdatedDate(Calendar.getInstance());
        searchResult.setWikiType("wikiType");
        searchResult.setWikiOwner("wikiOwner");
        searchResult.setPageName("test");
        searchResult.setLang("en");
        org.exoplatform.social.core.identity.model.Identity socialIdentity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        searchResult.setPoster(socialIdentity);
        results.add(searchResult);
        PageList pageList = (PageList)Mockito.mock(PageList.class);
        Mockito.when((Object)pageList.getAll()).thenReturn(results);
        Mockito.when((Object)this.noteService.search((WikiSearchData)Mockito.any())).thenReturn((Object)pageList);
        Page page = new Page();
        page.setId("100");
        page.setActivityId("12");
        page.setLang("en");
        page.setUrl("/space/note/100");
        Mockito.when((Object)this.noteService.getNoteOfNoteBookByName(searchResult.getWikiType(), searchResult.getWikiOwner(), searchResult.getPageName(), "en", this.identity)).thenReturn((Object)page);
        IdentityEntity identityEntity = (IdentityEntity)Mockito.mock(IdentityEntity.class);
        this.ENTITY_BUILDER.when(() -> EntityBuilder.buildEntityIdentity((org.exoplatform.social.core.identity.model.Identity)((org.exoplatform.social.core.identity.model.Identity)Mockito.any(org.exoplatform.social.core.identity.model.Identity.class)), (String)Mockito.anyString(), (String)Mockito.anyString())).thenReturn((Object)identityEntity);
        Response response = this.notesRestService.searchData(uriInfo, "test", 10, "wikiType", "wikiOwner", true, new ArrayList());
        NotesRestServiceTest.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
    }

    @Test
    public void getFeaturedImageIllustration() throws Exception {
        Request request = (Request)Mockito.mock(Request.class);
        Response response = this.notesRestService.getFeaturedImageIllustration(request, null, false, null, null, 0L);
        NotesRestServiceTest.assertEquals((int)Response.Status.BAD_REQUEST.getStatusCode(), (int)response.getStatus());
        this.REST_UTILS.when(RestUtils::getCurrentUserIdentityId).thenReturn((Object)1L);
        NoteFeaturedImage noteFeaturedImage = new NoteFeaturedImage();
        noteFeaturedImage.setId(Long.valueOf(123L));
        noteFeaturedImage.setLastUpdated(Long.valueOf(new Date().getTime()));
        noteFeaturedImage.setMimeType("image/png");
        Mockito.when((Object)this.noteService.getNoteFeaturedImageInfo(Long.valueOf(1L), null, false, "150x150", 1L)).thenReturn((Object)noteFeaturedImage);
        response = this.notesRestService.getFeaturedImageIllustration(request, Long.valueOf(1L), false, null, "150x150", 12359547L);
        NotesRestServiceTest.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        Mockito.when((Object)this.noteService.getNoteFeaturedImageInfo(Long.valueOf(1L), null, false, "150x150", 1L)).thenThrow(new Throwable[]{new ObjectNotFoundException("note not found")});
        response = this.notesRestService.getFeaturedImageIllustration(request, Long.valueOf(1L), false, null, "150x150", 12359547L);
        NotesRestServiceTest.assertEquals((int)Response.Status.NOT_FOUND.getStatusCode(), (int)response.getStatus());
        Mockito.reset((Object[])new NoteService[]{this.noteService});
        Mockito.when((Object)this.noteService.getNoteFeaturedImageInfo(Long.valueOf(1L), null, false, "150x150", 1L)).thenThrow(new Throwable[]{new RuntimeException()});
        response = this.notesRestService.getFeaturedImageIllustration(request, Long.valueOf(1L), false, null, "150x150", 12359547L);
        NotesRestServiceTest.assertEquals((int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (int)response.getStatus());
    }

    private static /* synthetic */ void lambda$testGetFullTreeData$15(Page homePage, Page draftPage) throws Throwable {
        Utils.isDescendantPage((Page)homePage, (Page)draftPage);
    }
}

