/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.tree.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.localization.LocaleContextInfoUtils;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.model.PermissionType;
import org.exoplatform.wiki.model.Wiki;
import org.exoplatform.wiki.service.NoteService;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.tree.JsonNodeData;
import org.exoplatform.wiki.tree.PageTreeNode;
import org.exoplatform.wiki.tree.SpaceTreeNode;
import org.exoplatform.wiki.tree.TreeNode;
import org.exoplatform.wiki.tree.TreeNodeType;
import org.exoplatform.wiki.tree.WikiHomeTreeNode;
import org.exoplatform.wiki.tree.WikiTreeNode;
import org.exoplatform.wiki.utils.Utils;

public class TreeUtils {
    private static ResourceBundleService resourceBundleService;

    public static TreeNode getTreeNode(WikiPageParams params) throws Exception {
        Object wikiObject = Utils.getObjectFromParams(params);
        if (wikiObject instanceof Page) {
            Page page = (Page)wikiObject;
            if (params.getPageName().equals("Home")) {
                WikiHomeTreeNode wikiHomeNode = new WikiHomeTreeNode(page);
                return wikiHomeNode;
            }
            PageTreeNode pageNode = new PageTreeNode(page);
            return pageNode;
        }
        if (wikiObject instanceof Wiki) {
            Wiki wiki = (Wiki)wikiObject;
            WikiTreeNode wikiNode = new WikiTreeNode(wiki);
            return wikiNode;
        }
        if (wikiObject instanceof String) {
            SpaceTreeNode spaceNode = new SpaceTreeNode((String)wikiObject);
            return spaceNode;
        }
        return new TreeNode();
    }

    public static TreeNode getDescendants(WikiPageParams params, Map<String, Object> context, String userId) throws Exception {
        TreeNode treeNode = TreeUtils.getTreeNode(params);
        treeNode.pushDescendants(context, userId);
        return treeNode;
    }

    public static List<JsonNodeData> tranformToJson(TreeNode treeNode, Map<String, Object> context, Identity identity, Locale locale) throws Exception {
        NoteService noteService = (NoteService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(NoteService.class);
        int counter = 1;
        Boolean showExcerpt = false;
        Page currentPage = null;
        String currentPath = null;
        Boolean canEdit = false;
        if (context != null) {
            currentPath = (String)context.get("page");
            currentPage = (Page)context.get("currentPage");
            showExcerpt = (Boolean)context.get("excerpt");
            canEdit = (Boolean)context.get("canEdit");
        }
        ArrayList<JsonNodeData> children = new ArrayList<JsonNodeData>();
        for (TreeNode child : treeNode.getChildren()) {
            boolean isLastNode = counter >= treeNode.getChildren().size();
            JsonNodeData jsonNodeData = TreeUtils.toJsonNodeData(child, currentPath, currentPage, context, canEdit, isLastNode, identity, locale, noteService);
            TreeUtils.encodeWikiTreeNode(jsonNodeData, locale, identity, noteService);
            String excerpt = null;
            if (showExcerpt != null && showExcerpt.booleanValue()) {
                WikiPageParams params = TreeUtils.getPageParamsFromPath(child.getPath());
                excerpt = "";
            }
            jsonNodeData.setExcerpt(excerpt);
            children.add(jsonNodeData);
            ++counter;
        }
        return children;
    }

    public static WikiPageParams getPageParamsFromPath(String path) throws Exception {
        if (path == null) {
            return null;
        }
        WikiPageParams result = new WikiPageParams();
        if ((path = path.trim()).indexOf("/") < 0) {
            result.setType(path);
        } else {
            String[] array = path.split("/");
            result.setType(array[0]);
            if (array.length < 3) {
                result.setOwner(array[1]);
            } else if (array.length >= 3) {
                if (array[0].equals(PortalConfig.GROUP_TYPE)) {
                    OrganizationService oService = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);
                    String groupId = path.substring(path.indexOf("/"));
                    if (oService.getGroupHandler().findGroupById(groupId) != null) {
                        result.setOwner(groupId);
                    } else {
                        String pageName = path.substring(path.lastIndexOf("/") + 1);
                        if (StringUtils.isBlank((CharSequence)pageName)) {
                            pageName = "Home";
                        }
                        result.setPageName(pageName);
                        String owner = path.substring(path.indexOf("/"), path.lastIndexOf("/"));
                        while (oService.getGroupHandler().findGroupById(owner) == null) {
                            owner = owner.substring(0, owner.lastIndexOf("/"));
                        }
                        result.setOwner(owner);
                    }
                } else {
                    result.setOwner(array[1]);
                    result.setPageName(array[array.length - 1]);
                }
            }
        }
        return result;
    }

    public static String getPathFromPageParams(WikiPageParams param) {
        StringBuilder sb = new StringBuilder();
        if (param.getType() != null) {
            sb.append(param.getType());
        }
        if (param.getOwner() != null) {
            sb.append("/").append(Utils.validateWikiOwner(param.getType(), param.getOwner()));
        }
        if (param.getPageName() != null) {
            sb.append("/").append(param.getPageName());
        }
        return sb.toString();
    }

    public static List<JsonNodeData> cleanDraftChildren(List<JsonNodeData> children, Locale locale) {
        ArrayList<Locale> localesList = new ArrayList<Locale>(LocaleContextInfoUtils.getSupportedLocales());
        Map<String, List<JsonNodeData>> childrenByTarget = children.stream().filter(jsonNodeData -> jsonNodeData.getTargetPageId() != null).collect(Collectors.groupingBy(JsonNodeData::getTargetPageId));
        List<JsonNodeData> cleanedChildren = children.stream().filter(jsonNodeData -> !jsonNodeData.isDraftPage() || StringUtils.isEmpty((CharSequence)jsonNodeData.getTargetPageId())).collect(Collectors.toList());
        for (Map.Entry<String, List<JsonNodeData>> entry : childrenByTarget.entrySet()) {
            String target = entry.getKey();
            List<JsonNodeData> subJsonNodeDataList = entry.getValue();
            if (StringUtils.isNotEmpty((CharSequence)target) && subJsonNodeDataList.size() > 1) {
                JsonNodeData currentLangDraft = null;
                JsonNodeData originalLangDraft = null;
                JsonNodeData anyLangDraft = null;
                for (JsonNodeData nodeData : subJsonNodeDataList) {
                    if (StringUtils.isEmpty((CharSequence)nodeData.getLang())) {
                        originalLangDraft = nodeData;
                        continue;
                    }
                    if (nodeData.getLang().equals(locale.getLanguage())) {
                        currentLangDraft = nodeData;
                        continue;
                    }
                    if (anyLangDraft != null && TreeUtils.getLocatedLangDisplayName(localesList, locale, nodeData.getLang()).compareToIgnoreCase(TreeUtils.getLocatedLangDisplayName(localesList, locale, anyLangDraft.getLang())) >= 0) continue;
                    anyLangDraft = nodeData;
                }
                cleanedChildren.add(Optional.ofNullable(currentLangDraft).orElse(((JsonNodeData)Optional.ofNullable(originalLangDraft).orElse(anyLangDraft))));
                continue;
            }
            cleanedChildren.addAll(subJsonNodeDataList);
        }
        return cleanedChildren;
    }

    public static String getLocatedLangDisplayName(List<Locale> localesList, Locale currentLocale, String lang) {
        for (Locale locale : localesList) {
            if (!locale.getLanguage().equals(lang)) continue;
            return locale.getDisplayName(currentLocale);
        }
        return lang;
    }

    public static JsonNodeData toJsonNodeData(TreeNode node, String path, Page currentPage, Map<String, Object> context, Boolean canEdit, Boolean isLastNode, Identity identity, Locale locale, NoteService noteService) throws Exception {
        boolean isSelectable = true;
        if (node.getNodeType().equals((Object)TreeNodeType.WIKI)) {
            isSelectable = false;
        } else if (node.getNodeType().equals((Object)TreeNodeType.PAGE)) {
            page = ((PageTreeNode)node).getPage();
            if (currentPage != null && (currentPage.equals(page) || Utils.isDescendantPage(page, currentPage))) {
                isSelectable = false;
            }
            if (!noteService.hasPermissionOnPage(page, PermissionType.VIEWPAGE, ConversationState.getCurrent().getIdentity())) {
                isSelectable = false;
                node.setRetricted(true);
            }
            if (BooleanUtils.isTrue((Boolean)canEdit) && !noteService.hasPermissionOnPage(page, PermissionType.EDITPAGE, ConversationState.getCurrent().getIdentity())) {
                isSelectable = false;
                node.setRetricted(true);
            }
        } else if (node.getNodeType().equals((Object)TreeNodeType.WIKIHOME)) {
            page = ((WikiHomeTreeNode)node).getWikiHome();
            if (!noteService.hasPermissionOnPage(page, PermissionType.VIEWPAGE, ConversationState.getCurrent().getIdentity())) {
                isSelectable = false;
                node.setRetricted(true);
            }
            if (BooleanUtils.isTrue((Boolean)canEdit) && !noteService.hasPermissionOnPage(page, PermissionType.EDITPAGE, ConversationState.getCurrent().getIdentity())) {
                isSelectable = false;
                node.setRetricted(true);
            }
        }
        JsonNodeData jsonNodeData = new JsonNodeData(node, isLastNode, isSelectable, path, "", context, identity, locale);
        TreeUtils.encodeWikiTreeNode(jsonNodeData, locale, identity, noteService);
        return jsonNodeData;
    }

    private static void encodeWikiTreeNode(JsonNodeData nodeData, Locale locale, Identity identity, NoteService noteService) throws Exception {
        Page page;
        ResourceBundle resourceBundle = TreeUtils.getResourceBundleService().getResourceBundle("locale.wiki.service.WikiService", locale);
        String untitledLabel = resourceBundle.getString("Page.Untitled");
        if (StringUtils.isBlank((CharSequence)nodeData.getName())) {
            nodeData.setName(untitledLabel);
        } else if (!nodeData.isDraftPage() && (page = noteService.getNoteByIdAndLang(Long.valueOf(nodeData.getNoteId()), identity, "", locale.getLanguage())) != null) {
            nodeData.setName(page.getTitle());
        }
    }

    private static ResourceBundleService getResourceBundleService() {
        if (resourceBundleService == null) {
            resourceBundleService = (ResourceBundleService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ResourceBundleService.class);
        }
        return resourceBundleService;
    }
}

