/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.jpa.BaseTest;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.model.Wiki;
import org.exoplatform.wiki.service.WikiService;

public class TestWikiService
extends BaseTest {
    private WikiService wService;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.wService = (WikiService)this.getContainer().getComponentInstanceOfType(WikiService.class);
        this.getOrCreateWiki(this.wService, PortalConfig.PORTAL_TYPE, "classic");
    }

    public void testWikiService() {
        TestWikiService.assertNotNull((Object)this.wService);
    }

    public void testCreateWiki() throws WikiException {
        Wiki wiki = this.wService.getWikiByTypeAndOwner(PortalConfig.PORTAL_TYPE, "wiki1");
        TestWikiService.assertNull((Object)wiki);
        this.getOrCreateWiki(this.wService, PortalConfig.PORTAL_TYPE, "wiki1");
        wiki = this.wService.getWikiByTypeAndOwner(PortalConfig.PORTAL_TYPE, "wiki1");
        TestWikiService.assertNotNull((Object)wiki);
    }

    public void testCreateWikiPermissions() throws Exception {
        UserPortalConfigService portalConfigService = (UserPortalConfigService)this.getContainer().getComponentInstanceOfType(UserPortalConfigService.class);
        String defaultPortal = portalConfigService.getMetaPortal();
        Wiki siteWiki = this.getOrCreateWiki(this.wService, PortalConfig.PORTAL_TYPE, defaultPortal);
        TestWikiService.assertNotNull((Object)siteWiki);
        TestWikiService.assertTrue((boolean)siteWiki.getPermissions().stream().noneMatch(permission -> StringUtils.equals((CharSequence)permission.getId(), (CharSequence)IdentityConstants.ANY)));
        Page wikiHome = siteWiki.getWikiHome();
        TestWikiService.assertNotNull((Object)wikiHome);
        LayoutService layoutService = (LayoutService)this.getContainer().getComponentInstanceOfType(LayoutService.class);
        PortalConfig portalConfig = layoutService.getPortalConfig(defaultPortal);
        TestWikiService.assertNotNull((Object)portalConfig);
        List permissions = wikiHome.getPermissions();
        TestWikiService.assertNotNull((Object)permissions);
        TestWikiService.assertTrue((boolean)permissions.stream().noneMatch(permission -> StringUtils.equals((CharSequence)permission.getId(), (CharSequence)IdentityConstants.ANY)));
    }
}

