/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.integration.gamification;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.model.WikiType;
import org.exoplatform.wiki.service.PageUpdateType;
import org.exoplatform.wiki.service.listener.PageWikiListener;

@Asynchronous
public class GamificationWikiListener
extends PageWikiListener {
    public static final String GAMIFICATION_WIKI_ADD_PAGE = "addWikiPage";
    public static final String GAMIFICATION_WIKI_UPDATE_PAGE = "updateWikiPage";
    public static final String NOTES_OBJECT_TYPE = "notes";
    protected IdentityManager identityManager;
    protected ListenerService listenerService;
    protected SpaceService spaceService;

    public GamificationWikiListener(IdentityManager identityManager, ListenerService listenerService, SpaceService spaceService) {
        this.identityManager = identityManager;
        this.listenerService = listenerService;
        this.spaceService = spaceService;
    }

    @Override
    public void postAddPage(String wikiType, String wikiOwner, String pageId, Page page) {
        if ("Home".equals(pageId)) {
            return;
        }
        if (ConversationState.getCurrent() != null) {
            String actorUsername = ConversationState.getCurrent().getIdentity().getUserId();
            String actorId = this.identityManager.getOrCreateUserIdentity(actorUsername).getId();
            this.createGamificationRealization(actorId, actorId, GAMIFICATION_WIKI_ADD_PAGE, page.getId(), wikiOwner, wikiType);
        }
    }

    @Override
    public void postUpdatePage(String wikiType, String wikiOwner, String pageId, Page page, PageUpdateType wikiUpdateType) {
        if (page != null && wikiUpdateType != null && (wikiUpdateType.equals((Object)PageUpdateType.ADD_PAGE) || wikiUpdateType.equals((Object)PageUpdateType.EDIT_PAGE_CONTENT) || wikiUpdateType.equals((Object)PageUpdateType.EDIT_PAGE_CONTENT_AND_TITLE)) && ConversationState.getCurrent() != null) {
            String actorUsername = ConversationState.getCurrent().getIdentity().getUserId();
            String actorId = this.identityManager.getOrCreateUserIdentity(actorUsername).getId();
            this.createGamificationRealization(actorId, actorId, GAMIFICATION_WIKI_UPDATE_PAGE, page.getId(), wikiOwner, wikiType);
        }
    }

    private void createGamificationRealization(String earnerIdentityId, String receiverId, String gamificationEventName, String pageId, String wikiOwner, String wikiType) {
        Object eventDetails = "";
        if (StringUtils.isNotBlank((CharSequence)wikiOwner) && StringUtils.equalsIgnoreCase((CharSequence)WikiType.GROUP.name(), (CharSequence)wikiType)) {
            Space space = this.spaceService.getSpaceByGroupId(wikiOwner);
            eventDetails = "{spaceId: " + space.getId() + "}";
        }
        HashMap<String, Object> gam = new HashMap<String, Object>();
        try {
            gam.put("eventId", gamificationEventName);
            gam.put("objectId", pageId);
            gam.put("objectType", NOTES_OBJECT_TYPE);
            gam.put("senderId", earnerIdentityId);
            gam.put("receiverId", receiverId);
            gam.put("eventDetails", eventDetails);
            this.listenerService.broadcast("exo.gamification.generic.action", gam, null);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error triggering Gamification Listener Event: " + String.valueOf(gam), e);
        }
    }
}

