/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.notes.handler;

import io.meeds.notes.handler.TermsAndConditionsHandler;
import io.meeds.notes.service.TermsAndConditionsService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.WebAppController;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
class TermsAndConditionsHandlerTest {
    @Mock
    private TermsAndConditionsService termsService;
    @Mock
    private UserPortalConfigService portalConfigService;
    @Mock
    private WebAppController webAppController;
    @Mock
    private ControllerContext controllerContext;
    @Mock
    private HttpServletRequest httpRequest;
    @Mock
    private HttpServletResponse httpResponse;
    @InjectMocks
    private TermsAndConditionsHandler handler;

    TermsAndConditionsHandlerTest() {
    }

    @Test
    void testUserHasAcceptedTermsAndRequestIsForTermsPage() throws Exception {
        Mockito.when((Object)this.controllerContext.getRequest()).thenReturn((Object)this.httpRequest);
        Mockito.when((Object)this.controllerContext.getResponse()).thenReturn((Object)this.httpResponse);
        Mockito.when((Object)this.httpRequest.getRemoteUser()).thenReturn((Object)"testUser");
        Mockito.when((Object)this.httpRequest.getRequestURI()).thenReturn((Object)"/portal/terms-and-conditions");
        Mockito.when((Object)this.httpRequest.getQueryString()).thenReturn(null);
        Mockito.when((Object)this.httpRequest.getLocale()).thenReturn((Object)Locale.ENGLISH);
        Mockito.when((Object)this.termsService.isTermsAcceptedForUser("testUser", "en")).thenReturn((Object)true);
        Mockito.when((Object)this.portalConfigService.getMetaPortal()).thenReturn((Object)"classic");
        Mockito.when((Object)this.httpRequest.getContextPath()).thenReturn((Object)"/portal");
        boolean executed = this.handler.execute(this.controllerContext);
        ((HttpServletResponse)Mockito.verify((Object)this.httpResponse)).sendRedirect("/portal/classic/settings#terms-and-conditions");
        Assertions.assertTrue((boolean)executed);
    }

    @Test
    void testUserHasNotAcceptedTerms() throws Exception {
        Mockito.when((Object)this.controllerContext.getRequest()).thenReturn((Object)this.httpRequest);
        Mockito.when((Object)this.controllerContext.getResponse()).thenReturn((Object)this.httpResponse);
        Mockito.when((Object)this.httpRequest.getRemoteUser()).thenReturn((Object)"testUser");
        Mockito.when((Object)this.httpRequest.getRequestURI()).thenReturn((Object)"/portal/home");
        Mockito.when((Object)this.httpRequest.getLocale()).thenReturn((Object)Locale.ENGLISH);
        Mockito.when((Object)this.httpRequest.getContextPath()).thenReturn((Object)"/portal");
        Mockito.when((Object)this.httpRequest.getQueryString()).thenReturn(null);
        Mockito.when((Object)this.termsService.isTermsAcceptedForUser("testUser", "en")).thenReturn((Object)false);
        Mockito.when((Object)this.portalConfigService.getMetaPortal()).thenReturn((Object)"classic");
        boolean executed = this.handler.execute(this.controllerContext);
        String expectedRedirect = "/portal/classic/terms-and-conditions?redirect=" + URLEncoder.encode("/portal/home", StandardCharsets.UTF_8);
        ((HttpServletResponse)Mockito.verify((Object)this.httpResponse)).sendRedirect(expectedRedirect);
        Assertions.assertTrue((boolean)executed);
    }

    @Test
    void testAnonymousUser() throws Exception {
        Mockito.when((Object)this.controllerContext.getRequest()).thenReturn((Object)this.httpRequest);
        Mockito.when((Object)this.httpRequest.getRemoteUser()).thenReturn(null);
        boolean executed = this.handler.execute(this.controllerContext);
        ((HttpServletResponse)Mockito.verify((Object)this.httpResponse, (VerificationMode)Mockito.never())).sendRedirect(Mockito.anyString());
        Assertions.assertFalse((boolean)executed);
    }

    @Test
    void testExcludedUris() throws Exception {
        Mockito.when((Object)this.controllerContext.getRequest()).thenReturn((Object)this.httpRequest);
        Mockito.when((Object)this.httpRequest.getRequestURI()).thenReturn((Object)"/api/public/endpoint");
        Field excludedUrisField = TermsAndConditionsHandler.class.getDeclaredField("excludedUris");
        excludedUrisField.setAccessible(true);
        excludedUrisField.set(this.handler, List.of("/api/public"));
        boolean executed = this.handler.execute(this.controllerContext);
        ((HttpServletResponse)Mockito.verify((Object)this.httpResponse, (VerificationMode)Mockito.never())).sendRedirect(Mockito.anyString());
        Assertions.assertFalse((boolean)executed);
    }
}

